/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TransformationConcatenation;

public abstract class Transformation {
    public static final TransformationAffiliate NOP = TransformationAffiliate.newTransformationNOP();

    public static TransformationAffiliate createTransformation(Rectangle source, Rectangle target) {
        double scalingX = 1.0;
        if (source.w() > 1.0E-10 && target.w() > 1.0E-10) {
            scalingX = target.w() / source.w();
        }
        double scalingY = 1.0;
        if (source.h() > 1.0E-10 && target.h() > 1.0E-10) {
            scalingY = target.h() / source.h();
        }
        TransformationAffiliate scaling = TransformationAffiliate.newTransformationScaling(new GeoVector(scalingX, scalingY));
        Rectangle scaledSource = source.transform(scaling);
        TransformationAffiliate translation = TransformationAffiliate.newTransformationTranslation(new GeoVector(scaledSource.upperLeft, target.upperLeft));
        return scaling.transform(translation);
    }

    public abstract boolean isNOPTransformation();

    public abstract Transformation getInverse();

    public abstract Transformation getCopy();

    public Transformation transform(Transformation transformation) {
        Transformation result;
        assert (transformation != null);
        if (this instanceof TransformationAffiliate && transformation instanceof TransformationAffiliate) {
            TransformationAffiliate transformationAffiliate = (TransformationAffiliate)transformation;
            TransformationAffiliate thisTransformationAffiliate = (TransformationAffiliate)this;
            result = thisTransformationAffiliate.transform(transformationAffiliate);
        } else {
            TransformationConcatenation transformationConcatenation = new TransformationConcatenation(this);
            transformationConcatenation.addLast(transformation);
            result = transformationConcatenation;
        }
        return result;
    }

    protected abstract Point transform(Point var1);

    public abstract boolean isEqualTransformation(Transformation var1);
}

