/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Points {
    public static final Points NO_POINTS = new Points();
    private final ArrayList<Point> points;

    public Points() {
        this.points = new ArrayList();
    }

    public Points(int size) {
        this.points = new ArrayList(size);
    }

    public Points(Points points) {
        this.points = new ArrayList<Point>(points.points);
    }

    public int size() {
        return this.points.size();
    }

    public Point get(int index) {
        return this.points.get(index);
    }

    public Iterator<? extends Point> iterator() {
        return this.points.iterator();
    }

    public void add(Point point) {
        this.points.add(point);
    }

    public void remove(int index) {
        this.points.remove(index);
    }

    public void addPointIfDiffersFromLast(Point point) {
        Point lastPoint;
        assert (point != null);
        boolean toAdd = true;
        if (this.points.size() > 0 && (lastPoint = this.get(this.points.size() - 1)).equalsPoint(point)) {
            toAdd = false;
        }
        if (toAdd) {
            this.add(point);
        }
    }

    public void addAll(Points pointsToAdd) {
        this.points.addAll(pointsToAdd.points);
    }

    public void addAllIfDiffersFromLast(Points pointsToAdd) {
        assert (pointsToAdd != null);
        if (pointsToAdd.size() >= 1) {
            this.addPointIfDiffersFromLast(pointsToAdd.get(0));
        }
        int i = 1;
        while (i < pointsToAdd.size()) {
            this.add(pointsToAdd.get(i));
            ++i;
        }
    }

    public Rectangle getBounds() {
        if (this.size() == 0) {
            return null;
        }
        Point p = this.get(0);
        double minX = p.x;
        double maxX = p.x;
        double minY = p.y;
        double maxY = p.y;
        int i = 1;
        while (i < this.size()) {
            p = this.get(i);
            minX = Math.min(minX, p.x);
            maxX = Math.max(maxX, p.x);
            minY = Math.min(minY, p.y);
            maxY = Math.max(maxY, p.y);
            ++i;
        }
        return new Rectangle(minX, minY, maxX, maxY);
    }

    public Points turnPoints(Point center, double angle) {
        Points newPoints = new Points(this.size());
        int i = 0;
        while (i < this.size()) {
            Point p = this.get(i);
            newPoints.add(p.turnPoint(center, angle));
            ++i;
        }
        return newPoints;
    }

    public Points movePoints(GeoVector v) {
        Points newPoints = new Points(this.size());
        int i = 0;
        while (i < this.size()) {
            newPoints.add(this.get(i).movePoint(v));
            ++i;
        }
        return newPoints;
    }

    public Points transform(Transformation t) {
        Points newPoints = new Points(this.size());
        int i = 0;
        while (i < this.size()) {
            newPoints.add(this.get(i).transform(t));
            ++i;
        }
        return newPoints;
    }

    public boolean isInside(Point point) {
        return Points.isInside(point, this.points);
    }

    public static boolean isInside(Point point, List<? extends Point> pointList) {
        int pointListSize = pointList.size();
        if (pointListSize <= 2) {
            return false;
        }
        double angleSum = 0.0;
        double angle = 0.0;
        GeoVector from = new GeoVector(point, pointList.get(0));
        if (from.abs() < 1.0E-10) {
            return true;
        }
        int index = 1;
        while (index <= pointListSize) {
            GeoVector to = index < pointListSize ? new GeoVector(point, pointList.get(index)) : new GeoVector(point, pointList.get(0));
            if (to.abs() < 1.0E-10) {
                return true;
            }
            angle = GeoVector.angle(from, to);
            if (Math.abs(Math.abs(angle) - 180.0) < 1.0E-10) {
                return true;
            }
            angleSum += angle;
            from = to;
            ++index;
        }
        if (Math.abs(angleSum = (angleSum % 720.0 + 1440.0) % 720.0) > 359.9999999999 && Math.abs(angleSum) < 360.0000000001) {
            return true;
        }
        if (Math.abs(angleSum) < 1.0E-10 || Math.abs(angleSum) > 719.9999999999) {
            return false;
        }
        assert (false) : "Unexpected algorithmic failure";
        return false;
    }

    public boolean isNearBorder(Point point, double maxDistance, boolean closedDraw) {
        assert (point != null);
        assert (Geo.isZeroOrGreaterThanZero(maxDistance));
        if (this.size() < 2) {
            return new GeoVector(point, this.get(0)).abs() <= maxDistance;
        }
        Point from = this.get(0);
        Point to = this.get(0);
        int index = 1;
        while (index <= this.size()) {
            if (index < this.size()) {
                to = this.get(index);
            } else {
                if (!closedDraw) break;
                to = this.get(0);
            }
            if (Line.isNear(from, to, point, maxDistance)) {
                return true;
            }
            from = to;
            ++index;
        }
        return false;
    }

    public double getDistanceToBorder(Point point, boolean closedDraw) {
        assert (point != null);
        if (this.size() < 1) {
            return Double.NaN;
        }
        if (this.size() < 2) {
            return new GeoVector(this.get(0), point).abs();
        }
        Point from = this.get(0);
        Point to = this.get(0);
        double distance = Double.POSITIVE_INFINITY;
        int index = 1;
        while (index <= this.size()) {
            if (index < this.size()) {
                to = this.get(index);
            } else {
                if (!closedDraw) break;
                to = this.get(0);
            }
            double distanceToCurrent = Line.getDistance(from, to, point);
            if (distanceToCurrent < distance) {
                distance = distanceToCurrent;
            }
            from = to;
            ++index;
        }
        return distance;
    }

    public Point getNearestPoint(Point startPoint) {
        double distance = 0.0;
        Point nearestPoint = null;
        for (Point currentPoint : this.points) {
            double currentDistance = new GeoVector(currentPoint, startPoint).abs();
            if (nearestPoint != null && !(currentDistance < distance)) continue;
            distance = currentDistance;
            nearestPoint = currentPoint;
        }
        return nearestPoint;
    }

    public Collection<Point> intersect(Line line, boolean closedDraw) {
        ArrayList<Point> intersectionPoints = new ArrayList<Point>();
        List<Line> localLines = this.calculateLines(closedDraw);
        for (Line actualLine : localLines) {
            Point intersectionPoint = actualLine.intersectWithoutTangents(line);
            if (intersectionPoint == null) continue;
            intersectionPoints.add(intersectionPoint);
        }
        return intersectionPoints;
    }

    @Deprecated
    public void intersectionForInsidePolygonTest() {
    }

    private List<Line> calculateLines(boolean closedDraw) {
        assert (this.points.size() >= 2);
        int endIndex = closedDraw ? this.points.size() - 1 : this.points.size() - 2;
        ArrayList<Line> newLines = new ArrayList<Line>(endIndex + 1);
        int i = 0;
        while (i <= endIndex) {
            Point point2nd;
            Point point1st;
            if (i == endIndex && closedDraw) {
                point1st = this.get(i);
                point2nd = this.get(0);
                newLines.add(new Line(point1st, point2nd));
            } else {
                point1st = this.get(i);
                point2nd = this.get(i + 1);
                newLines.add(new Line(point1st, point2nd));
            }
            ++i;
        }
        return newLines;
    }
}

