/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Point {
    private static final ILogger logger = Logger.getLogger(Point.class);
    public static final Point ORIGIN = new Point(0.0, 0.0);
    public static final Point Point_0_minus1 = new Point(0.0, -1.0);
    public static final Point Point_1_1 = new Point(1.0, 1.0);
    public final double x;
    public final double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point point) {
        assert (point != null);
        this.x = point.x;
        this.y = point.y;
    }

    public static Point getAsPoint(Point point) {
        if (point.getClass() != Point.class) {
            return new Point(point);
        }
        return point;
    }

    public Point(GeoVector v) {
        assert (v != null);
        this.x = v.x;
        this.y = v.y;
    }

    public Point movePoint(GeoVector v) {
        assert (v != null);
        return new Point(this.x + v.x, this.y + v.y);
    }

    public Point turnPoint(Point center, double angle) {
        assert (center != null);
        GeoVector d = new GeoVector(center, this);
        d = d.turn(angle);
        return center.movePoint(d);
    }

    public Point transform(Transformation transformation) {
        assert (transformation != null);
        return transformation.transform(this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this, this);
    }

    public boolean equalsPoint(Point a) {
        return Geo.equals(a.x, this.x) && Geo.equals(a.y, this.y);
    }

    public String toString() {
        return "Point(" + this.x + ", " + this.y + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Point) {
            Point a = (Point)obj;
            return this.equalsPoint(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.x + this.y).hashCode();
    }
}

