/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Insets {
    private static final ILogger logger = Logger.getLogger(Insets.class);
    public double upperInset;
    public double lowerInset;
    public double leftInset;
    public double rightInset;

    public Insets(Insets i) {
        assert (i != null);
        this.upperInset = i.upperInset;
        this.lowerInset = i.lowerInset;
        this.leftInset = i.leftInset;
        this.rightInset = i.rightInset;
    }

    public Insets(double inset) {
        this(inset, inset, inset, inset);
    }

    public Insets(Rectangle innerRectangle, Rectangle outerRectangle) {
        this.upperInset = innerRectangle.upperLeft.y - outerRectangle.upperLeft.y;
        this.lowerInset = outerRectangle.lowerRight.y - innerRectangle.lowerRight.y;
        this.leftInset = innerRectangle.upperLeft.x - outerRectangle.upperLeft.x;
        this.rightInset = outerRectangle.lowerRight.x - innerRectangle.lowerRight.x;
    }

    public Insets(double upperInset, double lowerInset, double leftInset, double rightInset) {
        this.upperInset = upperInset;
        this.lowerInset = lowerInset;
        this.leftInset = leftInset;
        this.rightInset = rightInset;
    }

    public boolean isZero() {
        return Geo.isZero(this.upperInset) && Geo.isZero(this.leftInset) && Geo.isZero(this.rightInset) && Geo.isZero(this.lowerInset);
    }

    public String toString() {
        return "Inset(upperInset=" + this.upperInset + ", lowerInset=" + this.lowerInset + ", leftInset=" + this.leftInset + ", rightInset=" + this.rightInset + ")";
    }

    public boolean equalsInsets(Insets a) {
        return Geo.equals(this.upperInset, a.upperInset) && Geo.equals(this.lowerInset, a.lowerInset) && Geo.equals(this.leftInset, a.leftInset) && Geo.equals(this.rightInset, a.rightInset);
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Insets) {
            Insets a = (Insets)obj;
            return this.equalsInsets(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.upperInset).hashCode() ^ new Double(this.lowerInset).hashCode() ^ new Double(this.leftInset).hashCode() ^ new Double(this.rightInset).hashCode();
    }
}

