/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Ellipse {
    private static final ILogger logger = Logger.getLogger(Ellipse.class);
    public Point center;
    public double rx;
    public double ry;

    public Ellipse() {
        this.center = Point.ORIGIN;
        this.rx = 0.0;
        this.ry = 0.0;
    }

    public Ellipse(Ellipse ellipse) {
        assert (ellipse != null);
        this.center = Point.getAsPoint(ellipse.center);
        this.rx = ellipse.rx;
        this.ry = ellipse.ry;
    }

    public Ellipse(Point center, double rx, double ry) {
        assert (center != null);
        assert (Geo.isZeroOrGreaterThanZero(rx));
        assert (Geo.isZeroOrGreaterThanZero(ry));
        this.center = Point.getAsPoint(center);
        this.rx = rx;
        this.ry = ry;
    }

    public Ellipse(double x, double y, double rx, double ry) {
        this.center = new Point(x, y);
        this.rx = rx;
        this.ry = ry;
    }

    public Point getPointByAngle(double angle) {
        return new Point(this.center.x + this.rx * Math.cos(Math.toRadians(angle)), this.center.y - this.ry * Math.sin(Math.toRadians(angle)));
    }

    public double getArcLengthArc(double angleStart, double angleEnd) {
        return Geo.arcLengthArc(this.rx, this.ry, angleStart, angleEnd);
    }

    public boolean equalsEllipse(Ellipse a) {
        return Math.abs(a.rx - this.rx) < 1.0E-10 && Math.abs(a.ry - this.ry) < 1.0E-10 && a.center.equalsPoint(this.center);
    }

    public String toString() {
        return "Ellipse(center=" + this.center + ", rx=" + this.rx + ", ry=" + this.ry + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ellipse) {
            Ellipse a = (Ellipse)obj;
            return this.equalsEllipse(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.rx + this.ry).hashCode() ^ this.center.hashCode();
    }
}

