/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types.pointer;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.pointer.AbstractPointer;
import au.com.swz.swttocom.swt.types.pointer.IPointer;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.win32.OS;

public class IDispatchPointer
extends AbstractPointer
implements IPointer {
    private IDispatch dispatchData;

    public IDispatchPointer(ResourceManager resourceManager) {
        this(0, resourceManager);
    }

    public IDispatchPointer(int address, ResourceManager resourceManager) {
        super(resourceManager);
        this.resourcePackage.setPointerAddress(address);
    }

    public IDispatch getValue() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            int[] hMem = new int[1];
            OS.MoveMemory((int[])hMem, (int)this.resourcePackage.getPointerAddress(), (int)4);
            if (hMem[0] != 0) {
                this.dispatchData = new IDispatch(hMem[0]);
            }
        }
        return this.dispatchData;
    }

    public void setValue(IDispatch dispatchData) {
        this.dispatchData = dispatchData;
        if (this.resourcePackage.getPointerAddress() > 0 && dispatchData != null) {
            COM.MoveMemory((int)this.resourcePackage.getPointerAddress(), (int[])new int[]{dispatchData.getAddress()}, (int)4);
        }
    }

    @Override
    public int getAddress() {
        if (this.resourcePackage.getPointerAddress() == 0) {
            int address = OS.GlobalAlloc((int)64, (int)4);
            if (this.dispatchData != null) {
                COM.MoveMemory((int)address, (int[])new int[]{this.dispatchData.getAddress()}, (int)4);
            }
        }
        return this.resourcePackage.getPointerAddress();
    }

    @Override
    public void setAddress(int address) {
        this.resourcePackage.setPointerAddress(address);
    }

    @Override
    public void dispose() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            this.resourcePackage.dispose();
        }
    }
}

