/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.excel.DocEvents;
import com.arcway.lib.eclipse.ole.excel._Worksheet;
import com.arcway.lib.eclipse.ole.excel.impl.DocEventsListener;
import com.arcway.lib.eclipse.ole.excel.impl._WorksheetImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Worksheet
extends _WorksheetImpl {
    private static final ILogger logger = Logger.getLogger(Worksheet.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{00020820-0000-0000-C000-000000000046}");
    private DocEventsListener docEvents;

    public Worksheet(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Worksheet(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _Worksheet create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _WorksheetImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _WorksheetImpl _WorksheetImpl2 = new _WorksheetImpl(appVariant, resourceManager);
            return _WorksheetImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addDocEventsListener(DocEvents listener) {
        if (this.docEvents == null) {
            this.docEvents = new DocEventsListener(this.getResourceManager());
            this.addEventListener(DocEvents.IID, 1543, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 1537, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 1534, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 304, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 1530, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 279, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 1545, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 1470, (OleListener)this.docEvents);
            this.addEventListener(DocEvents.IID, 2156, (OleListener)this.docEvents);
        }
        return this.docEvents.addListener(listener);
    }

    public boolean removeDocEventsListener(DocEvents listener) {
        boolean bRtn = this.docEvents.removeListener(listener);
        if (this.docEvents.isEmpty()) {
            this.removeEventListener(DocEvents.IID, 1543, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 1537, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 1534, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 304, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 1530, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 279, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 1545, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 1470, (OleListener)this.docEvents);
            this.removeEventListener(DocEvents.IID, 2156, (OleListener)this.docEvents);
            this.docEvents = null;
        }
        return bRtn;
    }
}

