/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.excel;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.excel.ChartEvents;
import com.arcway.lib.eclipse.ole.excel._Chart;
import com.arcway.lib.eclipse.ole.excel.impl.ChartEventsListener;
import com.arcway.lib.eclipse.ole.excel.impl._ChartImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Chart
extends _ChartImpl {
    private static final ILogger logger = Logger.getLogger(Chart.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{00020821-0000-0000-C000-000000000046}");
    private ChartEventsListener chartEvents;

    public Chart(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Chart(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _Chart create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _ChartImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _ChartImpl _ChartImpl2 = new _ChartImpl(appVariant, resourceManager);
            return _ChartImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addChartEventsListener(ChartEvents listener) {
        if (this.chartEvents == null) {
            this.chartEvents = new ChartEventsListener(this.getResourceManager());
            this.addEventListener(ChartEvents.IID, 304, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1530, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 256, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1531, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1532, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1533, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1534, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1535, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1536, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1537, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 235, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 1538, (OleListener)this.chartEvents);
            this.addEventListener(ChartEvents.IID, 279, (OleListener)this.chartEvents);
        }
        return this.chartEvents.addListener(listener);
    }

    public boolean removeChartEventsListener(ChartEvents listener) {
        boolean bRtn = this.chartEvents.removeListener(listener);
        if (this.chartEvents.isEmpty()) {
            this.removeEventListener(ChartEvents.IID, 304, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1530, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 256, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1531, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1532, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1533, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1534, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1535, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1536, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1537, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 235, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 1538, (OleListener)this.chartEvents);
            this.removeEventListener(ChartEvents.IID, 279, (OleListener)this.chartEvents);
            this.chartEvents = null;
        }
        return bRtn;
    }
}

