/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.EmptyRepositoryNode;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectNode;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;

public class RepositoryObjectSampleNode
extends RepositoryDataItemNode {
    private final IRepositoryObjectSample repositoryObjectSample;

    public RepositoryObjectSampleNode(IRepositoryObjectSample repositoryObjectSample, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryObjectSample = repositoryObjectSample;
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        IRepositoryTypeManagerRO repositoryTypeManager = repositorySnapshot.getTypeManager();
        IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(this.repositoryObjectSample.getObjectTypeID());
        return repositoryObjectType.getAttributeSetTypes().iterator().hasNext();
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        IRepositorySnapshotRO currentSnapshot;
        IRepositoryObject rootObject;
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView != null && treeView.areEqualSnapshotIDs(this.snapshotID, treeView.getCurrentSnapshotID()) && (rootObject = (currentSnapshot = treeView.getCurrentSnapshot()).getRepositoryRootObject()) != null) {
            Object[] children = new RepositoryObjectNode[]{new RepositoryObjectNode(rootObject, treeView, this.snapshotID)};
            return children;
        }
        Object[] children = new EmptyRepositoryNode[]{new EmptyRepositoryNode(treeView, this.snapshotID)};
        return children;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return null;
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.repositoryObjectSample, treeView.getPresentationContext());
        return label.getText();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.repositoryObjectSample, treeView.getPresentationContext());
        return label.getIcon16x16();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryObjectSampleNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return false;
        }
        return treeView.areEqualSnapshotIDs(this.snapshotID, ((RepositoryObjectSampleNode)node).snapshotID);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        IRepositoryObjectTypeID repositoryObjectTypeID = this.repositoryObjectSample.getObjectTypeID();
        IRepositoryObjectType repositoryObjectType = this.getTreeViewModelAccessAgent().getRepositoryTypeManager().getObjectType(repositoryObjectTypeID);
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getIDAttributeSetType();
        IRepositoryPropertySetSample repositoryAttributeSetSample = RepositorySamples.getPropertySetSampleForAttributeSet((IRepositoryObjectSample)this.repositoryObjectSample, (IRepositoryAttributeSetType)repositoryAttributeSetType);
        ICollection_ repositoryPropertyTypes = repositoryAttributeSetType.getPropertyTypes();
        for (IRepositoryPropertyType repositoryPropertyType : repositoryPropertyTypes) {
            IRepositoryPropertyTypeID repositoryPropertyTypeID = repositoryPropertyType.getRepositoryPropertyTypeID();
            IRepositoryData repositoryData = repositoryAttributeSetSample.getPropertySample(repositoryPropertyTypeID).getValue();
            IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
            IRepositoryDataHasher hasher = repositoryDataType.getHasher();
            if (hasher != null) {
                hash ^= hasher.getHashCode(repositoryData);
                continue;
            }
            throw new IllegalArgumentException("Data type " + repositoryDataType + " in ID attribute set is not hashable.");
        }
        return hash;
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return repositorySnapshot;
    }
}

