/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTUserReference;
import com.arcway.repository.lib.high.registration.data.lib.UserReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class FDTUserReference
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTUserReference.class, "userreference.gif");
    private final RDTUserReference repositoryDataType = RDTUserReference.getInstance();
    private final IFrontendLabel frontendLabelDirectoryType = Messages.createFrontendLabel("FDTUser.DirectoryType", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelNameOrURL = Messages.createFrontendLabel("FDTUser.NameOrURL", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelDistinguishedName = Messages.createFrontendLabel("FDTUser.DistinguishedName", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelLoginID = Messages.createFrontendLabel("FDTUser.LoginID", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelRealName = Messages.createFrontendLabel("FDTUser.RealName", this.getRepositoryLocale(), null);

    public static FDTUserReference getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTUserReference frontendDataType = (FDTUserReference)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTUserReference.getInstance());
        return frontendDataType;
    }

    public FDTUserReference(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTUser", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel frontendLabel;
        UserReference userReference = this.repositoryDataType.dataToValue(value);
        if (userReference != null) {
            String directoryType = userReference.getDirectoryType();
            String directoryNameOrURL = userReference.getDirectoryNameOrURL();
            String distinguishedName = userReference.getDistinguishedName();
            String loginID = userReference.getLoginID();
            String realName = userReference.getRealName();
            String pseudoURL = String.valueOf(directoryType) + ": ";
            if (directoryNameOrURL != null) {
                try {
                    URL directoryURL = new URL(directoryNameOrURL);
                    if (directoryURL.getProtocol() != null) {
                        pseudoURL = String.valueOf(pseudoURL) + directoryURL.getProtocol() + "://";
                    }
                    if (loginID != null) {
                        pseudoURL = String.valueOf(pseudoURL) + loginID + "@";
                    }
                    if (directoryURL.getHost() != null) {
                        pseudoURL = String.valueOf(pseudoURL) + directoryURL.getHost();
                    }
                    if (directoryURL.getPort() != -1) {
                        pseudoURL = String.valueOf(pseudoURL) + ":" + directoryURL.getPort();
                    }
                    if (directoryURL.getPath() != null) {
                        pseudoURL = String.valueOf(pseudoURL) + directoryURL.getPath();
                    }
                }
                catch (MalformedURLException e) {
                    if (loginID != null) {
                        pseudoURL = String.valueOf(pseudoURL) + loginID + "@";
                    }
                    pseudoURL = String.valueOf(pseudoURL) + directoryNameOrURL;
                }
            }
            pseudoURL = String.valueOf(pseudoURL) + distinguishedName;
            String valueAsString = realName != null ? String.valueOf(realName) + " (" + pseudoURL + ")" : pseudoURL;
            valueAsString = realName != null ? realName : distinguishedName;
            frontendLabel = new FrontendLabel(valueAsString, null);
        } else {
            frontendLabel = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return frontendLabel;
    }

    public IFrontendLabel getFrontendLabelDirectoryType() {
        return this.frontendLabelDirectoryType;
    }

    public IFrontendLabel getFrontendLabelNameOrURL() {
        return this.frontendLabelNameOrURL;
    }

    public IFrontendLabel getFrontendLabelDistinguishedName() {
        return this.frontendLabelDistinguishedName;
    }

    public IFrontendLabel getFrontendLabelLoginID() {
        return this.frontendLabelLoginID;
    }

    public IFrontendLabel getFrontendLabelRealName() {
        return this.frontendLabelRealName;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.repositoryDataType.dataToValue(value);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        IRepositoryData data = this.repositoryDataType.createData((UserReference)editorValue);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTUserReference(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final Parameters DEFAULTS = new Parameters();
    }
}

