/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.richclientapplication.fixp2data;

import com.arcway.cockpit.richclientapplication.WebStartDetector;
import com.arcway.cockpit.richclientapplication.fixp2data.LinkAction;
import com.arcway.lib.io.TextFileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.URIUtil;

public class FixEclipseP2DataArea {
    private static final ILogger LOGGER = Logger.getLogger(FixEclipseP2DataArea.class);
    private static final boolean WINDOWS = File.separatorChar == '\\';
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static final String FILE_PROTOCOL = "file";
    private static final String P2 = "p2";

    public static void doFixEclipseP2DataArea() throws Exception {
        String eclipse_p2_data_area = System.getProperty("eclipse.p2.data.area");
        File osgi_install_area_dir = null;
        URL osgi_install_area = new URL(System.getProperty("osgi.install.area"));
        if (FILE_PROTOCOL.equals(osgi_install_area.getProtocol())) {
            osgi_install_area_dir = URIUtil.toFile((URI)URIUtil.toURI((URL)osgi_install_area));
        }
        File osgi_configuration_area_dir = null;
        URL osgi_configuration_area = new URL(System.getProperty("osgi.configuration.area"));
        if (FILE_PROTOCOL.equals(osgi_configuration_area.getProtocol())) {
            osgi_configuration_area_dir = URIUtil.toFile((URI)URIUtil.toURI((URL)osgi_configuration_area));
        }
        File p2_home_dir = null;
        if (osgi_install_area_dir != null) {
            p2_home_dir = new File(osgi_install_area_dir, P2);
        }
        File p2_conf_rel_dir = null;
        if (osgi_configuration_area_dir != null && osgi_configuration_area_dir.getParentFile() != null) {
            p2_conf_rel_dir = new File(osgi_configuration_area_dir.getParentFile(), P2);
        }
        if (!WebStartDetector.isWebStartApplication() && !WINDOWS && osgi_configuration_area_dir != null && p2_conf_rel_dir != null && p2_home_dir != null && "@config.dir/../p2".equals(eclipse_p2_data_area) && p2_home_dir.exists() && !p2_home_dir.getCanonicalPath().equals(p2_conf_rel_dir.getCanonicalPath())) {
            File p2linktarget = new File(p2_conf_rel_dir.getParentFile(), "p2linktarget.txt");
            String currentLinkTarget = null;
            if (p2linktarget.isFile()) {
                currentLinkTarget = TextFileHelper.getFileContentAsString((File)p2linktarget, (String)ENCODING_UTF_8);
            }
            String p2_home_dir_AbsolutePath = p2_home_dir.getAbsolutePath();
            if (currentLinkTarget == null || !currentLinkTarget.equals(p2_home_dir_AbsolutePath)) {
                File p2_afterRename_File = new File(p2_conf_rel_dir.getParentFile(), "p2_bak_" + Long.toHexString(System.currentTimeMillis()));
                if (!p2_conf_rel_dir.exists() || p2_conf_rel_dir.renameTo(p2_afterRename_File)) {
                    LinkAction.ln(p2_conf_rel_dir.getParent(), p2_home_dir.getAbsolutePath(), P2, false);
                    TextFileHelper.saveStringAsFile((String)p2_home_dir_AbsolutePath, (File)p2linktarget, (String)ENCODING_UTF_8);
                    System.setProperty("com.arcway.eclipse.p2.data.area.fixed.during.startup", "true");
                } else {
                    LOGGER.error("Failed to rename " + p2_conf_rel_dir + " into " + p2_afterRename_File);
                }
            }
        }
    }
}

