/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.richclientapplication;

import com.arcway.cockpit.richclientapplication.ApplicationWorkbenchAdvisor;
import com.arcway.cockpit.richclientapplication.Messages;
import com.arcway.cockpit.richclientapplication.ScriptInterpreterLauncher;
import com.arcway.cockpit.richclientapplication.WebStartDetector;
import com.arcway.cockpit.richclientapplication.fixp2data.FixEclipseP2DataArea;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    private static String brandingname = "Application not yet started";
    private static final ILogger logger = Logger.getLogger(Application.class);
    private static final String SYSPROP_WEBSTART = "com.arcway.cockpit.richclientapplication.webstart";
    private static final String COMMAND_LINE_OPTION_RUNSCRIPT = "-cockpitscriptfile";
    private static final String SYSPROP_SCRIPTSTART = "com.arcway.cockpit.richclientapplication.scriptstart";

    private Object std_run() {
        Display display = PlatformUI.createDisplay();
        Shell shell = new Shell(display, 16384);
        try {
            if (!this.checkInstanceLocation(shell)) {
                if (System.getProperty(SYSPROP_SCRIPTSTART, Boolean.FALSE.toString()).equals(Boolean.FALSE.toString())) {
                    Integer n = EXIT_OK;
                    return n;
                }
                Integer n = -1;
                return n;
            }
        }
        finally {
            shell.dispose();
        }
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            Application.openError(shell, Messages.getString("COCKPIT_RCPApplication_workspaceMandatoryTitle"), Messages.getString("COCKPIT_RCPApplication_workspaceMandatoryMessage"));
            return false;
        }
        if (instanceLoc.isSet()) {
            block5: {
                if (!instanceLoc.lock()) break block5;
                return true;
            }
            try {
                Application.openError(shell, Messages.getString("COCKPIT_RCPApplication_workspaceCannotLockTitle"), Messages.getString("COCKPIT_RCPApplication_workspaceCannotLockMessage"));
            }
            catch (IOException e) {
                logger.fatal("Could not obtain lock for workspace location", (Throwable)e);
                Application.openError(shell, Messages.getString("InternalError"), e.getMessage());
            }
            return false;
        }
        Application.openError(shell, Messages.getString("COCKPIT_RCPApplication_workspaceNoLocationDefinedTitle"), Messages.getString("COCKPIT_RCPApplication_workspaceNoLocationDefinedMessage"));
        return false;
    }

    public Object start(IApplicationContext context) throws Exception {
        brandingname = context.getBrandingName();
        try {
            System.setProperty(SYSPROP_WEBSTART, Boolean.toString(WebStartDetector.isWebStartApplication()));
        }
        catch (Exception e1) {
            logger.debug("Unable to access system property com.arcway.cockpit.richclientapplication.webstart", (Throwable)e1);
        }
        try {
            FixEclipseP2DataArea.doFixEclipseP2DataArea();
        }
        catch (Exception e) {
            logger.error("Unable to FixEclipseP2DataArea.doFixEclipseP2DataArea()", (Throwable)e);
        }
        boolean runScript = false;
        File scriptfile = null;
        Object returnValue = null;
        String[] cArgs = Platform.getCommandLineArgs();
        if (cArgs != null) {
            int i = 0;
            while (!runScript && i < cArgs.length) {
                if (COMMAND_LINE_OPTION_RUNSCRIPT.equalsIgnoreCase(cArgs[i])) {
                    runScript = true;
                    System.setProperty(SYSPROP_SCRIPTSTART, Boolean.TRUE.toString());
                    if (i + 1 < cArgs.length && !cArgs[i + 1].trim().startsWith("-")) {
                        String scriptfilename = cArgs[i + 1];
                        scriptfile = new File(scriptfilename);
                        if (scriptfile.exists() && scriptfile.canRead()) {
                            System.out.println("Using scriptfile: \"" + scriptfile + "\".");
                        } else if (scriptfile.exists()) {
                            scriptfile = null;
                            System.out.println("The scriptfile: \"" + scriptfile + "\" can not be read.");
                        } else {
                            scriptfile = null;
                            System.out.println("The scriptfile: \"" + scriptfilename + "\" does not exist.");
                        }
                    } else {
                        System.out.println("When using the option -cockpitscriptfile a scriptfile needs to be specified.");
                    }
                }
                ++i;
            }
        }
        if (runScript && scriptfile == null) {
            returnValue = EXIT_OK;
        } else {
            EclipsePlugin.getDefault().startupPSC();
            if (runScript && scriptfile != null) {
                System.out.println("Starting script interpreter thread using scriptfile \"" + scriptfile + "\".");
                ScriptInterpreterLauncher scriptInterpreterLauncher = new ScriptInterpreterLauncher(scriptfile, null);
                scriptInterpreterLauncher.start();
                returnValue = this.std_run();
            } else {
                returnValue = this.std_run();
            }
        }
        System.out.flush();
        System.err.flush();
        return returnValue;
    }

    public void stop() {
    }

    public static String getBasicWindowTitle() {
        return brandingname;
    }

    private static void openError(Shell parent, String messageTitle, String messageText) {
        if (System.getProperty(SYSPROP_SCRIPTSTART, Boolean.FALSE.toString()).equals(Boolean.FALSE.toString())) {
            MessageDialog.openError((Shell)parent, (String)messageTitle, (String)messageText);
        }
    }
}

