/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.IModifiedDataItem_V0;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.TimestampUtil;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;

public class EOWorkItem
extends EOEncodableObject
implements IModifiedDataItem_V0,
ICockpitProjectData {
    public static String XML_NAME = "pmm.workitem";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_PERCENT_WORK_COMPLETE = "percentworkcomplete";
    private static final String ATTR_TAG_WORK_ESTIMATED = "work";
    private static final String ATTR_TAG_WORK_DONE = "workdone";
    private static final String ATTR_TAG_WORK_REMAINING = "workremaining";
    private static final String ATTR_TAG_RESOURCE_NAMES = "resourcenames";
    private static final String ATTR_TAG_DATE_CREATION = "creationdate";
    private static final String ATTR_TAG_DATE_MODIFICATION = "lastmodificationdate";
    private static final String ATTR_TAG_UNITS = "units";
    private static final String ATTR_TAG_UNITS_COMPLETE = "unitscomplete";
    private static final String ATTR_TAG_CATEGORY = "category";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private static final String ATTR_TAG_UID = "uid";
    private static final String ATTR_TAG_PROJECT_UID = "projectuid";
    private static final String ATTR_TAG_TASK_UID = "taskUID";
    private static final String ATTR_TAG_UNIQUE_ELEMENT_UID = "uniquelementuid";
    private String name = "";
    private String category = "";
    private String description = "";
    private int workEstimated = 0;
    private int workDone = 0;
    private int workRemaining = 0;
    private float units = 1.0f;
    private float unitsComplete = 0.0f;
    private String resourceNames = "";
    private Timestamp dateCreation;
    private Timestamp dateModification;
    private String UID;
    private String projectUID;
    private String taskUID;
    private String uniqueElementUID;

    public EOWorkItem(String projectUID, String UID) {
        super(XML_NAME);
        assert (projectUID != null) : "projectUID of work item cannot be NULL!";
        assert (projectUID != null) : "UID of work item cannot be NULL!";
        this.projectUID = projectUID;
        this.UID = UID;
        this.dateCreation = new Timestamp(System.currentTimeMillis());
        this.dateModification = new Timestamp(this.dateCreation.getTime());
    }

    public EOWorkItem(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_NAME, this.name);
        this.appendAttrToXML(writeContext, ATTR_TAG_WORK_ESTIMATED, this.workEstimated);
        this.appendAttrToXML(writeContext, ATTR_TAG_WORK_DONE, this.workDone);
        this.appendAttrToXML(writeContext, ATTR_TAG_WORK_REMAINING, this.workRemaining);
        this.appendAttrToXML(writeContext, ATTR_TAG_UNITS, this.units);
        this.appendAttrToXML(writeContext, ATTR_TAG_UNITS_COMPLETE, this.unitsComplete);
        this.appendAttrToXML(writeContext, ATTR_TAG_CATEGORY, this.category);
        this.appendAttrToXML(writeContext, ATTR_TAG_DESCRIPTION, this.description);
        this.appendAttrToXML(writeContext, ATTR_TAG_RESOURCE_NAMES, this.resourceNames);
        this.appendAttrToXML(writeContext, ATTR_TAG_DATE_CREATION, this.dateCreation);
        this.appendAttrToXML(writeContext, ATTR_TAG_DATE_MODIFICATION, this.dateModification);
        this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.UID);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_TASK_UID, this.taskUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_UNIQUE_ELEMENT_UID, this.uniqueElementUID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_NAME)) {
            this.name = value;
        } else if (name.equals(ATTR_TAG_PERCENT_WORK_COMPLETE)) {
            float percentWorkComplete = Integer.parseInt(value);
            this.setUnitsComplete(percentWorkComplete / 100.0f);
        } else if (name.equals(ATTR_TAG_WORK_ESTIMATED)) {
            this.workEstimated = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_WORK_DONE)) {
            this.workDone = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_WORK_REMAINING)) {
            this.workRemaining = Integer.parseInt(value);
        } else if (name.equals(ATTR_TAG_UNITS)) {
            this.units = Float.parseFloat(value);
        } else if (name.equals(ATTR_TAG_UNITS_COMPLETE)) {
            this.unitsComplete = Float.parseFloat(value);
        } else if (name.equals(ATTR_TAG_CATEGORY)) {
            this.category = value;
        } else if (name.equals(ATTR_TAG_DESCRIPTION)) {
            this.description = value;
        } else if (name.equals(ATTR_TAG_RESOURCE_NAMES)) {
            this.resourceNames = value;
        } else if (name.equals(ATTR_TAG_DATE_CREATION)) {
            this.dateCreation = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_DATE_MODIFICATION)) {
            this.dateModification = this.toTimestamp(value);
        } else if (name.equals(ATTR_TAG_UID)) {
            this.UID = value;
        } else if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(ATTR_TAG_TASK_UID)) {
            this.taskUID = value;
        } else if (name.equals(ATTR_TAG_UNIQUE_ELEMENT_UID)) {
            this.uniqueElementUID = value;
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EOWorkItem workItem = (EOWorkItem)((Object)obj);
        return this.getProjectUID().equals(workItem.getProjectUID()) && this.getUID().equals(workItem.getUID());
    }

    public int hashCode() {
        return (String.valueOf(this.getProjectUID()) + this.getUID()).hashCode();
    }

    public EOWorkItem copy() {
        EOWorkItem workItem = new EOWorkItem(this.getProjectUID(), this.getUID());
        workItem.setName(this.getName());
        workItem.setWorkEstimated(this.getWorkEstimated());
        workItem.setWorkDone(this.getWorkDone());
        workItem.setWorkRemaining(this.getWorkRemaining());
        workItem.setUnits(this.getUnits());
        workItem.setUnitsComplete(this.getUnitsCompleted());
        workItem.setCategory(this.getCategory());
        workItem.setDescription(this.getDescription());
        workItem.setResourceNames(this.getResourceNames());
        workItem.setTaskUID(this.getTaskUID());
        workItem.setUniqueElementUID(this.getUniqueElementUID());
        workItem.setDateCreation(new Timestamp(this.getDateCreation().getTime()));
        workItem.setDateModification(new Timestamp(this.getDateModification().getTime()));
        return workItem;
    }

    public String getName() {
        assert (this.name != null) : "name is null";
        return this.name;
    }

    public String getProjectUID() {
        assert (this.projectUID != null) : "projectUID is NULL";
        return this.projectUID;
    }

    public String getResourceNames() {
        assert (this.resourceNames != null) : "resourceNames is NULL";
        return this.resourceNames;
    }

    public String getTaskUID() {
        return this.taskUID;
    }

    public String getUID() {
        assert (this.UID != null) : "uid of work item is NULL";
        return this.UID;
    }

    public Object getKey() {
        assert (this.UID != null) : "unique key is null";
        return this.UID;
    }

    public String getUniqueElementUID() {
        return this.uniqueElementUID;
    }

    public int getWorkDone() {
        assert (this.workDone >= 0) : "work out of range";
        return this.workDone;
    }

    public Timestamp getDateCreation() {
        assert (this.dateCreation != null) : "creation date is null";
        return this.dateCreation;
    }

    public Timestamp getDateModification() {
        assert (this.dateModification != null) : "modification date is null";
        return this.dateModification;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public float getUnits() {
        return this.units;
    }

    public float getUnitsCompleted() {
        return this.unitsComplete;
    }

    public int getWorkEstimated() {
        return this.workEstimated;
    }

    public int getPercentWorkComplete() {
        if (this.getWork() == 0) {
            return 0;
        }
        return this.getWorkDone() * 100 / this.getWork();
    }

    public int getWorkRemaining() {
        if (this.workRemaining == 0) {
            int percentUnitsCompleted = (int)(100.0f * (this.unitsComplete / this.units));
            if (percentUnitsCompleted == 100) {
                this.workRemaining = 0;
            } else if (this.workDone == 0 && percentUnitsCompleted > 0) {
                this.workRemaining = (int)Math.ceil((double)this.workEstimated / 100.0 * (double)(100 - percentUnitsCompleted));
            } else if (this.workDone > 0 && percentUnitsCompleted > 0) {
                this.workRemaining = (int)Math.ceil((float)(this.workDone * 100) / (float)percentUnitsCompleted);
                this.workRemaining -= this.workDone;
            } else {
                this.workRemaining = this.workEstimated + this.workDone;
            }
            assert (this.workRemaining >= 0) : "invalid remaining work value";
        }
        return this.workRemaining;
    }

    public int getWork() {
        return this.getWorkDone() + this.getWorkRemaining();
    }

    public void setName(String name) {
        assert (name != null) : "name of work item is NULL";
        this.name = name;
    }

    public void setProjectUID(String projectUID) {
        assert (projectUID != null) : "projectUID of work item is NULL";
        this.projectUID = projectUID;
    }

    public void setResourceNames(String resourceNames) {
        assert (resourceNames != null) : "resourceNames field of work item is NULL";
        this.resourceNames = resourceNames;
    }

    public void setTaskUID(String taskUID) {
        this.taskUID = taskUID;
    }

    public void setUID(String UID) {
        assert (UID != null) : "UID of work item is NULL";
        this.UID = UID;
    }

    public void setUniqueElementUID(String uniqueElementUID) {
        this.uniqueElementUID = uniqueElementUID;
    }

    public void setWorkDone(int workDone) {
        assert (workDone >= 0) : "workDone out of range";
        this.workDone = workDone;
    }

    public void setWorkRemaining(int workRemaining) {
        assert (workRemaining >= 0) : "workRemaining out of range";
        this.workRemaining = workRemaining;
        this.unitsComplete = this.workDone + this.workRemaining != 0 ? this.units * (float)this.workDone / (float)(this.workDone + this.workRemaining) : 0.0f;
    }

    public void setDateCreation(Timestamp timestamp) {
        assert (timestamp != null) : "creation date is null";
        this.dateCreation = timestamp;
    }

    public void setDateModification(Timestamp timestamp) {
        assert (timestamp != null) : "modification date is null";
        this.dateModification = timestamp;
    }

    public void setCategory(String category) {
        assert (category != null) : "category is null";
        this.category = category;
    }

    public void setDescription(String description) {
        assert (description != null) : "description is null";
        this.description = description;
    }

    private void setUnits(float units) {
        assert ((double)units >= 1.0) : "units out of range";
        this.units = units;
    }

    private void setUnitsComplete(float unitsComplete) {
        assert ((double)unitsComplete >= 0.0) : "unitsComplete out of range";
        this.unitsComplete = unitsComplete;
    }

    public void setWorkEstimated(int work) {
        assert ((double)work >= 0.0) : "estimated work out of range";
        this.workEstimated = work;
    }

    public String getTypeID() {
        return "com.arcway.msp.workitem";
    }

    public static final boolean haveEqualAttributes(EOWorkItem wi1, EOWorkItem wi2) {
        boolean equal = StringUtil.equals((String)wi1.getCategory(), (String)wi2.getCategory()) && TimestampUtil.equals((Timestamp)wi1.getDateCreation(), (Timestamp)wi2.getDateCreation()) && TimestampUtil.equals((Timestamp)wi1.getDateModification(), (Timestamp)wi2.getDateModification()) && StringUtil.equals((String)wi1.getDescription(), (String)wi2.getDescription()) && StringUtil.equals((String)wi1.getName(), (String)wi2.getName()) && StringUtil.equals((String)wi1.getResourceNames(), (String)wi2.getResourceNames()) && StringUtil.equals((String)wi1.getTaskUID(), (String)wi2.getTaskUID()) && StringUtil.equals((String)wi1.getUniqueElementUID(), (String)wi2.getUniqueElementUID()) && wi1.getWorkEstimated() == wi2.getWorkEstimated() && wi1.getWorkDone() == wi2.getWorkDone() && wi1.getWorkRemaining() == wi2.getWorkRemaining();
        return equal;
    }
}

