/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter.interFace;

import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AdapterForFrameLinkManager
implements ILinkManagerInterfaceForPlatformAdapter {
    private final LinkManager linkManager;
    private final ILockManager lockManager;

    public AdapterForFrameLinkManager(LinkManager linkManager, ILockManager lockManager) {
        this.linkManager = linkManager;
        this.lockManager = lockManager;
    }

    @Override
    public LockAccess acquireLocksForLinkData(String linkableObjectUID, String moduleDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        return new LockAccess(this.lockManager, this.linkManager.acquireLocksForLinkData(linkableObjectUID, moduleDataUID, linkType));
    }

    @Override
    public IStatus createLink(String linkableObjectUID, String moduleDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        Collection createdLinks = this.linkManager.createLinks(linkType, moduleDataUID, Collections.singletonList(linkableObjectUID));
        if (createdLinks.size() == 1) {
            return new Status(0, ModuleLib2Plugin.getDefault().getPluginID(), null);
        }
        return new Status(4, ModuleLib2Plugin.getDefault().getPluginID(), null);
    }

    @Override
    public IStatus deleteLink(String linkableObjectUID, String moduleDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        Collection deletedLinks = this.linkManager.deleteLinks(Collections.singletonList(linkableObjectUID), moduleDataUID, linkType);
        if (deletedLinks.size() == 1) {
            return new Status(0, ModuleLib2Plugin.getDefault().getPluginID(), null);
        }
        return new Status(4, ModuleLib2Plugin.getDefault().getPluginID(), null);
    }

    @Override
    public Collection<? extends ICockpitProjectData> getLinkableObjects(String cockpitDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        Set links = this.linkManager.getLinksOfLinkTypeForModuleDataItem(linkType, cockpitDataUID);
        ArrayList<ICockpitProjectData> linkableObjects = new ArrayList<ICockpitProjectData>(links.size());
        for (EOLink link : links) {
            linkableObjects.add(this.linkManager.getLinkableObject(link));
        }
        return linkableObjects;
    }

    @Override
    public Collection<? extends ICockpitProjectData> getModuleData(String cockpitDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        Set links = this.linkManager.getLinksOfLinkTypeForLinkableObject(linkType, cockpitDataUID);
        ArrayList<ICockpitProjectData> moduleDataItems = new ArrayList<ICockpitProjectData>(links.size());
        for (EOLink link : links) {
            moduleDataItems.add(this.linkManager.getModuleDataItem(link));
        }
        return moduleDataItems;
    }

    @Override
    public Set<EOLink> getLinksForLinkableObject(String cockpitDataUID, String cockpitLinkTypeID) {
        ILinkType linkType = this.linkManager.getLinkType(cockpitLinkTypeID);
        return this.linkManager.getLinksOfLinkTypeForLinkableObject(linkType, cockpitDataUID);
    }

    @Override
    public ISetMapWithFixReturnSetsRO<String, EOLink> getLinksForLinkType(String cockpitLinkTypeID) {
        return this.linkManager.getLinksMappedByLinkableObjectUID(cockpitLinkTypeID);
    }
}

