/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.resources;

import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ModuleIconResource
implements IIconResource {
    private static final ILogger logger = Logger.getLogger(ModuleIconResource.class);
    private final String fileName;
    private final AbstractModulePlugin plugin;
    private URL url;

    public ModuleIconResource(AbstractModulePlugin plugin, String name) {
        this.fileName = name;
        this.plugin = plugin;
        URL installURL = plugin.getBundle().getEntry("/");
        try {
            this.url = new URL(installURL, String.valueOf(plugin.getIconPath()) + this.fileName);
        }
        catch (MalformedURLException muE) {
            logger.warn("Icon not found. Name: " + this.fileName, (Throwable)muE);
            this.url = null;
        }
    }

    public String getName() {
        return this.fileName;
    }

    public InputStream getInputStream() {
        if (this.url != null) {
            try {
                return this.url.openStream();
            }
            catch (IOException ioE) {
                logger.warn("Icon not found. URL: " + this.url, (Throwable)ioE);
                return null;
            }
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.plugin.getImageDescriptor_(this.fileName);
    }

    public Image getImage() {
        return this.plugin.getImageDescriptorRegistry().get(this.getImageDescriptor());
    }
}

