/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoryIconProvider;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationNEW;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategoryID;
import com.arcway.cockpit.frame.shared.message.IncompatibleDataTypeException;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.viewers.ICachedItem;
import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.eclipse.resources.DecoratedImageCache;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.resources.ImageIconResource;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionFilter;

public abstract class AbstractModuleData
implements IModuleData,
IActionFilter,
ICategoryOwner,
ICachedItem {
    private static final ILogger logger = Logger.getLogger(AbstractModuleData.class);
    private boolean isHistoricItem = false;
    private int modificationCount = 0;
    private int commitCount = 0;
    private ObjectTypeCategoryID categoryID;
    public static final String ROLE_MODIFICATION_DATE = "abstractmoduledata_modificationDate";
    public static final String ROLE_CREATION_DATE = "abstractmoduledata_creationDate";
    public static final String ROLE_CREATOR = "abstractmoduledata_creator";
    public static final String ROLE_MODIFIER = "abstractmoduledata_modifier";
    public static final Collection<String> ADMINISTRATIVE_MODULE_DATA_ATTRIBUTES = Arrays.asList("abstractmoduledata_creationDate", "abstractmoduledata_creator", "abstractmoduledata_modificationDate", "abstractmoduledata_modifier");
    public static final String MDATE_NAME_KEY = "AbstractModuleData.MDATE_NAME";
    public static final String CDATE_NAME_KEY = "AbstractModuleData.CDATE_NAME";
    public static final String CREATOR_NAME_KEY = "AbstractModuleData.CREATOR_NAME";
    public static final String MODIFIER_NAME_KEY = "AbstractModuleData.MODIFIER_NAME";
    public static final String MODCOUNT_NAME_KEY = "AbstractModuleData.MODCOUNT_NAME";
    public static final String MDATE_NAME = Messages.getString("AbstractModuleData.MDATE_NAME");
    public static final String CDATE_NAME = Messages.getString("AbstractModuleData.CDATE_NAME");
    public static final String CREATOR_NAME = Messages.getString("AbstractModuleData.CREATOR_NAME");
    public static final String MODIFIER_NAME = Messages.getString("AbstractModuleData.MODIFIER_NAME");
    public static final String MODCOUNT_NAME = Messages.getString("AbstractModuleData.MODCOUNT_NAME");
    protected Map<String, IModuleDataAttribute> moduleAttributes = new HashMap<String, IModuleDataAttribute>();
    boolean customPropertiesFilled = true;
    private List<EOAttribute> tempCustomAttributes;
    private Map<IAttributeType, CustomModuleAttribute> customAttributes = new HashMap<IAttributeType, CustomModuleAttribute>();
    private String projectUID;
    private String uid;
    private int hashcode;
    private boolean hashcodeUsed = false;
    private IModuleDataTypeDescription typeDescription;
    public static final String ACTION_FILTER_ATTRIBUTE_HISTORY = "history";
    public static final String ACTION_FILTER_VALUE_SHOW = "show";

    public AbstractModuleData() {
        this.setModuleDataIdentityAttributes(null, UUIDGenerator.getUniqueID());
        this.moduleAttributes.put(ROLE_MODIFICATION_DATE, new ModuleDataAttributeTimestamp());
        this.moduleAttributes.put(ROLE_CREATION_DATE, new ModuleDataAttributeTimestamp());
        this.moduleAttributes.put(ROLE_MODIFIER, new ModuleDataAttributeUser());
        this.moduleAttributes.put(ROLE_CREATOR, new ModuleDataAttributeUser());
    }

    public AbstractModuleData(EOModuleData eo) {
        this();
        assert (eo != null);
        this.fillWithEncodableObject(eo);
    }

    private void setModuleDataIdentityAttributes(String newProjectUID, String newUID) {
        assert (newUID != null);
        assert (!this.hashcodeUsed || this.projectUID.equals(newProjectUID) && this.uid.equals(newUID));
        this.projectUID = newProjectUID;
        this.uid = newUID;
        this.hashcode = this.projectUID != null && this.uid != null ? this.uid.hashCode() + 31 * this.projectUID.hashCode() : 0;
    }

    public void fillWithEncodableObject(EOModuleData eo) {
        assert (eo != null);
        this.customPropertiesFilled = false;
        this.setModuleDataIdentityAttributes(eo.getProjectUID(), eo.getUID());
        Map newAttributes = eo.getAttributes();
        for (Map.Entry entry : newAttributes.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            IModuleDataAttribute attribute = this.moduleAttributes.get(key);
            if (attribute == null) continue;
            attribute.setValueViaUniqueStringRepresentation(value);
        }
        this.modificationCount = eo.getModCount();
        this.commitCount = eo.getCommitCount();
        this.isHistoricItem = eo.isHistoricItem();
        this.categoryID = ObjectTypeCategoryID.getObjectTypeCategoryID((EOObjectTypeCategoryID)eo.getCategoryID());
        String eoProjectUID = eo.getProjectUID();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(eoProjectUID);
        if (projectAgent == null || projectAgent.getModuleUserDefinedAttributeTypesManager() == null) {
            this.tempCustomAttributes = eo.getCustomAttributes() != null && !eo.getCustomAttributes().isEmpty() ? eo.getCustomAttributes() : Collections.emptyList();
            return;
        }
        IModuleUserDefinedAttributeTypesManager manager = projectAgent.getModuleUserDefinedAttributeTypesManager();
        EOList ca = eo.getCustomAttributes();
        this.fillCustomAttributes(manager, (List<EOAttribute>)ca);
    }

    private void fillCustomAttributes(IModuleUserDefinedAttributeTypesManager manager, List<EOAttribute> eoAttributes) {
        assert (manager != null) : "manager must not be null";
        assert (eoAttributes != null) : "ca must not be null";
        for (EOAttribute eoAttribute : eoAttributes) {
            EOAttributeTypeID eoAttributeTypeID = eoAttribute.getAttributeTypeUID();
            AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID((EOAttributeTypeID)eoAttributeTypeID);
            String humanReadableAttributeTypeID = eoAttributeTypeID.getHumanreadableID();
            Collection supportedAttributeTypes = manager.getAllUserDefinedAttributeTypes(this.getModuleDataTypeDescriptionForFrame().getCockpitDataTypeID());
            IAttributeType attributeType = null;
            for (IAttributeType supportedType : supportedAttributeTypes) {
                if (!supportedType.getAttributeTypeID().getUID().equals(attributeTypeID.getUID()) && !supportedType.getHumanReadableID().equals(humanReadableAttributeTypeID)) continue;
                attributeType = supportedType;
                break;
            }
            if (attributeType == null) continue;
            try {
                Object newAttributeValue;
                Object attributeValue = attributeType.getDataType().getEOAsValue(eoAttribute.getValueAsEO());
                if (attributeType.getDataType() instanceof IDataTypeWithFile && attributeValue instanceof FileID || attributeType.getDataType().supportsValue(attributeValue, attributeType.getValueRange())) {
                    this.customAttributes.put(attributeType, new CustomModuleAttribute(attributeType.getAttributeTypeID(), attributeValue));
                    continue;
                }
                if (!(attributeType.getDataType() instanceof DataTypeEnumerationNEW) || (newAttributeValue = ((DataTypeEnumerationNEW)attributeType.getDataType()).mapValue(attributeValue, attributeType.getValueRange())) == null) continue;
                this.customAttributes.put(attributeType, new CustomModuleAttribute(attributeType.getAttributeTypeID(), newAttributeValue));
            }
            catch (ExInvalidDataType exInvalidDataType) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.customPropertiesFilled = true;
    }

    @Override
    public IModuleData copy(boolean includeUid) {
        AbstractModuleData newObject = (AbstractModuleData)this.getTypeDescription().getNewInstance();
        newObject.setCategoryID(this.getCategoryID());
        newObject.setAttributes(this.getAttributes());
        newObject.setCustomAttributes(this.copyCustomAttributes());
        if (!this.customPropertiesFilled && this.tempCustomAttributes != null) {
            newObject.tempCustomAttributes = new ArrayList<EOAttribute>(this.tempCustomAttributes);
            newObject.customPropertiesFilled = false;
        }
        if (includeUid) {
            newObject.setUid(this.getUID());
        }
        newObject.setProjectUID(this.getProjectUID());
        newObject.setModificationCount(this.getModificationCount());
        newObject.setCommitCount(this.getCommitCount());
        return newObject;
    }

    @Override
    public IModuleData copy(String projectUID_) {
        AbstractModuleData newObject = (AbstractModuleData)this.getTypeDescription().getNewInstance();
        newObject.setProjectUID(projectUID_);
        newObject.setCategoryID(this.getCategoryID());
        newObject.setAttributes(this.getAttributes());
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID_);
        IModuleUserDefinedAttributeTypesManager manager = projectAgent.getModuleUserDefinedAttributeTypesManager();
        if (!this.customPropertiesFilled) {
            newObject.fillCustomAttributes(manager, this.tempCustomAttributes);
        } else {
            newObject.fillCustomAttributes(manager, this.createEncodableCustomAttributes());
        }
        return newObject;
    }

    @Override
    public void copyDataFrom(AbstractModuleData moduleData, boolean includeUid) throws IncompatibleDataTypeException {
        if (!moduleData.getTypeID().equals(this.getTypeID())) {
            throw new IncompatibleDataTypeException(moduleData.getTypeID(), this.getTypeID());
        }
        if (includeUid) {
            this.setModuleDataIdentityAttributes(moduleData.getProjectUID(), moduleData.getUID());
        }
        this.isHistoricItem = moduleData.isHistoricItem();
        this.modificationCount = moduleData.getModificationCount();
        this.commitCount = moduleData.getCommitCount();
        this.categoryID = moduleData.getCategoryID();
        this.moduleAttributes = new HashMap<String, IModuleDataAttribute>(moduleData.getAttributes());
        this.setCustomAttributes(moduleData.copyCustomAttributes());
    }

    public String getIconID() {
        String categoryIDAsString = this.categoryID == null ? null : this.categoryID.getUID();
        String statusID = this.getStatus();
        return categoryIDAsString == null ? statusID : (statusID == null ? categoryIDAsString : String.valueOf(categoryIDAsString) + '-' + statusID);
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null || !(toCompare instanceof AbstractModuleData)) {
            return false;
        }
        AbstractModuleData abstractModuleDataToCompare = (AbstractModuleData)toCompare;
        assert (this.uid != null);
        return this.hashcode == abstractModuleDataToCompare.hashcode && (this.projectUID == abstractModuleDataToCompare.projectUID || this.projectUID != null && this.projectUID.equals(abstractModuleDataToCompare.projectUID)) && this.uid.equals(abstractModuleDataToCompare.uid);
    }

    public int hashCode() {
        assert (this.projectUID != null);
        this.hashcodeUsed = true;
        return this.hashcode;
    }

    @Override
    public boolean mergingHasEffect(IModuleData moduleDataToMerge) {
        Timestamp lastModificationOtherOne;
        Timestamp lastModificationThis = this.getModificationTime().getValueAsTimeStamp();
        return !lastModificationThis.after(lastModificationOtherOne = moduleDataToMerge.getModificationTime().getValueAsTimeStamp());
    }

    @Override
    public IModuleData merge(IModuleData moduleDataToMerge) {
        Timestamp lastModificationOtherOne;
        Timestamp lastModificationThis = this.getModificationTime().getValueAsTimeStamp();
        IModuleData toReturn = lastModificationThis.after(lastModificationOtherOne = moduleDataToMerge.getModificationTime().getValueAsTimeStamp()) ? this.copy(true) : moduleDataToMerge.copy(true);
        return toReturn;
    }

    @Override
    public EOModuleData createEncodableObject() {
        EOModuleData eo = new EOModuleData();
        eo.setUID(this.getUID());
        eo.setTypeID(this.getTypeID());
        eo.setProjectUID(this.getProjectUID());
        eo.setModCount(this.getModificationCount());
        eo.setCommitCount(this.getCommitCount());
        eo.setCategoryID(this.getCategoryID() != null ? this.getCategoryID().createEncodableObject() : null);
        HashMap<String, String> stringConvertedModuleAttributes = new HashMap<String, String>();
        for (String key : this.moduleAttributes.keySet()) {
            IModuleDataAttribute value = this.moduleAttributes.get(key);
            String valueAsString = value.getUniqueStringRepresentation();
            if (valueAsString == null) continue;
            stringConvertedModuleAttributes.put(key, valueAsString);
        }
        eo.setAttributes(stringConvertedModuleAttributes);
        eo.setCustomAttributes(this.createEncodableCustomAttributes());
        return eo;
    }

    private List<EOAttribute> createEncodableCustomAttributes() {
        ArrayList<EOAttribute> convertedCustomAttributes = new ArrayList<EOAttribute>();
        for (Map.Entry<IAttributeType, CustomModuleAttribute> entry : this.customAttributes.entrySet()) {
            IAttributeType attributeType = entry.getKey();
            IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
            Object attributeValue = entry.getValue().getAttributeValue();
            try {
                IValueRange valueRange = attributeType.getValueRange();
                EOEncodableObject eoValue = attributeType.getDataType().getValueAsEO(attributeValue, valueRange);
                EOAttribute eoAttribute = new EOAttribute();
                EOAttributeTypeID eoAttributeTypeID = new EOAttributeTypeID(attributeTypeID.getUID(), attributeType.getHumanReadableID());
                eoAttribute.setAttributeTypeID(eoAttributeTypeID);
                eoAttribute.setValueAsEO(eoValue);
                convertedCustomAttributes.add(eoAttribute);
            }
            catch (ExInvalidDataType e) {
                logger.warn((Throwable)e);
            }
        }
        return convertedCustomAttributes;
    }

    @Override
    public boolean isIsomorphic(IModuleData item) {
        return false;
    }

    @Override
    public IModuleDataAttribute getAttribute(String role) {
        if (!this.getTypeDescription().isCalculatedAttribute(role)) {
            return this.moduleAttributes.get(role);
        }
        return this.getCalculatedAttribute(role);
    }

    protected IModuleDataAttribute getCalculatedAttribute(String role) {
        return null;
    }

    @Override
    public Map<String, IModuleDataAttribute> getAttributes() {
        HashMap<String, IModuleDataAttribute> attributeMap = new HashMap<String, IModuleDataAttribute>(this.moduleAttributes.size() * 2, 0.6f);
        for (Map.Entry<String, IModuleDataAttribute> entry : this.moduleAttributes.entrySet()) {
            attributeMap.put(entry.getKey(), entry.getValue().copy());
        }
        return attributeMap;
    }

    public void setAttributes(Map<String, IModuleDataAttribute> attributeMap) {
        assert (attributeMap != null);
        for (Map.Entry<String, IModuleDataAttribute> entry : attributeMap.entrySet()) {
            String key = entry.getKey();
            IModuleDataAttribute attribute = entry.getValue();
            if (!this.moduleAttributes.containsKey(key)) continue;
            this.moduleAttributes.put(key, attribute);
        }
    }

    public String[] getListOfUnequalAttributes(AbstractModuleData toCompare) {
        assert (toCompare != null);
        Map<String, IModuleDataAttribute> moduleAttributesToCompare = toCompare.getAttributes();
        Iterator<String> keyIterator = this.moduleAttributes.keySet().iterator();
        ArrayList<String> unequalAttributesList = new ArrayList<String>();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            if (this.moduleAttributes.get(key).equals(moduleAttributesToCompare.get(key))) continue;
            unequalAttributesList.add(key);
        }
        String[] result = new String[unequalAttributesList.size()];
        int c = 0;
        while (c < unequalAttributesList.size()) {
            result[c] = (String)unequalAttributesList.get(c);
            ++c;
        }
        return result;
    }

    @Override
    public ModuleDataAttributeTimestamp getCreationTime() {
        return (ModuleDataAttributeTimestamp)this.moduleAttributes.get(ROLE_CREATION_DATE);
    }

    @Override
    public ModuleDataAttributeTimestamp getModificationTime() {
        return (ModuleDataAttributeTimestamp)this.moduleAttributes.get(ROLE_MODIFICATION_DATE);
    }

    @Override
    public ModuleDataAttributeUser getCreator() {
        return (ModuleDataAttributeUser)this.moduleAttributes.get(ROLE_CREATOR);
    }

    @Override
    public ModuleDataAttributeUser getModifier() {
        return (ModuleDataAttributeUser)this.moduleAttributes.get(ROLE_MODIFIER);
    }

    public int getModificationCount() {
        return this.modificationCount;
    }

    @Override
    public void setModificationCount(int modificationCount) {
        this.modificationCount = modificationCount;
    }

    @Override
    public ObjectTypeCategoryID getCategoryID() {
        return this.categoryID;
    }

    @Override
    public void setCategoryID(ObjectTypeCategoryID categoryID) {
        this.categoryID = categoryID;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    @Override
    public void setCommitCount(int commitCount) {
        this.commitCount = commitCount;
    }

    @Override
    public String getProjectUID() {
        return this.projectUID;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public void setProjectUID(String newProjectUID) {
        this.setModuleDataIdentityAttributes(newProjectUID, this.uid);
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        if (!this.customPropertiesFilled && projectAgent != null && projectAgent.getModuleUserDefinedAttributeTypesManager() != null) {
            IModuleUserDefinedAttributeTypesManager manager = projectAgent.getModuleUserDefinedAttributeTypesManager();
            this.fillCustomAttributes(manager, this.tempCustomAttributes);
        }
    }

    @Override
    public void setUid(String newUID) {
        this.setModuleDataIdentityAttributes(this.projectUID, newUID);
    }

    @Override
    public boolean isHistoricItem() {
        return this.isHistoricItem;
    }

    public Collection<CustomModuleAttribute> getCustomAttributes() {
        return this.customAttributes.values();
    }

    private Map<IAttributeType, CustomModuleAttribute> copyCustomAttributes() {
        HashMap<IAttributeType, CustomModuleAttribute> newAttributes = new HashMap<IAttributeType, CustomModuleAttribute>(this.customAttributes.size() * 2, 0.6f);
        for (Map.Entry<IAttributeType, CustomModuleAttribute> entry : this.customAttributes.entrySet()) {
            Object newValue = entry.getKey().getDataType().getCopy(entry.getValue().getAttributeValue(), entry.getKey().getValueRange());
            newAttributes.put(entry.getKey(), new CustomModuleAttribute(entry.getKey().getAttributeTypeID(), newValue));
        }
        return newAttributes;
    }

    public void setCustomAttributes(Map<IAttributeType, CustomModuleAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @Override
    public IAttribute getCustomAttribute(IAttributeType attributeType) {
        return this.customAttributes.get(attributeType);
    }

    @Override
    public void setCustomAttribute(IAttributeType type, CustomModuleAttribute attribute) {
        this.customAttributes.put(type, attribute);
    }

    @Override
    public String getTypeID() {
        return this.getTypeDescription().getTypeID();
    }

    @Override
    public final IModuleDataTypeDescription getTypeDescription() {
        if (this.typeDescription == null) {
            this.typeDescription = this.getTypeDescription_internal();
        }
        return this.typeDescription;
    }

    protected abstract IModuleDataTypeDescription getTypeDescription_internal();

    @Override
    public ModuleDataTypeDescriptionForFrame getModuleDataTypeDescriptionForFrame() {
        return this.getTypeDescription().getModuleDataTypeDescriptionForFrame();
    }

    @Override
    public String getStatus() {
        return "MD_STATUS_DEFAULT";
    }

    @Override
    public IIconResource getStatusDependentIcon() {
        IIconResource statusSpecificIcon = this.getStatusDependentIconDecorator();
        if (statusSpecificIcon != null) {
            IIconResource statusDecoratedCategoryIconResource = ObjectTypeCategoryIconProvider.getDefault().getDecoratedObjectTypeCategoryIconResource(this.projectUID, this.categoryID, statusSpecificIcon);
            if (statusDecoratedCategoryIconResource != null) {
                return statusDecoratedCategoryIconResource;
            }
            return new ImageIconResource("Status Decorated Type Icon", DecoratedImageCache.getImage((Display)Display.getCurrent(), (DecoratedImage)new DecoratedImage(this.getTypeDescription().getTypeIcon().getImage(), statusSpecificIcon.getImage(), new Alignment(4, 32))));
        }
        IIconResource categoryIconResource = ObjectTypeCategoryIconProvider.getDefault().getObjectTypeCategoryIconResource(this.projectUID, this.categoryID);
        if (categoryIconResource != null) {
            return categoryIconResource;
        }
        return this.getTypeDescription().getTypeIcon();
    }

    protected IIconResource getStatusDependentIconDecorator() {
        return null;
    }

    @Override
    public IIconResource getAttributeIcon(String attributeID) {
        return null;
    }

    @Override
    public IModuleData getModuleData() {
        return this;
    }

    @Override
    public String getDisplayRepresentation(Locale locale) {
        return this.getDisplayRepresentation();
    }

    public boolean testAttribute(Object target, String name, String value) {
        assert (target instanceof IModuleData);
        IModuleData targetItem = (IModuleData)target;
        if (ACTION_FILTER_ATTRIBUTE_HISTORY.equals(name) && ACTION_FILTER_VALUE_SHOW.equals(value)) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(targetItem.getProjectUID());
            return projectAgent.getModuleServerProxy().supportsVersioning();
        }
        return false;
    }
}

