/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages;

import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityNN;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLinkedDataAccessFacade;
import com.arcway.cockpit.modulelib2.client.messages.HistoryRecordRelevantLinkTypes;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.ModuleLinkType;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractLinkTypeHelper
implements ILinkTypeHelper {
    private final String moduleID;
    private final ILinkTypeHelper_Shared linkTypeHelper_shared;
    private final IDataTypesHelper dataTypesHelper;
    private final Map<String, HistoryRecordRelevantLinkTypes> map_dataTypeID_historyRecordRelevantLinkTypes = new HashMap<String, HistoryRecordRelevantLinkTypes>();

    public AbstractLinkTypeHelper(String moduleID, ILinkTypeHelper_Shared linkTypeHelper_shared, IDataTypesHelper dataTypesHelper) {
        this.moduleID = moduleID;
        this.linkTypeHelper_shared = linkTypeHelper_shared;
        this.dataTypesHelper = dataTypesHelper;
    }

    @Override
    public final Collection<ILinkType> getAllLinkTypes() {
        LinkedList<ILinkType> linkTypes = new LinkedList<ILinkType>();
        for (String dataTypeID : this.dataTypesHelper.getRootDocumentationDataTypes()) {
            linkTypes.add(new ModuleLinkType(this.getSectionLinkTypeID(dataTypeID), AbstractLinkTypeHelper.getDisplayNameForSectionHierarchyLink(this.dataTypesHelper.getTypeDescription(dataTypeID)), this.moduleID, "com.arcway.cockpit.section", (ILinkCardinality)new CardinalityNN(), false, false, this));
        }
        linkTypes.addAll(this.getAdditionalLinkTypes());
        return linkTypes;
    }

    @Override
    public final void getAllLinkedDataAccessFacades(Collection<ILinkedDataAccessFacade> LOLinkedDataAccessFacades, Collection<ILinkedDataAccessFacade> MDLinkedDataAccessFacades, AbstractDataMgr dataManager) {
        Collection<String> LOTypeIDs = this.getAllLinkableObjectContributionTypes();
        for (String LOTypeID : LOTypeIDs) {
            LOLinkedDataAccessFacades.add((ILinkedDataAccessFacade)new ModuleLinkedDataAccessFacade(LOTypeID, dataManager));
        }
        Collection<String> MDTypeIDs = this.getAllModuleDataContributionTypes();
        for (String MDTypeID : MDTypeIDs) {
            MDLinkedDataAccessFacades.add((ILinkedDataAccessFacade)new ModuleLinkedDataAccessFacade(MDTypeID, dataManager));
        }
        this.getAdditionalLinkedDataAccessFacades(LOLinkedDataAccessFacades, MDLinkedDataAccessFacades, dataManager);
    }

    private Collection<String> getAllLinkableObjectContributionTypes() {
        Collection<ILinkType> linkTypes = this.getAllLinkTypes();
        HashSet<String> linkableObjectContributions = new HashSet<String>(linkTypes.size());
        for (ILinkType linkType : linkTypes) {
            String loTypeID = this.getLinkTargetDataTypeIDForLinkType(linkType.getUID());
            if (loTypeID == null || !this.dataTypesHelper.getAllDataTypes().contains(loTypeID)) continue;
            linkableObjectContributions.add(loTypeID);
        }
        return linkableObjectContributions;
    }

    private Collection<String> getAllModuleDataContributionTypes() {
        Collection<ILinkType> linkTypes = this.getAllLinkTypes();
        HashSet<String> moduleDataContributions = new HashSet<String>(linkTypes.size());
        for (ILinkType linkType : linkTypes) {
            String mdTypeID = this.getLinkSourceDataTypeIDForLinkType(linkType.getUID());
            if (mdTypeID == null || !this.dataTypesHelper.getAllDataTypes().contains(mdTypeID)) continue;
            moduleDataContributions.add(mdTypeID);
        }
        return moduleDataContributions;
    }

    protected Collection<ILinkType> getAdditionalLinkTypes() {
        return Collections.emptyList();
    }

    protected void getAdditionalLinkedDataAccessFacades(Collection<ILinkedDataAccessFacade> LOLinkedDataAccessFacades, Collection<ILinkedDataAccessFacade> MDLinkedDataAccessFacades, AbstractDataMgr dataManager) {
    }

    public String getDataTypeIDForSectionLinkTypeID(String linkTypeID) {
        return this.linkTypeHelper_shared.getDataTypeIDForSectionLinkTypeID(linkTypeID);
    }

    public String getHierarchyLinkTypeID(String parentTypeID, String childTypeID) {
        return this.linkTypeHelper_shared.getHierarchyLinkTypeID(parentTypeID, childTypeID);
    }

    public String getLinkTargetDataTypeIDForLinkType(String linkTypeID) {
        return this.linkTypeHelper_shared.getLinkTargetDataTypeIDForLinkType(linkTypeID);
    }

    public Collection<String> getLinkTypeIDsForLinkableObjectDataType(String dataTypeUID) {
        return this.linkTypeHelper_shared.getLinkTypeIDsForLinkableObjectDataType(dataTypeUID);
    }

    public Collection<String> getLinkTypeIDsForModuleDataDataType(String dataTypeUID) {
        return this.linkTypeHelper_shared.getLinkTypeIDsForModuleDataDataType(dataTypeUID);
    }

    public String getModelElementLinkTypeIDForModuleDataDataType(String dataTypeUID) {
        return this.linkTypeHelper_shared.getModelElementLinkTypeIDForModuleDataDataType(dataTypeUID);
    }

    public String getLinkSourceDataTypeIDForLinkType(String linkTypeID) {
        return this.linkTypeHelper_shared.getLinkSourceDataTypeIDForLinkType(linkTypeID);
    }

    public String getSectionLinkTypeID(String childTypeID) {
        return this.linkTypeHelper_shared.getSectionLinkTypeID(childTypeID);
    }

    public boolean isLELinkType(String linkTypeID) {
        return this.linkTypeHelper_shared.isLELinkType(linkTypeID);
    }

    public boolean isSectionLinkTypeID(String linkTypeID) {
        return this.linkTypeHelper_shared.isSectionLinkTypeID(linkTypeID);
    }

    public boolean isUELinkType(String linkTypeID) {
        return this.linkTypeHelper_shared.isUELinkType(linkTypeID);
    }

    protected static String getDisplayNameForHierarchyLink(String childObjectTypeName, String parentObjectTypeName) {
        return NLS.bind((String)Messages.getString("ModuleLinkTypes.ModuleLinkTypes.HierarchyLinkDisplayNamePrefix"), (Object)childObjectTypeName, (Object)parentObjectTypeName);
    }

    protected static String getDisplayNameForHierarchyLink(IModuleDataTypeDescription childTypeDescription, IModuleDataTypeDescription parentTypeDescription) {
        return AbstractLinkTypeHelper.getDisplayNameForHierarchyLink(childTypeDescription.getTypeName(Locale.getDefault()), parentTypeDescription.getTypeName(Locale.getDefault()));
    }

    protected static String getDisplayNameForSectionHierarchyLink(String childObjectTypeName) {
        return NLS.bind((String)Messages.getString("ModuleLinkTypes.ModuleLinkTypes.HierarchyLinkDisplayNamePrefix"), (Object)childObjectTypeName, (Object)FrameDataTypes.getDataType((String)"com.arcway.cockpit.section").getDisplayName());
    }

    protected static String getDisplayNameForSectionHierarchyLink(IModuleDataTypeDescription childTypeDescription) {
        return AbstractLinkTypeHelper.getDisplayNameForSectionHierarchyLink(childTypeDescription.getTypeName(Locale.getDefault()));
    }

    protected static String getDisplayNameForModelElementLink(String childObjectTypeName) {
        return NLS.bind((String)Messages.getString("ModuleLinkTypes.ModuleLinkTypes.ModelElementLinkDisplayNamePrefix"), (Object)childObjectTypeName);
    }

    protected static String getDisplayNameForModelElementLink(IModuleDataTypeDescription childTypeDescription) {
        return AbstractLinkTypeHelper.getDisplayNameForModelElementLink(childTypeDescription.getTypeName(Locale.getDefault()));
    }

    @Override
    public HistoryRecordRelevantLinkTypes getLinkTypesForHistoryRecord(String dataTypeID) {
        HistoryRecordRelevantLinkTypes linkTypes = this.map_dataTypeID_historyRecordRelevantLinkTypes.get(dataTypeID);
        if (linkTypes == null) {
            IModuleDataTypeDescription typeDescription = this.dataTypesHelper.getTypeDescription(dataTypeID);
            HashSet<String> childrenLinkTypeIDs = new HashSet<String>();
            if (typeDescription.getHistoryRecordMode().equals("complete")) {
                for (String childTypeID : this.dataTypesHelper.getChildTypeIDs(dataTypeID)) {
                    childrenLinkTypeIDs.add(this.getHierarchyLinkTypeID(dataTypeID, childTypeID));
                }
            }
            HashSet<String> moduleDataAttributeLinkTypeIDs = new HashSet<String>();
            HashSet<String> frameDataAttributeLinkTypeIDs = new HashSet<String>();
            if (typeDescription.getHistoryRecordMode().equals("complete") || typeDescription.getHistoryRecordMode().equals("without-structure")) {
                for (String linkedModuleDataAttributeID : typeDescription.getLinkedModuleDataAttributeIDs()) {
                    moduleDataAttributeLinkTypeIDs.add(typeDescription.getLinkTypeIDForLinkedModuleDataAttribute(linkedModuleDataAttributeID));
                }
                for (String linkedFrameDataAttributeID : typeDescription.getLinkedFrameDataAttributeIDs()) {
                    frameDataAttributeLinkTypeIDs.add(typeDescription.getLinkTypeIDForLinkedFrameDataAttribute(linkedFrameDataAttributeID));
                }
            }
            linkTypes = new HistoryRecordRelevantLinkTypes(childrenLinkTypeIDs, moduleDataAttributeLinkTypeIDs, frameDataAttributeLinkTypeIDs);
            this.map_dataTypeID_historyRecordRelevantLinkTypes.put(dataTypeID, linkTypes);
        }
        return linkTypes;
    }
}

