/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs;

import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeProvider;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataPropertyDialogProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.ui.IModificationProblem;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class ModuleDataPropertyListEntry
implements IPropertiesListEntry,
IEditDialogErrorCallback,
IObjectTypeCategoryChangeProvider {
    protected IPropertiesDialog dialog;
    protected IModuleDataPropertyDialogProvider provider = this.getProvider();
    private boolean hasChanges;
    private final String message;
    private final String description;

    public ModuleDataPropertyListEntry(String title, String description) {
        this.message = title;
        this.description = description;
    }

    protected abstract IModuleDataPropertyDialogProvider getProvider();

    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog dialog_, boolean forCreation_) {
        assert (elements != null) : "element must not be null";
        assert (dialog_ != null) : "dialog must not be null";
        if (this.dialog != dialog_) {
            this.dialog = dialog_;
            IModuleData[] items = new IModuleData[elements.length];
            System.arraycopy(elements, 0, items, 0, elements.length);
            return this.provider.setItems(items, null);
        }
        return null;
    }

    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void setCommitable(boolean commitable) {
        this.dialog.setIsCommitable(commitable, (IPropertiesListEntry)this);
    }

    protected abstract AbstractModulePlugin getPlugin();

    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (this.provider.isMultipleEditPossible() || elements.length == 1) {
            boolean providesProperties = true;
            int i = 0;
            while (i < elements.length && providesProperties) {
                providesProperties = elements[i].getTypeID().equals(this.provider.getDataTypeID());
                if (elements[i] instanceof IModuleData) {
                    providesProperties &= this.provider.providesPropertiesFor((IModuleData)elements[i]);
                }
                ++i;
            }
            return providesProperties;
        }
        return false;
    }

    public Composite getPropertyPage(Composite parent) {
        this.dialog.setTitle(this.message, (IPropertiesListEntry)this);
        this.dialog.setMessage(this.description, 0, (IPropertiesListEntry)this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        return this.provider.createEditPage(parent);
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public String getPropertyName() {
        return this.provider.getPropertyName();
    }

    public Image getPropertyImage() {
        return this.provider.getPropertyImage();
    }

    @Override
    public void setErrMsg(String errorMessage) {
        this.dialog.setMessage(errorMessage, 3, (IPropertiesListEntry)this);
        this.dialog.setIsCommitable(errorMessage == null, (IPropertiesListEntry)this);
    }

    @Override
    public void setMessage(String message, int type) {
        this.dialog.setMessage(message, type, (IPropertiesListEntry)this);
    }

    @Override
    public void clearErrorMessage() {
        this.dialog.setMessage(null, 3, (IPropertiesListEntry)this);
        this.dialog.setIsCommitable(true, (IPropertiesListEntry)this);
    }

    @Override
    public void setChangedStatus(boolean hasChanged) {
        this.hasChanges = hasChanged;
    }

    public Collection<IModificationProblem> getModificationProblems() {
        return Collections.emptyList();
    }

    public void cancelPropertyChanges1() {
        this.provider.cancelChanges1();
    }

    public void commitPropertyChanges1() {
        this.provider.commitChanges1();
        this.setChangedStatus(false);
    }

    public void disposeResources() {
    }

    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    public int getTypeOfPage() {
        return 0;
    }

    public Collection<IModificationProblem> requestCommit() {
        return this.provider.requestCommit();
    }

    public void rollbackCommitRequest() {
        this.provider.rollbackCommitRequest();
    }

    @Override
    public void setDirty() {
    }

    public void addCategoryChangeListener(IObjectTypeCategoryChangeListener listener, boolean fireNotifyEventOnAdd) {
        if (this.provider instanceof IObjectTypeCategoryChangeProvider) {
            ((IObjectTypeCategoryChangeProvider)this.provider).addCategoryChangeListener(listener, fireNotifyEventOnAdd);
        }
    }

    public void removeCategoryChangeListener(IObjectTypeCategoryChangeListener listener) {
        if (this.provider instanceof IObjectTypeCategoryChangeProvider) {
            ((IObjectTypeCategoryChangeProvider)this.provider).removeCategoryChangeListener(listener);
        }
    }
}

