/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IActiveProjectProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.eclipse.transfer.SerializableDataTypeTransferAgentWithVariableDataType;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.interFace.data.object.DTCollection_RepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class ItemEditorDragSupport
implements IModuleProjectSwitchListener,
IActiveProjectProvider {
    private final SerializableDataTypeTransferAgentWithVariableDataType transfer;
    private final IProjectAgentProvider projectAgentProvider;
    protected String projectUID;
    private static ItemEditorDnDTransferContent transferData = null;

    public ItemEditorDragSupport(IProjectAgentProvider projectAgentProvider, String projectUID) {
        this.projectAgentProvider = projectAgentProvider;
        this.projectUID = projectUID;
        this.transfer = new SerializableDataTypeTransferAgentWithVariableDataType("RelationsWidget");
        if (projectUID != null) {
            IRepositoryTypeManagerRO typeManager = ProjectMgr.getProjectMgr().getProjectAgent(projectUID).getRepositoryInterface().getTypeManager();
            this.transfer.setDataType((IDataType)DTCollection_RepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager));
        }
    }

    public DragSource getDragSource() {
        return new DragSource(this.getDragOperations(), this.getTransfers(), this.getDragHandler(), null, this.projectAgentProvider, (IActiveProjectProvider)this);
    }

    private int getDragOperations() {
        return 20;
    }

    private Set<Transfer> getTransfers() {
        return Collections.singleton(this.transfer);
    }

    private IDragHandler getDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){

            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectedItems = ((IStructuredSelection)selection).toList();
                ArrayList<IModuleData> selectedItemsAsModuleData = new ArrayList<IModuleData>(selectedItems.size());
                for (Object selectedItem : selectedItems) {
                    if (selectedItem instanceof IModuleData) {
                        selectedItemsAsModuleData.add((IModuleData)selectedItem);
                        continue;
                    }
                    return false;
                }
                transferData = new ItemEditorDnDTransferContent(selectedItemsAsModuleData, ItemEditorDragSupport.this.projectUID);
                return true;
            }

            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                Collection<IModuleData> items = transferData.itemsToBeDragged;
                ArrayList_ result = new ArrayList_();
                ProjectAgent moduleProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(ItemEditorDragSupport.this.projectUID);
                IRepositoryInterfaceRO repositoryInterface = moduleProjectAgent.getRepositoryInterface();
                for (IModuleData moduleData : items) {
                    CockpitDataID cockpitDataID = new CockpitDataID(moduleData.getTypeID(), moduleData.getUID());
                    RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor((IModuleProjectAgent)moduleProjectAgent, (ICockpitDataID)cockpitDataID, (ICollectionRW_)result){
                        private final /* synthetic */ IModuleProjectAgent val$moduleProjectAgent;
                        private final /* synthetic */ ICockpitDataID val$cockpitDataID;
                        private final /* synthetic */ ICollectionRW_ val$result;
                        {
                            this.val$moduleProjectAgent = iModuleProjectAgent;
                            this.val$cockpitDataID = iCockpitDataID;
                            this.val$result = iCollectionRW_;
                        }

                        public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                            IRepositoryObject repositoryObject = this.val$moduleProjectAgent.findRepositoryObject(repositorySnapshot, this.val$cockpitDataID);
                            this.val$result.add((Object)new RepositoryObjectReference(repositoryObject));
                        }
                    });
                }
                ItemEditorDragSupport.this.updateTransferAgent(repositoryInterface.getTypeManager());
                return result;
            }

            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                transferData = null;
            }
        };
        return dragHandler;
    }

    public void projectSwitched(String projectUID_) {
        this.projectUID = projectUID_;
    }

    private void updateTransferAgent(IRepositoryTypeManagerRO typeManager) {
        this.transfer.setDataType((IDataType)DTCollection_RepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager));
    }

    public String getActiveProject() {
        return this.projectUID;
    }

    private class ItemEditorDnDTransferContent {
        public String uid;
        public String projectUID_;
        public Collection<IModuleData> itemsToBeDragged;

        public ItemEditorDnDTransferContent(Collection<IModuleData> itemsToBeDragged, String projectUID) {
            this.itemsToBeDragged = itemsToBeDragged;
            this.projectUID_ = projectUID;
            this.uid = UUIDGenerator.getUniqueID();
        }
    }
}

