/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dnd;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.editors.IDropListener;
import com.arcway.cockpit.frame.shared.message.EOLink;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractEditorDropListener
implements IDropListener {
    private static final int defaultMode = 4;

    public int isDropOnUniqueElementAllowed(IUniqueElement uniqueElement, int modesAllowed, int modeWished, Object payLoad) {
        boolean cardinalityOk = true;
        if (payLoad != null && payLoad instanceof Collection) {
            Iterator itemIterator = ((Collection)payLoad).iterator();
            while (itemIterator.hasNext()) {
                Collection<? extends EOLink> existingLinks = this.getExistingLinksForModuleDataItem(itemIterator.next());
                if (existingLinks == null) continue;
                for (EOLink eOLink : existingLinks) {
                    String linkableObjectsUID = eOLink.getLinkableObjectUID();
                    String uniqueElementsUID = uniqueElement.getUID();
                    if (!uniqueElementsUID.equals(linkableObjectsUID)) continue;
                    cardinalityOk = false;
                    break;
                }
                if (cardinalityOk) {
                    continue;
                }
                break;
            }
        } else {
            cardinalityOk = false;
        }
        int mode = cardinalityOk ? 4 : 0;
        return mode & modesAllowed;
    }

    public boolean dropOnUniqueElement(IUniqueElement uniqueElement, int modesAllowed, int mode, Object payLoad) {
        if (payLoad instanceof Collection) {
            Iterator i = ((Collection)payLoad).iterator();
            while (i.hasNext()) {
                this.createLink(uniqueElement, i.next());
            }
            return true;
        }
        return false;
    }

    protected abstract Collection<? extends EOLink> getExistingLinksForModuleDataItem(Object var1);

    protected abstract void createLink(IUniqueElement var1, Object var2);
}

