/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.properties.CEProperties;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataView;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ActionDelegateSelectAll;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.DelegateBasedModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.frame.client.lib.dataviews.search.IItemTypeForSearchProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewSortingState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperWO;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ChangeValueActionMenuManager;
import com.arcway.cockpit.modulelib2.client.gui.ViewModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataView;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewStateModelAccess;
import com.arcway.cockpit.modulelib2.client.gui.filters.FilterHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.EitherOr;
import com.arcway.lib.java.collectionmaps.ListMap;
import de.plans.lib.util.incrementalsearch.ISearchAlgorithm;
import de.plans.lib.util.incrementalsearch.JavaStdRegexSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public abstract class StandardTreeDataViewProvider
extends CockpitTreeDataViewProvider<IModuleData> {
    protected final StandardTreeDataView dataView;
    private final ChangeValueActionMenuManager changeValueActionMenuManager;
    private final Collection<String> customPropertyFilterDataTypes;
    private final IFixColumnDescriptionProvider fixColumnDescriptionProvider;
    private final IModuleFixColumnProvider fixColumnContentProvider;
    private HashSet<Class<?>> dataTypesThatTriggerRefresh;

    public StandardTreeDataViewProvider(StandardTreeDataView dataView, Collection<String> customPropertyFilterDataTypes, IFixColumnDescriptionProvider fixColumnDescriptionProvider, IModuleFixColumnProvider fixColumnContentProvider) {
        super((CockpitTreeDataView)dataView);
        this.dataView = dataView;
        this.changeValueActionMenuManager = new ChangeValueActionMenuManager();
        this.customPropertyFilterDataTypes = customPropertyFilterDataTypes != null ? customPropertyFilterDataTypes : Collections.emptySet();
        this.fixColumnDescriptionProvider = fixColumnDescriptionProvider;
        this.fixColumnContentProvider = fixColumnContentProvider;
    }

    public boolean hasNewMenu() {
        return true;
    }

    public String getAlternativeNewMenuID() {
        return null;
    }

    public List<String> getNewMenuSeparatorIDs() {
        return Arrays.asList("com.arcway.cockpit.contextmenu.new.aschild.separator", "com.arcway.cockpit.contextmenu.new.asroot.separator");
    }

    public final IAction getDeleteAction() {
        ModuleActionDelegate deleteActionDelegate = this.getDeleteActionDelegate();
        if (deleteActionDelegate != null) {
            DelegateBasedModuleAction deleteAction = new DelegateBasedModuleAction(deleteActionDelegate);
            deleteAction.setText(Messages.getString("AbstractDataView.DeleteActionText"));
            return deleteAction;
        }
        return null;
    }

    protected abstract ModuleActionDelegate getDeleteActionDelegate();

    public final IAction getCopyAction() {
        DelegateBasedModuleAction copyAction = new DelegateBasedModuleAction(this.getCopyActionDelegate());
        copyAction.setText(Messages.getString("AbstractDataView.CopyActionText"));
        return copyAction;
    }

    protected abstract ModuleActionDelegate getCopyActionDelegate();

    public final IAction getCutAction() {
        return null;
    }

    public final IAction getPasteAction() {
        DelegateBasedModuleAction pasteAction = new DelegateBasedModuleAction(this.getPasteActionDelegate());
        pasteAction.setText(Messages.getString("AbstractDataView.PasteActionText"));
        return pasteAction;
    }

    protected abstract ModuleActionDelegate getPasteActionDelegate();

    public final IAction getSelectAllAction() {
        DelegateBasedModuleAction selectAllAction = new DelegateBasedModuleAction((ModuleActionDelegate)new ActionDelegateSelectAll((AbstractDataView)this.dataView));
        return selectAllAction;
    }

    public List<EitherOr<IAction, IContributionItem>> getAdditionalContextMenuActions() {
        return Collections.singletonList(new EitherOr.Or((Object)this.changeValueActionMenuManager.getMenuManager()));
    }

    protected final ChangeValueActionMenuManager getChangeValueActionMenuManager() {
        return this.changeValueActionMenuManager;
    }

    protected abstract ListMap<String, IDiscreteAttributeHandler> getDiscreteAttributeHandlers();

    protected abstract IClientFunctionLicenseType2 getRequiredLicenseTypeForChangeValueActions();

    public final ISearchAlgorithm getSearchAlgorithm() {
        return new JavaStdRegexSearch();
    }

    public IItemTypeForSearchProvider<IModuleData> getItemTypeProviderForSearch() {
        return new IItemTypeForSearchProvider<IModuleData>(){

            public String getTypeID(IModuleData dataItem) {
                return dataItem.getTypeID();
            }
        };
    }

    public IOpenListener createOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                CEProperties.Input input = CEProperties.checkSuitabilityForPropertiesCommand((ISelection)event.getSelection());
                if (input != null) {
                    CEProperties.openProperties((CEProperties.Input)input, (IWorkbenchPage)StandardTreeDataViewProvider.this.dataView.getSite().getPage());
                }
            }
        };
    }

    public List<IFilterItem> createProjectSpecificFilterItems(String projectUID) {
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>();
        if (projectUID != null) {
            IModelController modelController = this.getProjectAssociationManager().getModelController(projectUID);
            for (String dataTypeID : this.customPropertyFilterDataTypes) {
                FilterHelper.getCustomPropertyFilters(dataTypeID, filterItems, modelController);
            }
        }
        return filterItems;
    }

    public boolean isRetainingTreeStructuresWhenFiltering() {
        return false;
    }

    protected CockpitTreeDataViewProvider.IFixColumnProvider<IModuleData> getFixColumnProvider() {
        return new CockpitTreeDataViewProvider.IFixColumnProvider<IModuleData>(){

            public Collection<IColumnDescription> getColumnDescriptions() {
                return StandardTreeDataViewProvider.this.fixColumnDescriptionProvider.getColumnDescriptions();
            }

            public Image getColumnImage(IModuleData dataItem, String columnID) {
                return StandardTreeDataViewProvider.this.fixColumnContentProvider.getColumnImage(dataItem, columnID);
            }

            public String getColumnText(IModuleData dataItem, String columnID) {
                return StandardTreeDataViewProvider.this.fixColumnContentProvider.getColumnText(dataItem, columnID);
            }
        };
    }

    protected final CockpitTreeDataViewProvider.IGeneralColumnProvider<IModuleData> getGeneralColumnProvider() {
        return new CockpitTreeDataViewProvider.IGeneralColumnProvider<IModuleData>(){

            public boolean isCategoryColumnNeeded() {
                return StandardTreeDataViewProvider.this.isObjectTypeCategoryColumnNeeded();
            }

            public ObjectTypeCategory getCategory(IModuleData dataItem) {
                return ObjectTypeCategories.getCategoryForItem((ICategoryOwner)dataItem);
            }

            public String getAuthor(IModuleData dataItem) {
                return dataItem.getCreator().getDisplayStringRepresentation();
            }

            public Long getCreationDate(IModuleData dataItem) {
                return (long)dataItem.getCreationTime().getValue();
            }

            public String getCreationDateStringRepresentation(IModuleData dataItem) {
                return dataItem.getCreationTime().getDisplayStringRepresentation();
            }

            public String getLastModifier(IModuleData dataItem) {
                return dataItem.getModifier().getDisplayStringRepresentation();
            }

            public Long getDateOfLastModification(IModuleData dataItem) {
                return (long)dataItem.getModificationTime().getValue();
            }

            public String getDateOfLastModificationStringRepresentation(IModuleData dataItem) {
                return dataItem.getModificationTime().getDisplayStringRepresentation();
            }
        };
    }

    protected abstract boolean isObjectTypeCategoryColumnNeeded();

    protected CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<IModuleData> getCustomPropertyColumnProvider() {
        return new CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<IModuleData>(){

            public Collection<String> getDatatypesForWhichCustomPropertyColumnsAreToBeCreated() {
                return StandardTreeDataViewProvider.this.getDataTypesHelper().getDocumentationCustomPropertyDataTypes();
            }

            public String getProjectUID(IModuleData dataItem) {
                return dataItem.getProjectUID();
            }

            public IAttributeOwner getAttributeOwner(IModuleData dataItem) {
                IModuleUserDefinedAttributeTypesManager typesManager = com.arcway.cockpit.frame.client.global.ProjectMgr.getProjectMgr().getProjectAgent(dataItem.getProjectUID()).getModuleUserDefinedAttributeTypesManager();
                IModelController modelController = StandardTreeDataViewProvider.this.getProjectAssociationManager().getModelController(dataItem.getProjectUID());
                return new ViewModuleAttributeAgent(dataItem, typesManager, modelController);
            }
        };
    }

    public boolean hasNaturalOrder() {
        return true;
    }

    public TreeDataViewSorter<IModuleData> getSorter(String projectUID) {
        return new StandardTreeDataViewSorter(this.getProjectAssociationManager().getModelController(projectUID), (IDataViewSortingState)this.dataView);
    }

    public ITreeDataViewStateSerialisationHelperProvider<IModuleData> getTreeDataViewStateSerialisationHelperProvider() {
        return new ITreeDataViewStateSerialisationHelperProvider<IModuleData>(){

            public ITreeDataViewStateSerialisationHelper<IModuleData> getTreeDataViewStateSerialisationHelper(String projectUID) {
                IModelController modelController = StandardTreeDataViewProvider.this.getProjectAssociationManager().getModelController(projectUID);
                if (modelController != null) {
                    return StandardTreeDataViewStateModelAccess.getInstance(modelController);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            public ITreeDataViewStateSerialisationHelperWO<IModuleData> getTreeDataViewStateSerialisationHelperWO(String projectUID) {
                return StandardTreeDataViewStateModelAccess.getInstanceWO();
            }
        };
    }

    protected Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        if (this.dataTypesThatTriggerRefresh == null) {
            this.dataTypesThatTriggerRefresh = new HashSet();
            this.dataTypesThatTriggerRefresh.add(IAttributeType.class);
            this.dataTypesThatTriggerRefresh.add(IModuleData.class);
            this.dataTypesThatTriggerRefresh.add(EOLink.class);
            this.dataTypesThatTriggerRefresh.add(ObjectTypeCategory.class);
            this.dataTypesThatTriggerRefresh.addAll(this.getAdditionalClassesThatTriggerRefresh());
        }
        return this.dataTypesThatTriggerRefresh;
    }

    protected abstract Collection<Class<?>> getAdditionalClassesThatTriggerRefresh();

    protected abstract ProjectMgr getProjectAssociationManager();

    protected abstract IDataTypesHelper getDataTypesHelper();
}

