/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.DiscreteValueAction;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ChangeValueActionMenuManager
implements IMenuListener {
    private final MenuManagerWithMenuListenerInterface attributeSubmenu = new MenuManagerWithMenuListenerInterface(Messages.getString("AbstractDataView.AttrSubMenuTitle"));
    private Collection<IDiscreteAttributeHandler> discreteAttributeHandlers;
    private ISelectionProvider selectionProvider;
    private IClientFunctionLicenseType2 requiredLicenseType;
    private Shell shell;

    public ChangeValueActionMenuManager() {
        this.attributeSubmenu.setMenuListener(this);
        this.attributeSubmenu.setVisible(true);
    }

    public void setConfiguration(Collection<IDiscreteAttributeHandler> discreteAttributeHandlers, ISelectionProvider selectionProvider, IClientFunctionLicenseType2 requiredLicenseType, Shell shell) {
        this.discreteAttributeHandlers = discreteAttributeHandlers;
        this.selectionProvider = selectionProvider;
        this.requiredLicenseType = requiredLicenseType;
        this.shell = shell;
    }

    public MenuManagerWithMenuListenerInterface getMenuManager() {
        return this.attributeSubmenu;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.attributeSubmenu.removeAll();
        ISelection rawSelection = this.selectionProvider.getSelection();
        if (!(rawSelection instanceof IStructuredSelection) || rawSelection.isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)rawSelection;
        String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        String projectLanguage = projectAgent.getLanguage();
        boolean licenseAvailable = this.checkLicense((IFrameProjectAgent)projectAgent);
        for (IDiscreteAttributeHandler handler : this.discreteAttributeHandlers) {
            boolean isApplicableForAllItems = true;
            boolean isToBeEnabled = true;
            HashSet<Integer> currentValues = new HashSet<Integer>(handler.getValueRange().size());
            for (Object element : selection.toList()) {
                if (!handler.registerFor(element)) {
                    isApplicableForAllItems = false;
                    break;
                }
                if (!handler.enableFor(element)) {
                    isToBeEnabled = false;
                    continue;
                }
                currentValues.add(handler.getCurrentValueIndex(element));
            }
            if (!isApplicableForAllItems) continue;
            if (isToBeEnabled) {
                IAction[] actions;
                MenuManager submenu = new MenuManager(handler.getMenuEntryName(), handler.getID());
                submenu.setVisible(true);
                IAction[] iActionArray = actions = this.createDiscreteActions(handler, selection, projectLanguage, licenseAvailable, currentValues);
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction action = iActionArray[n2];
                    submenu.add(action);
                    ++n2;
                }
                this.attributeSubmenu.add((IContributionItem)submenu);
                continue;
            }
            Action action = new Action(){};
            action.setId(handler.getID());
            action.setText(handler.getMenuEntryName());
            action.setEnabled(false);
            this.attributeSubmenu.add((IContributionItem)new ActionContributionItem((IAction)action));
        }
    }

    private IAction[] createDiscreteActions(IDiscreteAttributeHandler handler, IStructuredSelection selection, String projectLanguage, boolean licenseAvailable, Set<Integer> currentValues) {
        List<? extends DiscreteValue> valueRange = handler.getValueRange();
        IAction[] actions = new IAction[valueRange.size()];
        int i = 0;
        for (DiscreteValue discreteValue : valueRange) {
            actions[i] = new DiscreteValueAction(handler, i, discreteValue, projectLanguage, currentValues.contains(i), this.shell, selection, licenseAvailable);
            ++i;
        }
        return actions;
    }

    private boolean checkLicense(IFrameProjectAgent projectAgent) {
        if (projectAgent != null) {
            boolean hasLicense = true;
            if (this.requiredLicenseType != null) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense((IClientFunctionLicenseType)this.requiredLicenseType);
                hasLicense = !this.requiredLicenseType.isDenial(license);
            }
            return hasLicense;
        }
        return false;
    }

    private static class MenuManagerWithMenuListenerInterface
    extends MenuManager
    implements IMenuListener {
        private IMenuListener listener = null;

        public MenuManagerWithMenuListenerInterface(String text) {
            super(text);
        }

        public void setMenuListener(IMenuListener listener) {
            this.listener = listener;
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (this.listener != null) {
                this.listener.menuAboutToShow(manager);
            }
        }
    }
}

