/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.DataPotEnumValue;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.MappableDataPotDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription;
import java.util.ArrayList;
import java.util.List;

public class SourceAttributeDescription
implements ISourceAttributeDescription<Object, String, String> {
    private final Object sourceAttributeKey;
    private final String sourceAttributeDataTypeKey;
    private final List<EnumValue<String>> valueRange;
    private final String sourceAttributeName;
    private final String sourceAttributeLabel;
    private final String sourceAttributeDescription;

    public SourceAttributeDescription(MappableDataPotDescription mappableDataPot) {
        this.sourceAttributeKey = mappableDataPot.getDataPotKey();
        this.sourceAttributeDataTypeKey = mappableDataPot.getDataPotDataType();
        String name = mappableDataPot.getDataPotName();
        String id = mappableDataPot.getDataPotID();
        String type = mappableDataPot.getDataPotDataTypeName();
        String valueRangeDescription = mappableDataPot.getDataPotValueRangeDescription();
        StringBuffer label = new StringBuffer();
        StringBuffer tooltip = new StringBuffer();
        label.append(name);
        if (id != null) {
            tooltip.append(String.valueOf(Messages.getString("AttributeMappingPage.tooltip_ID")) + id + "\n");
        }
        tooltip.append(String.valueOf(Messages.getString("AttributeMappingPage.tooltip_Name")) + name + "\n");
        if (type != null) {
            label.append(" (" + type + ")");
            tooltip.append(String.valueOf(Messages.getString("AttributeMappingPage.tooltip_Type")) + type + "\n");
        }
        if (valueRangeDescription != null) {
            tooltip.append(String.valueOf(Messages.getString("AttributeMappingPage.tooltip_ValueRange")) + valueRangeDescription + "\n");
        }
        this.sourceAttributeName = name;
        this.sourceAttributeLabel = label.toString();
        this.sourceAttributeDescription = tooltip.toString();
        this.valueRange = new ArrayList<EnumValue<String>>();
        for (DataPotEnumValue enumValue : mappableDataPot.getValueRange()) {
            String sourceEnumValueID = enumValue.getId();
            String sourceEnumValueCompareValue = enumValue.getLabel();
            String sourceEnumValueLabel = sourceEnumValueCompareValue.length() > 0 ? sourceEnumValueCompareValue : Messages.getString("AttributeMappingPage.enumvalue.label.empty");
            String sourceEnumValueTooltip = null;
            if (sourceEnumValueID != null) {
                sourceEnumValueTooltip = String.valueOf(Messages.getString("DiscreteEnumMappingDlg.IDLabelToolTip")) + sourceEnumValueID;
            }
            this.valueRange.add((EnumValue<String>)new EnumValue((Object)sourceEnumValueID, sourceEnumValueCompareValue, sourceEnumValueLabel, sourceEnumValueTooltip));
        }
    }

    public Object getKey() {
        return this.sourceAttributeKey;
    }

    public String getDataTypeKey() {
        return this.sourceAttributeDataTypeKey;
    }

    public List<EnumValue<String>> getValueRange() {
        return this.valueRange;
    }

    public String getName() {
        return this.sourceAttributeName;
    }

    public String getLabel() {
        return this.sourceAttributeLabel;
    }

    public String getTooltip() {
        return this.sourceAttributeDescription;
    }
}

