/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRangeDefiner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.dialogs.IDVerifyListener;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.RenameUserDefinedAttributeTypeValidator;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateCustomPropertyDialog
extends TitleAreaDialog {
    private static final ILogger logger = Logger.getLogger(CreateCustomPropertyDialog.class);
    private final IModuleProjectAgent projectAgent;
    private final IModuleDataTypeDescriptionForFrame moduleDataType;
    private final List<? extends IAttributeTypeDataType> cockpitAttributeTypeDataTypes;
    private IAttributeType newAttribute = null;
    private RenameUserDefinedAttributeTypeValidator idValidator;
    private RenameUserDefinedAttributeTypeValidator nameValidator;
    private String message;
    private Text idText;
    private Text nameText;
    private Combo dataTypeCombo;
    private Composite valueRangeDefinitionWidgetStack;
    private StackLayout valueRangeDefinitionWidgetStackLayout;
    private Control[] valueRangeDefinitionControls;

    public CreateCustomPropertyDialog(IModuleDataTypeDescriptionForFrame moduleDataType, List<? extends IAttributeTypeDataType> attributeTypeDataTypes, IModuleProjectAgent projectAgent, Shell parentShell) {
        super(parentShell);
        assert (projectAgent != null) : "projectAgent must not be null";
        assert (moduleDataType != null) : "dataTypeID must not be null";
        assert (attributeTypeDataTypes != null) : "cockpitAttributeTypeDataType must not be null";
        this.projectAgent = projectAgent;
        this.moduleDataType = moduleDataType;
        this.cockpitAttributeTypeDataTypes = attributeTypeDataTypes;
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.getString("CreateCustomPropertyDialog.shelltext"));
        this.setTitle(Messages.getString("CreateCustomPropertyDialog.title"));
        this.message = Messages.getString("CreateCustomPropertyDialog.message");
        this.setMessage(this.message);
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(3, false));
        Label idLabel = new Label(content, 0);
        idLabel.setText(Messages.getString("CreateCustomPropertyDialog.IDLabelText"));
        idLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.idText = new Text(content, 2052);
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.idValidator = new RenameUserDefinedAttributeTypeValidator(this.projectAgent, true, this.moduleDataType.getCockpitDataTypeID(), IAttributeTypesModifier.DUMMY);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateCustomPropertyDialog.this.handleModification();
            }
        });
        this.idText.addVerifyListener((VerifyListener)IDVerifyListener.getInstance());
        this.valueRangeDefinitionWidgetStack = new Composite(content, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 3;
        this.valueRangeDefinitionWidgetStack.setLayoutData((Object)gridData);
        Label nameLabel = new Label(content, 0);
        nameLabel.setText(Messages.getString("CreateCustomPropertyDialog.NameLabelText"));
        nameLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameText = new Text(content, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateCustomPropertyDialog.this.handleModification();
            }
        });
        this.nameValidator = new RenameUserDefinedAttributeTypeValidator(this.projectAgent, false, this.moduleDataType.getCockpitDataTypeID(), IAttributeTypesModifier.DUMMY);
        Label typeLabel = new Label(content, 0);
        typeLabel.setText(Messages.getString("CreateCustomPropertyDialog.TypeLabelText"));
        typeLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.dataTypeCombo = new Combo(content, 8);
        this.dataTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        String[] attributeDataTypeNames = new String[this.cockpitAttributeTypeDataTypes.size()];
        int index = 0;
        for (IAttributeTypeDataType iAttributeTypeDataType : this.cockpitAttributeTypeDataTypes) {
            attributeDataTypeNames[index] = iAttributeTypeDataType.getDisplayName();
            ++index;
        }
        this.dataTypeCombo.setItems(attributeDataTypeNames);
        this.dataTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateCustomPropertyDialog.this.handleModification_dataTypeSwitched();
            }
        });
        this.valueRangeDefinitionWidgetStackLayout = new StackLayout();
        this.valueRangeDefinitionWidgetStack.setLayout((Layout)this.valueRangeDefinitionWidgetStackLayout);
        this.valueRangeDefinitionControls = new Control[this.cockpitAttributeTypeDataTypes.size()];
        index = 0;
        for (IAttributeTypeDataType iAttributeTypeDataType : this.cockpitAttributeTypeDataTypes) {
            IValueRangeDefiner valueRangeHelper = iAttributeTypeDataType.getValueRangeHelper();
            if (valueRangeHelper != null) {
                Control valueRangeDefinitionControl;
                this.valueRangeDefinitionControls[index] = valueRangeDefinitionControl = valueRangeHelper.createSWTControl(this.valueRangeDefinitionWidgetStack, -1, IValueRangeDefiner.VALUEDELETIONPOLICY_ALWAYSALLOWED);
            } else {
                Label label = new Label(this.valueRangeDefinitionWidgetStack, 0);
                label.setText(Messages.getString("CreateCustomPropertyDialog.NoValueRangeLabelText"));
                this.valueRangeDefinitionControls[index] = label;
            }
            ++index;
        }
        this.valueRangeDefinitionWidgetStackLayout.topControl = this.valueRangeDefinitionControls[0];
        this.valueRangeDefinitionWidgetStack.layout();
        return content;
    }

    public void create() {
        super.create();
        this.handleModification();
    }

    private void handleModification() {
        String errMsg = null;
        errMsg = this.idValidator.isValid(this.idText.getText());
        if (errMsg == null) {
            errMsg = this.nameValidator.isValid(this.nameText.getText());
        }
        if (errMsg == null && this.dataTypeCombo.getSelectionIndex() == -1) {
            errMsg = "";
        }
        if (errMsg != null) {
            this.setMessage(errMsg, 1);
            this.getButton(0).setEnabled(false);
        } else {
            this.setMessage(this.message);
            this.getButton(0).setEnabled(true);
        }
    }

    private void handleModification_dataTypeSwitched() {
        int newIndex = this.dataTypeCombo.getSelectionIndex();
        this.valueRangeDefinitionWidgetStackLayout.topControl = this.valueRangeDefinitionControls[newIndex];
        this.valueRangeDefinitionWidgetStack.layout();
        this.handleModification();
    }

    protected void okPressed() {
        IModuleUserDefinedAttributeTypesManager typesManager = this.projectAgent.getModuleUserDefinedAttributeTypesManager();
        AttributeTypeID id = AttributeTypeID.getAttributeTypeID((String)UUIDGenerator.getUniqueID());
        String humanReadableID = AttributeType.createHumanReadableIDForCustomPropertyType((String)this.idText.getText());
        String highestUsedSortString = this.projectAgent.getModuleUserDefinedAttributeTypesManager().getHighestUsedSortString(this.moduleDataType.getCockpitDataTypeID());
        String newSortString = AttributeTypeSortCriterium.computeUsefulNextSortString((String)highestUsedSortString);
        int attributeDataTypeIndex = this.dataTypeCombo.getSelectionIndex();
        IAttributeTypeDataType attributeDataType = this.cockpitAttributeTypeDataTypes.get(attributeDataTypeIndex);
        IValueRangeDefiner valueRangeHelper = attributeDataType.getValueRangeHelper();
        Control valueRangeDefinitionWidget = this.valueRangeDefinitionControls[attributeDataTypeIndex];
        IValueRange valueRange = valueRangeHelper != null ? valueRangeHelper.getValueRangeFromSWTControl(valueRangeDefinitionWidget) : null;
        AttributeType attributeType = new AttributeType(this.projectAgent.getProjectUID(), (IAttributeTypeID)id, humanReadableID, this.nameText.getText(), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(IAttributeTypeSortCriterium.CATEGORY_USERDEFINED_ATTRIBUTE, newSortString), attributeDataType, (ICockpitDataType)this.moduleDataType, valueRange, true, true, false, false, false);
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController((IFrameProjectAgent)this.projectAgent);
        IAttributeTypesModifier modifier = new IAttributeTypesModifier((IAttributeType)attributeType){
            private final /* synthetic */ IAttributeType val$attributeType;
            {
                this.val$attributeType = iAttributeType;
            }

            public boolean isDeleted(IAttributeTypeID attributeTypeID) {
                return false;
            }

            public Collection<? extends IAttributeType> getModifiedAttributeTypes() {
                return Collections.emptyList();
            }

            public IAttributeType getModifiedAttributeType(IAttributeTypeID attributeTypeUID) {
                return null;
            }

            public Collection<? extends IAttributeType> getAddedAttributeTypes() {
                return Collections.singleton(this.val$attributeType);
            }
        };
        typesManager.requestAddAttributeTypePermissions((IAttributeType)attributeType, (ILocksAndPermissionsTransactionController)transactionController, modifier);
        Collection modificationProblems = transactionController.execute();
        if (!modificationProblems.isEmpty()) {
            ModificationProblemsDialog dialogue = new ModificationProblemsDialog(modificationProblems, Messages.getString("CreateCustomPropertyDialog.ModificationProblemText"), this.getParentShell());
            dialogue.open();
        } else {
            transactionController.execute();
            try {
                typesManager.addUserDefinedAttributeType((IAttributeType)attributeType);
                this.newAttribute = attributeType;
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
            super.okPressed();
        }
    }

    public IAttributeType getNewAttribute() {
        return this.newAttribute;
    }
}

