/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewSorter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class AbstractDataFacade
implements IDataFacade {
    protected IModel dataManager;
    protected IModelController modelController;
    private TreeDataViewSorter sorter;
    private Comparator<IModuleData> comparator;
    private static final ILogger logger = Logger.getLogger(AbstractDataFacade.class);

    @Override
    public IModelController getModelController() {
        return this.modelController;
    }

    @Override
    public void construct(IModel dataManager_, IModelController modelController_, IClientDataFactory clientDataFactory) {
        this.dataManager = dataManager_;
        this.modelController = modelController_;
        this.sorter = StandardTreeDataViewSorter.getSorterForNaturalOrder(this.modelController);
        this.comparator = StandardTreeDataViewSorter.getComparatorForNaturalOrder(this.modelController);
    }

    protected final void sortByNaturalOrder(List<? extends IModuleData> list) {
        if (logger.isDebugEnabled(36)) {
            AbstractDataFacade.checkChildOrder(list, this.comparator);
        }
        Collections.sort(list, this.comparator);
    }

    private static void checkChildOrder(Collection<? extends IModuleData> collection, Comparator<IModuleData> comparator) {
        ArrayList sortedObjects = new ArrayList(collection.size());
        for (IModuleData iModuleData : collection) {
            boolean bl = false;
            int i = 0;
            while (i < sortedObjects.size()) {
                List existingObjects = (List)sortedObjects.get(i);
                IModuleData exisiting = (IModuleData)existingObjects.get(0);
                int sgn = comparator.compare(iModuleData, exisiting);
                if (sgn <= 0) {
                    if (sgn == 0) {
                        existingObjects.add(iModuleData);
                        bl = true;
                        break;
                    }
                    ArrayList<IModuleData> newObjects = new ArrayList<IModuleData>();
                    sortedObjects.add(i, newObjects);
                    newObjects.add(iModuleData);
                    bl = true;
                    break;
                }
                ++i;
            }
            if (bl) continue;
            ArrayList<IModuleData> newObjects = new ArrayList<IModuleData>();
            sortedObjects.add(newObjects);
            newObjects.add(iModuleData);
            bl = true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int i = 0;
        while (i < sortedObjects.size()) {
            List list = (List)sortedObjects.get(i);
            for (IModuleData objectToCheck : list) {
                Object predecessor22;
                int j = 0;
                while (j < i) {
                    List predecessors = (List)sortedObjects.get(j);
                    for (Object predecessor22 : predecessors) {
                        int sgn = comparator.compare(objectToCheck, (IModuleData)predecessor22);
                        if (sgn < 0) {
                            arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " < predecessor " + AbstractDataFacade.getLabel((ICockpitProjectData)predecessor22));
                        }
                        if (sgn != 0) continue;
                        arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " = predecessor " + AbstractDataFacade.getLabel((ICockpitProjectData)predecessor22));
                    }
                    ++j;
                }
                List euquals = (List)sortedObjects.get(i);
                predecessor22 = euquals.iterator();
                while (predecessor22.hasNext()) {
                    IModuleData equal = (IModuleData)predecessor22.next();
                    int sgn = comparator.compare(objectToCheck, equal);
                    if (sgn < 0) {
                        arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " < equal " + AbstractDataFacade.getLabel((ICockpitProjectData)equal));
                    }
                    if (sgn <= 0) continue;
                    arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " > equal " + AbstractDataFacade.getLabel((ICockpitProjectData)equal));
                }
                int j2 = i + 1;
                while (j2 < sortedObjects.size()) {
                    List successors = (List)sortedObjects.get(j2);
                    for (IModuleData successor : successors) {
                        int sgn = comparator.compare(objectToCheck, successor);
                        if (sgn == 0) {
                            arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " = successor " + AbstractDataFacade.getLabel((ICockpitProjectData)successor));
                        }
                        if (sgn <= 0) continue;
                        arrayList.add(String.valueOf(AbstractDataFacade.getLabel((ICockpitProjectData)objectToCheck)) + " > successor " + AbstractDataFacade.getLabel((ICockpitProjectData)successor));
                    }
                    ++j2;
                }
            }
            ++i;
        }
        StringBuilder errorText = new StringBuilder();
        if (!arrayList.isEmpty()) {
            errorText.append("Inconsistently ordered child objects. Assumed the follwing order:\n");
        } else {
            errorText.append("Consistenlty ordered child objects in the follwing order:\n");
        }
        for (List list : sortedObjects) {
            for (ICockpitProjectData object : list) {
                errorText.append("- " + AbstractDataFacade.getLabel(object) + " ");
            }
            errorText.append("\n");
        }
        if (!arrayList.isEmpty()) {
            errorText.append("the folling inconsistencies appear:\n");
            for (String string : arrayList) {
                errorText.append("- " + string + "\n");
            }
        }
        if (arrayList.isEmpty()) {
            logger.info(errorText.toString());
        } else {
            logger.error(errorText.toString());
        }
    }

    private static String getLabel(ICockpitProjectData object) {
        return String.valueOf(object.getTypeID()) + "/" + object.getUID();
    }

    protected final int compareAccordingToNaturalOrder(IModuleData item1, IModuleData item2) {
        return this.sorter.compare(null, (Object)item1, (Object)item2);
    }

    protected static <T extends IModuleData> Collection<T> filter(Collection<T> data, Collection<AbstractFilter> filters) {
        assert (data != null) : "data must not be null";
        if (filters == null || filters.isEmpty()) {
            return data;
        }
        Object[] filteredData = data.toArray();
        for (ViewerFilter viewerFilter : filters) {
            filteredData = viewerFilter.filter(null, null, filteredData);
        }
        return Arrays.asList(filteredData);
    }

    public abstract AbstractImExModuleData getExportableItem(IModuleData var1, Locale var2, Collection<AbstractFilter> var3);

    protected final IModuleData getModuleDataItemForImExItem(AbstractImExModuleData imExItem) {
        return imExItem.getModuleData();
    }
}

