/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.datamanager.AbstractDataManager_StringIDs;
import com.arcway.cockpit.client.base.datamanager.DataAccessAgent;
import com.arcway.cockpit.client.base.datamanager.IDataHandler_DataWithID;
import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IModuleStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.CommitVersionedItemsHelper;
import com.arcway.cockpit.frame.client.project.core.history.HistoryDataManager;
import com.arcway.cockpit.frame.client.project.core.history.IHistoricDataItemConverter;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAtributeDataManagementFacade;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.IFrameLinkTypeHelper;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.DataHandler_ModuleData;
import com.arcway.cockpit.modulelib2.client.core.project.IDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.INewIDReceiver;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.VersionLinkModificationListener;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.CustomModuleAttribute;
import com.arcway.cockpit.modulelib2.client.messages.HistoryRecordRelevantLinkTypes;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.java.collectionmaps.ISetMapWithFixReturnSetsRO;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import de.plans.lib.util.Alphabet;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractDataMgr
extends AbstractDataManager_StringIDs<IModuleData, EOModuleData>
implements IModel,
IDataMgr,
DataAccessAgent.IModificationDiscardCallback<IModuleData, String> {
    private boolean importRunning = false;
    private static final ILogger logger = Logger.getLogger(AbstractDataMgr.class);
    private static final int ID_MAX_LONG_DIGITS = Long.toString(Long.MAX_VALUE).length();
    private HistoryDataManager<IModuleData> historyDataManager;
    private IFrameProjectAgent projectAgent;
    private IModelController modelController;
    private AbstractPermissionMgr permissionMgr;
    private AbstractLockManager lockMgr;
    private ProjectionMgr projectionMgr;
    private LinkMgr linkMgr;
    private ModuleFacade moduleFacade;
    private IClientDataFactory clientDataFactory;
    private final HashMap<String, ISetMapWithFixReturnSetsRO<String, EOLink>> linkMappingsBeforeAsynchronousUpdate = new HashMap();
    private final SetMap<String, String> map_typeID_temporarilyReservedIDs = new SetMap();

    public void construct(String projectUid_, IFrameProjectAgent projectAgent_, IModelController modelControllerP, AbstractPermissionMgr permissionMgrP, AbstractLockManager lockMgrP, ProjectionMgr projectionMgrP, LinkMgr linkMgrP, PropertyChangesManager propertyChangesManager_, ModuleFacade moduleFacade_, final IClientDataFactory clientDataFactoryP, AbstractEncodableObjectFactory p_eoFactory) {
        assert (permissionMgrP != null);
        assert (lockMgrP != null);
        assert (linkMgrP != null);
        assert (propertyChangesManager_ != null);
        assert (projectUid_ != null);
        assert (projectAgent_ != null) : "project must not be null";
        assert (clientDataFactoryP != null);
        this.projectAgent = projectAgent_;
        this.permissionMgr = permissionMgrP;
        this.lockMgr = lockMgrP;
        this.projectionMgr = projectionMgrP;
        this.linkMgr = linkMgrP;
        this.modelController = modelControllerP;
        this.moduleFacade = moduleFacade_;
        this.clientDataFactory = clientDataFactoryP;
        super.init(projectUid_, (IProjectAgent)projectAgent_, propertyChangesManager_);
        super.construct(p_eoFactory);
        this.historyDataManager = new HistoryDataManager(projectAgent_, (IHistoricDataItemConverter)new IHistoricDataItemConverter<IModuleData>(){

            public IModuleData convertFromEO(EOCockpitProjectData historicItemEO) {
                return clientDataFactoryP.convertFromEO((EOModuleData)historicItemEO);
            }
        }, (IFrameLinkTypeHelper)this.getLinkTypesHelper(), "modulelib.standardmoduledata", this.getDataTypes());
        if (projectionMgrP != null) {
            projectAgent_.getPropertyChangesListenerManager().register((IPropertyChangesListener)this.projectionMgr, EOLink.class);
        }
        this.registerLinkModificationListeners();
    }

    protected IDataHandler_DataWithID<IModuleData, String, String, String, EOModuleData> createDataHandler() {
        return new DataHandler_ModuleData(this.getProjectUID(), this.clientDataFactory);
    }

    protected DataAccessAgent.IModificationDiscardCallback<IModuleData, String> createModificationCallback() {
        return this;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public ModuleFacade getModuleFacade() {
        return this.moduleFacade;
    }

    private void registerLinkModificationListeners() {
        for (final String dataTypeID : this.getDataTypesHelper().getDocumentationDataTypes()) {
            HistoryRecordRelevantLinkTypes linkTyes = this.getLinkTypesHelper().getLinkTypesForHistoryRecord(dataTypeID);
            for (String linkType : linkTyes.getModuleDataAttributeLinkTypes()) {
                this.linkMgr.addModificationListenerForLinkType(linkType, new VersionLinkModificationListener(this){

                    @Override
                    protected IModuleData extractItem(EOLink link) {
                        String itemID = link.getModuleDataUID();
                        return (IModuleData)AbstractDataMgr.this.getItem(dataTypeID, itemID);
                    }
                });
            }
            for (String linkType : linkTyes.getFrameDataAttributeLinkTypes()) {
                this.linkMgr.addModificationListenerForLinkType(linkType, new VersionLinkModificationListener(this){

                    @Override
                    protected IModuleData extractItem(EOLink link) {
                        String itemID = link.getModuleDataUID();
                        return (IModuleData)AbstractDataMgr.this.getItem(dataTypeID, itemID);
                    }
                });
            }
            for (String linkType : linkTyes.getChildrenLinkTypes()) {
                this.linkMgr.addModificationListenerForLinkType(linkType, new VersionLinkModificationListener(this){

                    @Override
                    protected IModuleData extractItem(EOLink link) {
                        String itemID = link.getLinkableObjectUID();
                        return (IModuleData)AbstractDataMgr.this.getItem(dataTypeID, itemID);
                    }
                });
            }
        }
    }

    @Override
    public void undoItemCreation(Collection<? extends IModuleData> createdItems, Collection<EOLink> createdLinks) {
        for (EOLink link : createdLinks) {
            this.getLinkMgr().deleteLink(link);
        }
        this.removeItems(createdItems);
    }

    @Override
    public List<? extends IModuleData> getVersionsOfItem(IModuleData item) {
        assert (item != null);
        ArrayList<IModuleData> versions = new ArrayList<IModuleData>();
        int modCount = item.getModificationCount();
        int i = 1;
        while (i <= modCount) {
            IModuleData version = this.getVersionedItem(item.getTypeID(), item.getUID(), i);
            if (version != null) {
                versions.add(version);
            } else {
                logger.warn("Could not retrieve version " + i + " of " + item.getTypeID() + " " + item.getDisplayRepresentation());
            }
            ++i;
        }
        return versions;
    }

    @Override
    public IModuleData getParent(IModuleData item) {
        assert (item != null);
        return null;
    }

    @Override
    public Collection<IModuleData> getChildren(IModuleData item) {
        if (item == null) {
            return this.getAllRootItems();
        }
        return new ArrayList<IModuleData>();
    }

    @Override
    public Collection<IModuleData> getChildren(IModuleData item, String typeID) {
        ArrayList<IModuleData> children = new ArrayList<IModuleData>(this.getChildren(item));
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IModuleData child = (IModuleData)i.next();
            if (child.getTypeID().equals(typeID)) continue;
            i.remove();
        }
        return children;
    }

    public Collection<IModuleData> getAllAscendants(IModuleData item) {
        IModuleData parent = this.getParent(item);
        if (parent == null) {
            return new ArrayList<IModuleData>();
        }
        return this.internalGetAllAscendants(parent);
    }

    private Collection<IModuleData> internalGetAllAscendants(IModuleData item) {
        IModuleData parent = this.getParent(item);
        Collection<Object> ascendants = parent == null ? new ArrayList() : this.internalGetAllAscendants(parent);
        ascendants.add(item);
        return ascendants;
    }

    public Collection<IModuleData> getAllDescendants(IModuleData item) {
        Collection<IModuleData> children = this.getChildren(item);
        ArrayList<IModuleData> subChildren = new ArrayList<IModuleData>();
        for (IModuleData child : children) {
            subChildren.addAll(this.getAllDescendants(child));
        }
        children.addAll(subChildren);
        return children;
    }

    @Override
    public Section getSection(IModuleData rootItem) {
        Collection sectionCollection = CollectionUtils.getTypedCollection((Collection)this.linkMgr.getLinkableObjects(rootItem, this.getLinkTypesHelper().getSectionLinkTypeID(rootItem.getTypeID())), Section.class);
        if (!sectionCollection.isEmpty()) {
            return (Section)sectionCollection.iterator().next();
        }
        return null;
    }

    @Override
    public void setSection(IModuleData rootItem, Section newSection) {
        Section currentSection = this.getSection(rootItem);
        if (currentSection != null) {
            this.linkMgr.deleteLink(currentSection.getUID(), rootItem.getUID(), this.getLinkTypesHelper().getSectionLinkTypeID(rootItem.getTypeID()));
        }
        this.linkMgr.createLink(newSection.getUID(), rootItem.getUID(), this.getLinkTypesHelper().getSectionLinkTypeID(rootItem.getTypeID()));
    }

    public IModelController getModelController() {
        return this.modelController;
    }

    @Override
    public AbstractLockManager getLockMgr() {
        return this.lockMgr;
    }

    @Override
    public AbstractPermissionMgr getPermissionMgr() {
        return this.permissionMgr;
    }

    protected abstract ILinkTypeHelper getLinkTypesHelper();

    @Override
    public Collection<? extends IModuleData> getModuleData(String linkableObjectUID, String linkTypeID, String planUID) {
        return this.linkMgr.getModuleData(linkableObjectUID, linkTypeID, planUID);
    }

    @Override
    public Collection<? extends IModuleData> getModuleData(String linkableObjectUID, String linkTypeID) {
        return this.linkMgr.getModuleData(linkableObjectUID, linkTypeID);
    }

    @Override
    public Collection<? extends IModuleData> getModuleData(String linkableObjectUID, int modCount, String linkTypeID) {
        return this.linkMgr.getModuleData(linkableObjectUID, modCount, linkTypeID);
    }

    @Override
    public Collection<? extends ICockpitProjectData> getLinkableObjects(IModuleData moduleData, String linkTypeID) {
        return this.linkMgr.getLinkableObjects(moduleData, linkTypeID);
    }

    public LinkMgr getLinkMgr() {
        return this.linkMgr;
    }

    public void callbackAsynchronousUpdateStarted() {
    }

    public void callbackAsynchronousUpdateCompleted() {
    }

    protected void mergeAttributeItemsOnAsynchronousUpdate(Collection<IModuleData> asynchronouslyAddedItems, String dataTypeUID, Collection<String> linkTypeIDs) {
        Collection locallyAddedAttributeItems = this.getLocallyAddedItems(dataTypeUID);
        for (IModuleData locallyAddedAttributeItem : locallyAddedAttributeItems) {
            IModuleData sameAttributeItem = AbstractDataMgr.containsAttributeItemWithSameName(asynchronouslyAddedItems, locallyAddedAttributeItem);
            if (sameAttributeItem == null) continue;
            for (String linkTypeID : linkTypeIDs) {
                for (EOLink oldLink : this.getLinkMgr().getLinksForLinkableObject(locallyAddedAttributeItem.getUID(), linkTypeID)) {
                    this.getLinkMgr().deleteLink(oldLink.getLinkableObjectUID(), oldLink.getModuleDataUID(), linkTypeID);
                    this.getLinkMgr().createLink(sameAttributeItem.getUID(), oldLink.getModuleDataUID(), linkTypeID);
                }
            }
            this.internallyRemoveItem(locallyAddedAttributeItem);
        }
    }

    private static IModuleData containsAttributeItemWithSameName(Collection<IModuleData> attributeItemsToCompare, IModuleData attributeItem) {
        for (IModuleData attributeItemToCompare : attributeItemsToCompare) {
            if (!attributeItem.isIsomorphic(attributeItemToCompare) || attributeItem.getUID().equals(attributeItemToCompare.getUID())) continue;
            return attributeItemToCompare;
        }
        return null;
    }

    protected void rememberLinksOfType(Collection<String> linkTypeIds) {
        this.linkMappingsBeforeAsynchronousUpdate.clear();
        for (String linkTypeID : linkTypeIds) {
            ISetMapWithFixReturnSetsRO<String, EOLink> linkMappings = this.getLinkMgr().getLinksForLinkType(linkTypeID);
            this.linkMappingsBeforeAsynchronousUpdate.put(linkTypeID, linkMappings);
        }
    }

    protected final void restoreAttributeItemsOnAsynchronousUpdate(Collection<IModuleData> asynchronouslyRemovedItems, Collection<String> linkTypeIDs) {
        for (IModuleData removedAttributeItem : asynchronouslyRemovedItems) {
            IModuleData restoredAttributeItem = null;
            for (String linkTypeID : linkTypeIDs) {
                String attributeOwnerDataTypeID = this.getLinkTypesHelper().getLinkSourceDataTypeIDForLinkType(linkTypeID);
                Set links = this.linkMappingsBeforeAsynchronousUpdate.get(linkTypeID).get((Object)removedAttributeItem.getUID());
                for (EOLink link : links) {
                    String linkedModuleDataUID = link.getModuleDataUID();
                    if (!this.isNew(linkedModuleDataUID, attributeOwnerDataTypeID)) continue;
                    if (restoredAttributeItem == null) {
                        restoredAttributeItem = this.restoreCopyOfRemovedItem(removedAttributeItem);
                    }
                    this.getLinkMgr().createLink(restoredAttributeItem.getUID(), linkedModuleDataUID, linkTypeID);
                }
            }
        }
    }

    private IModuleData restoreCopyOfRemovedItem(IModuleData removedItem) {
        final IModuleData newItem = removedItem.copy(false);
        this.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                AbstractDataMgr.this.addItem(newItem);
            }
        });
        return newItem;
    }

    @Override
    public IModuleData getVersionedItem(String dataTypeID, String UID, int modCount) {
        return (IModuleData)this.historyDataManager.getHistoricItem(UID, dataTypeID, modCount);
    }

    @Override
    public Collection<? extends IModuleData> getModuleData(IModuleData linkableObject, String linkTypeID) {
        return this.linkMgr.getModuleData(linkableObject, linkTypeID);
    }

    public Collection<IModuleData> getAllModuleData(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.linkMgr.getAllModuleData(linkTypeID);
    }

    @Override
    public void newProjectCreated() {
    }

    @Override
    public final void projectInitialized() {
        this.permissionMgr.initialise();
        this.projectInitialized_callbackForSubClasses();
    }

    public void projectInitialized_callbackForSubClasses() {
    }

    @Override
    public void clearPermissions(Collection<? extends IPermissionOperand> permissionOperands) {
        this.permissionMgr.clearPermissions(permissionOperands);
    }

    @Override
    public void clearPermissions(IPermissionOperand permissionOperand) {
        this.permissionMgr.clearPermissions(permissionOperand);
    }

    @Override
    public IModuleStakeholderManager getStakeholderManager() {
        return this.getProjectAgent().getModuleStakeholderManager();
    }

    @Override
    public Locale getProjectLanguage() {
        return new Locale(this.projectAgent.getLanguage());
    }

    @Override
    public void projectClosed() {
        if (this.projectionMgr != null) {
            this.projectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this.projectionMgr);
        }
        this.permissionMgr.projectClosed();
    }

    @Override
    public boolean assertIDIsSet(IModuleData item) {
        String idAttributeRoleID = item.getTypeDescription().getIDAttribute();
        if (idAttributeRoleID == null) {
            return true;
        }
        String id = item.getAttribute(idAttributeRoleID).getUniqueStringRepresentation();
        return id != null && id.length() > 0;
    }

    @Override
    public boolean hasExistingID(IModuleData item) {
        String idAttributeRoleID = item.getTypeDescription().getIDAttribute();
        if (idAttributeRoleID == null) {
            return false;
        }
        IModuleData itemWithSameID = (IModuleData)this.getItemByID(item.getTypeID(), item.getAttribute(idAttributeRoleID).getUniqueStringRepresentation());
        return itemWithSameID != null && !itemWithSameID.equals(item);
    }

    @Override
    public boolean hasExistingName(IModuleData item, IModuleData parent) {
        String nameAttributeRoleID = item.getTypeDescription().getNameAttribute();
        if (nameAttributeRoleID == null) {
            return false;
        }
        Collection<IModuleData> itemsToCompare = this.getChildren(parent, item.getTypeID());
        itemsToCompare.remove(item);
        return AbstractDataMgr.existsItemWithEqualAttributeValue(item, itemsToCompare, nameAttributeRoleID);
    }

    private static boolean existsItemWithEqualAttributeValue(IModuleData item, Collection<IModuleData> itemsToCompare, String attributeRoleID) {
        String itemAttributeValue = item.getAttribute(attributeRoleID).getDisplayStringRepresentation();
        for (IModuleData itemToCompare : itemsToCompare) {
            String itemToCompareAttributeValue = itemToCompare.getAttribute(attributeRoleID).getDisplayStringRepresentation();
            if (!itemToCompareAttributeValue.equals(itemAttributeValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String generateNewName(IModuleData item, IModuleData parent, boolean acquireLock, LockAccessWrapper lockAccessWrapper) {
        String extendedName;
        block13: {
            LockAccess lock;
            String nameAttributeRoleID = item.getTypeDescription().getNameAttribute();
            assert (nameAttributeRoleID != null);
            String wishedName = item.getAttribute(nameAttributeRoleID).getDisplayStringRepresentation();
            boolean nameExists = false;
            long maxNameExtensionNumber = 0L;
            Collection<IModuleData> itemCollection = this.getChildren(parent, item.getTypeID());
            for (IModuleData existingItem : itemCollection) {
                String tail;
                String existingItemName = existingItem.getAttribute(nameAttributeRoleID).getDisplayStringRepresentation();
                if (existingItemName.equals(wishedName)) {
                    nameExists = true;
                    continue;
                }
                if (!existingItemName.startsWith(wishedName) || !(tail = existingItemName.substring(wishedName.length())).startsWith(" (") || !tail.endsWith(")")) continue;
                tail = tail.substring(2, tail.length() - 1);
                try {
                    long nameExtensionNumber = Long.parseLong(tail);
                    if (nameExtensionNumber <= maxNameExtensionNumber) continue;
                    maxNameExtensionNumber = nameExtensionNumber;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!nameExists) {
                if (acquireLock) {
                    LockAccess lock2 = this.lockMgr.acquireUniqueNameLock(wishedName, item.getTypeID(), parent != null ? parent.getUID() : null);
                    if (lock2.hasLock()) {
                        if (lockAccessWrapper != null) {
                            lockAccessWrapper.setLockAccess(lock2);
                        }
                        return wishedName;
                    }
                    if (lock2.isExclusiveProjectLockConflicting()) {
                        return null;
                    }
                } else {
                    return wishedName;
                }
            }
            long nameExtensionNumber = maxNameExtensionNumber + 1L;
            do {
                extendedName = String.valueOf(wishedName) + " (" + nameExtensionNumber + ")";
                if (!acquireLock) break block13;
                lock = this.lockMgr.acquireUniqueNameLock(extendedName, item.getTypeID(), parent != null ? parent.getUID() : null);
                if (!lock.hasLock()) continue;
                if (lockAccessWrapper != null) {
                    lockAccessWrapper.setLockAccess(lock);
                }
                return extendedName;
            } while (!lock.isExclusiveProjectLockConflicting());
            return null;
        }
        return extendedName;
    }

    @Override
    public String generateNewID(IModuleDataTypeDescription itemTypeDescription, int idType, IModuleData parent, boolean acquireLock, final LockAccessWrapper lockAccessWrapper) throws EXCockpitLockDenied {
        final String[] newID = new String[1];
        SetMap map_parent_idReceiver = new SetMap();
        map_parent_idReceiver.add((Object)parent, (Object)new INewIDReceiver(){

            @Override
            public void setNewID(String newID_) {
                newID[0] = newID_;
            }

            @Override
            public void setLock(LockAccess lock) {
                if (lockAccessWrapper != null) {
                    lockAccessWrapper.setLockAccess(lock);
                }
            }
        });
        this.generateNewIDs((CollectionMap<IModuleData, INewIDReceiver>)map_parent_idReceiver, itemTypeDescription, idType, acquireLock, lockAccessWrapper != null);
        return newID[0];
    }

    @Override
    public String generateNewID(int idType, String prefix, String separator, Object incrementParameter, Collection<IModuleData> existingItems, String idAttributeRoleID, boolean acquireLock, String idTypeForLocking, final LockAccessWrapper lockAccessWrapper) throws EXCockpitLockDenied {
        final String[] newID = new String[1];
        this.generateNewIDs(Collections.singleton(new INewIDReceiver(){

            @Override
            public void setNewID(String newID_) {
                newID[0] = newID_;
            }

            @Override
            public void setLock(LockAccess lock) {
                if (lockAccessWrapper != null) {
                    lockAccessWrapper.setLockAccess(lock);
                }
            }
        }), idType, prefix, separator, incrementParameter, existingItems, idAttributeRoleID, acquireLock, idTypeForLocking, lockAccessWrapper != null);
        return newID[0];
    }

    @Override
    public void generateNewIDs(CollectionMap<IModuleData, INewIDReceiver> map_parent_idReceivers, IModuleDataTypeDescription itemTypeDescription, int idType, boolean acquireLock, boolean reserveIDTemporarily) throws EXCockpitLockDenied {
        for (IModuleData parent : map_parent_idReceivers.keySet()) {
            Collection existingItems = this.getAllItems(itemTypeDescription.getTypeID());
            String idAttributeRoleID = itemTypeDescription.getIDAttribute();
            assert (idAttributeRoleID != null);
            String prefix = this.getIDPrefix(parent, itemTypeDescription);
            String prefixSeparator = this.getPrefixSeparator(parent, itemTypeDescription);
            String incrementParameter = null;
            if (idType == 0) {
                incrementParameter = this.getPattern(parent, itemTypeDescription);
            }
            this.generateNewIDs(map_parent_idReceivers.get((Object)parent), idType, prefix, prefixSeparator, incrementParameter, existingItems, idAttributeRoleID, acquireLock, itemTypeDescription.getTypeID(), reserveIDTemporarily);
        }
    }

    private void generateNewIDs(Collection<INewIDReceiver> idReceivers, int idType, String prefix, String separator, Object incrementParameter, Collection<IModuleData> existingItems, String idAttributeRoleID, boolean acquireLock, final String idTypeForLocking, boolean reserveIDTemporarily) throws EXCockpitLockDenied {
        String max = null;
        for (String temorarilyReservedID : this.map_typeID_temporarilyReservedIDs.get((Object)idTypeForLocking)) {
            max = AbstractDataMgr.getMaxID(max, temorarilyReservedID, idType, prefix, separator);
        }
        for (IModuleData existingItem : existingItems) {
            String id = existingItem.getAttribute(idAttributeRoleID).getDisplayStringRepresentation();
            max = AbstractDataMgr.getMaxID(max, id, idType, prefix, separator);
        }
        String newIDTail = max;
        String newID = null;
        LockAccess lock = null;
        for (INewIDReceiver idReceiver : idReceivers) {
            boolean lockIsOk = false;
            while (!lockIsOk) {
                newIDTail = AbstractDataMgr.doIncrementID(newIDTail, idType, incrementParameter);
                newID = String.valueOf(prefix) + separator + newIDTail;
                if (acquireLock) {
                    lock = this.lockMgr.acquireUniqueIDLock(newID, idTypeForLocking);
                    lockIsOk = lock.hasLock();
                    if (lockIsOk || !lock.isExclusiveProjectLockConflicting()) continue;
                    Collection<EOLock> conflictingLocks = lock.getConflictingLocks();
                    throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
                }
                lockIsOk = true;
            }
            idReceiver.setNewID(newID);
            if (acquireLock && reserveIDTemporarily) {
                this.map_typeID_temporarilyReservedIDs.add((Object)idTypeForLocking, newID);
                final String finalCopyOfNewID = newID;
                lock.addOperationOnRelease(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDataMgr.this.map_typeID_temporarilyReservedIDs.remove((Object)idTypeForLocking, (Object)finalCopyOfNewID);
                    }
                });
            }
            idReceiver.setLock(lock);
        }
    }

    private static String getMaxID(String oldMaxID, String additionalID, int idType, String prefix, String separator) {
        String newMaxID;
        if (AbstractDataMgr.isIdOfPattern(additionalID, idType, prefix, separator)) {
            String tail = additionalID.substring(prefix.length() + separator.length());
            newMaxID = oldMaxID == null ? tail : (AbstractDataMgr.isGreaterID(tail, oldMaxID, idType) ? tail : oldMaxID);
        } else {
            newMaxID = oldMaxID;
        }
        return newMaxID;
    }

    private static boolean isIdOfPattern(String id, int idType, String prefix, String separator) {
        switch (idType) {
            case 0: {
                if (!id.startsWith(prefix)) {
                    return false;
                }
                if (!id.startsWith(separator, prefix.length())) {
                    return false;
                }
                String coreID = id.substring(prefix.length() + separator.length());
                int coreIDLength = coreID.length();
                int i = 0;
                while (i < coreIDLength) {
                    if (!Character.isDigit(coreID.charAt(i))) {
                        return false;
                    }
                    ++i;
                }
                if (coreIDLength < ID_MAX_LONG_DIGITS) {
                    return true;
                }
                if (coreIDLength == ID_MAX_LONG_DIGITS) {
                    try {
                        Long.parseLong(coreID);
                        return true;
                    }
                    catch (NumberFormatException nFE) {
                        return false;
                    }
                }
                return false;
            }
            case 1: {
                if (!id.startsWith(String.valueOf(prefix) + separator)) {
                    return false;
                }
                String coreID = id.substring(prefix.length() + separator.length());
                int c = 0;
                while (c < coreID.length()) {
                    if (!Alphabet.isValidCharacter((char)coreID.charAt(c))) {
                        return false;
                    }
                    ++c;
                }
                return true;
            }
        }
        assert (false) : "unknown id type: " + idType;
        return false;
    }

    private static boolean isGreaterID(String newID, String oldID, int idType) {
        switch (idType) {
            case 0: {
                long oldIDNumber;
                long newIDNumber;
                try {
                    newIDNumber = Long.parseLong(newID);
                    oldIDNumber = Long.parseLong(oldID);
                }
                catch (NumberFormatException nfE) {
                    return false;
                }
                return newIDNumber > oldIDNumber;
            }
            case 1: {
                int c = 0;
                while (c < newID.length()) {
                    if (!Alphabet.isValidCharacter((char)newID.charAt(c))) {
                        return false;
                    }
                    ++c;
                }
                c = 0;
                while (c < oldID.length()) {
                    if (!Alphabet.isValidCharacter((char)oldID.charAt(c))) {
                        return false;
                    }
                    ++c;
                }
                if (newID.length() != oldID.length()) {
                    return newID.length() > oldID.length();
                }
                int charIndex = 0;
                while (charIndex < newID.length()) {
                    char charOfOldID;
                    char charOfNewID = newID.charAt(newID.length() - (charIndex + 1));
                    if (charOfNewID != (charOfOldID = oldID.charAt(oldID.length() - (charIndex + 1)))) {
                        return Alphabet.compare((char)charOfNewID, (char)charOfOldID) > 0;
                    }
                    ++charIndex;
                }
                return false;
            }
        }
        assert (false) : "unknown id type: " + idType;
        return false;
    }

    private static String doIncrementID(String oldID, int idType, Object parameter) {
        switch (idType) {
            case 0: {
                long idNumber = oldID != null ? Long.parseLong(oldID) : 0L;
                String pattern = (String)parameter;
                DecimalFormat formater = new DecimalFormat(pattern);
                String newID = formater.format(++idNumber);
                return newID;
            }
            case 1: {
                if (oldID == null || oldID.length() == 0) {
                    return Character.toString(Alphabet.getCharacter((int)0));
                }
                String newID = oldID;
                int charIndex = 0;
                char nextChar = Alphabet.getCharacter((int)0);
                while (nextChar == Alphabet.getCharacter((int)0) && charIndex < newID.length()) {
                    char charAtIndex = newID.charAt(newID.length() - (charIndex + 1));
                    nextChar = Alphabet.getNextCharacter((char)charAtIndex);
                    if (nextChar == Alphabet.getCharacter((int)0)) {
                        newID = String.valueOf(newID.substring(0, newID.length() - (charIndex + 1))) + Alphabet.getCharacter((int)0) + newID.substring(newID.length() - charIndex);
                        ++charIndex;
                        continue;
                    }
                    newID = String.valueOf(newID.substring(0, newID.length() - (charIndex + 1))) + nextChar + newID.substring(newID.length() - charIndex);
                }
                if (nextChar == Alphabet.getCharacter((int)0)) {
                    newID = String.valueOf(Alphabet.getCharacter((int)0)) + newID;
                }
                return newID;
            }
        }
        return null;
    }

    protected String getIDPrefix(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        return null;
    }

    protected String getPrefixSeparator(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        return "";
    }

    protected String getPattern(IModuleData parent, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        return "";
    }

    @Override
    public boolean isNew(ICockpitProjectData item) {
        assert (item != null) : "item must not be null";
        return this.isNew(item.getUID(), item.getTypeID());
    }

    @Override
    public boolean isModified(ICockpitProjectData item) {
        assert (item != null) : "item must not be null";
        return this.isModified(item.getUID(), item.getTypeID());
    }

    @Override
    public boolean isDeleted(ICockpitProjectData item) {
        assert (item != null) : "item must not be null";
        return this.isDeleted(item.getUID(), item.getTypeID());
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, IModuleData_CustomPropertiesExtension moduleData, IAttributeType attributeType) {
        CustomModuleAttribute moduleAttribute = (CustomModuleAttribute)moduleData.getCustomAttribute(attributeType);
        if (moduleAttribute != null) {
            moduleAttribute.setAttributeValue(newAttribute.getAttributeValue());
        }
        if (moduleAttribute == null) {
            moduleAttribute = new CustomModuleAttribute(newAttribute);
            moduleData.setCustomAttribute(attributeType, moduleAttribute);
        }
        if (this.itemExists(moduleData.getUID(), moduleData.getTypeID())) {
            final IModuleData_CustomPropertiesExtension moduleDataFinal = moduleData;
            this.getModelTransactionManager().executeTransaction(new Runnable(){

                @Override
                public void run() {
                    AbstractDataMgr.this.itemPropertiesModified(moduleDataFinal.getModuleData());
                }
            });
        }
    }

    @Override
    public void startImport() {
        this.importRunning = true;
    }

    @Override
    public void stopImport() {
        this.importRunning = false;
    }

    @Override
    public boolean isImportRunning() {
        return this.importRunning;
    }

    @Override
    public void synchronousUpdateHook_pre() {
    }

    public void addedItemsToBeCleared(Collection<IModuleData> addedItems) {
        ArrayList<IPermissionOperand> permissionOperandsToDelete = new ArrayList<IPermissionOperand>(addedItems.size());
        for (IModuleData addedItem : addedItems) {
            if (!(addedItem instanceof IPermissionOperand)) continue;
            permissionOperandsToDelete.add((IPermissionOperand)addedItem);
        }
        if (!permissionOperandsToDelete.isEmpty()) {
            this.clearPermissions(permissionOperandsToDelete);
        }
    }

    public void updatedItemsToBeCleared(Collection<IModuleData> updatedItems) {
    }

    public void removedItemsToBeCleared(Collection<IModuleData> removedItems) {
    }

    public void addedItemsThatHaveBeenCommitted(Collection<IModuleData> addedItems) {
    }

    public void updatedItemsThatHaveBeenCommitted(Collection<IModuleData> updatedItems) {
    }

    public void removedItemsThatHaveBeenCommitted(Collection<IModuleData> removedItems) {
        if (removedItems.size() > 0 && removedItems.iterator().next() instanceof IPermissionOperand) {
            this.clearPermissions(removedItems);
        }
    }

    protected String getModuleID() {
        return this.getModelController().getModuleID();
    }

    public Collection<String> getDataTypes() {
        return this.getDataTypesHelper().getAllTrueDataTypes();
    }

    protected IHasher_<? super String> getIDHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    protected IHasher_<? super String> getDataTypeIDHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    protected String getDataTypeIDAsString(String dataTypeID) {
        return dataTypeID;
    }

    protected String getDataTypeIDFromString(String dataTypeIDAsString) {
        return dataTypeIDAsString;
    }

    protected String getRequestGroupID() {
        return "modulelib.standardmoduledata";
    }

    protected void removeNonDisplayableModifications(Collection items) {
    }

    protected void callbackItemPropertiesModified(IModuleData item, boolean guiUpdateRequired) {
        this.handleItemPropertiesModified(item, guiUpdateRequired, new ArrayList<IModuleData>());
    }

    private void handleItemPropertiesModified(IModuleData item, boolean guiUpdateRequired, List<IModuleData> visitedElements) {
        HashSet<? extends IModuleData> linkedData = new HashSet<IModuleData>();
        for (String string : this.getDataTypesHelper().getDocumentationDataTypes()) {
            HistoryRecordRelevantLinkTypes linkTyes = this.getLinkTypesHelper().getLinkTypesForHistoryRecord(string);
            for (String linkTypeID : linkTyes.getModuleDataAttributeLinkTypes()) {
                if (!item.getTypeID().equals(this.getLinkTypesHelper().getLinkTargetDataTypeIDForLinkType(linkTypeID))) continue;
                linkedData.addAll(this.linkMgr.getModuleData(item, linkTypeID));
            }
            for (String linkTypeID : linkTyes.getChildrenLinkTypes()) {
                if (!item.getTypeID().equals(this.getLinkTypesHelper().getLinkSourceDataTypeIDForLinkType(linkTypeID))) continue;
                linkedData.addAll(this.linkMgr.getLinkableObjects(item, linkTypeID));
            }
        }
        for (IModuleData iModuleData : linkedData) {
            if (visitedElements != null && visitedElements.contains(iModuleData)) continue;
            this.itemPropertiesModified(iModuleData, guiUpdateRequired, visitedElements);
        }
    }

    protected void callbackItemRemoved(IModuleData removedItem) {
        IAttributeOwner attributeOwner = this.getModuleFacade().getAttributeOwner((ICockpitProjectData)removedItem);
        UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted((IAttributeOwner)attributeOwner);
        IModuleDataTypeDescriptionForFrame naturalOrderDataType = removedItem.getTypeDescription().getDataTypeForNaturalOrdering();
        if (naturalOrderDataType != null) {
            String naturalOrderDataTypeID = naturalOrderDataType.getCockpitDataTypeID();
            if (!removedItem.getTypeID().equals(naturalOrderDataTypeID)) {
                this.projectAgent.getSequencerManager().objectDeleted((ICockpitProjectData)removedItem, naturalOrderDataTypeID);
            }
        }
        this.linkMgr.linkedItemDeleted(removedItem);
    }

    protected void callbackPrepareAddedAndUpdatedItemsForCommit(String dataTypeID, List<EOModuleData> addedItems, List<EOModuleData> updatedItems) {
        IFrameLinkManager framelinkManager = this.getProjectAgent().getLinkManager();
        HistoryRecordRelevantLinkTypes linkTypes = this.linkMgr.getLinkTypeHelper().getLinkTypesForHistoryRecord(dataTypeID);
        ArrayList<String> outLinkTypeIDs = new ArrayList<String>();
        outLinkTypeIDs.addAll(linkTypes.getModuleDataAttributeLinkTypes());
        outLinkTypeIDs.addAll(linkTypes.getFrameDataAttributeLinkTypes());
        ArrayList<String> inLinkTypeIDs = new ArrayList<String>();
        inLinkTypeIDs.addAll(linkTypes.getModuleDataAttributeLinkTypes());
        CommitVersionedItemsHelper.addLinkLogsToCommittableItems(addedItems, inLinkTypeIDs, outLinkTypeIDs, (IFrameLinkManager)framelinkManager);
        CommitVersionedItemsHelper.addLinkLogsToCommittableItems(updatedItems, inLinkTypeIDs, outLinkTypeIDs, (IFrameLinkManager)framelinkManager);
    }

    public void callbackCommitCompleted() {
    }
}

