/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.crossmodulelinks;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.Cardinality11;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.Cardinality1N;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityN1;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityNN;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.LinkType;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinksLinkedDataAccessFacade;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ICrossModuleLinkType;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.ModuleIDAndDataManager;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.PlatformAdapterModuleProviderCrossModuleLinks;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.lib.eclipse.extensions.ExtensionMgr;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CrossModuleLinkManager {
    private static final ILogger logger = Logger.getLogger(CrossModuleLinkManager.class);
    public static final Collection<String> ALLOW_ALL_MODULEDATA_TYPES = new ArrayList<String>(0);
    public static final String LINKTYPEID_GENERALCROSSMODULEDATALINK = "modulelib2-crossmoduledatalinks-general";
    public static final String CARDINALITY_NONEORONE = "none-or-one";
    public static final String CARDINALITY_UNLIMITED = "unlimited";
    private static final String EXTENSION_POINT_ID = "crossmodulelinktype";
    private static final String ELEMENT_TYPE_ID = "CrossModuleLinkType";
    private static final String ATTRIBUTE_ID = "linkTypeDescription";
    private static final String DECLARATIONMODULEID_CROSSMODULELINKS = "com.arcway.cockpit.modulelib2.crossmoduledatalinks";
    private static final String MODULEDATACONTRIBUTION_POSTFIX = "--moduledatacontribution";
    private static final String LINKABLEOBJECTCONTRIBUTION_POSTFIX = "--linkableobjectcontribution";
    private static final Map<String, CrossModuleLinkManager> map_projectUID_instance = new HashMap<String, CrossModuleLinkManager>();
    private final String projectUID;
    private IModuleLinkManager linkManager;
    private final Map<String, ICrossModuleLinkType> map_linkTypeID_linkType;
    private final Map<String, ILinkTypeLinkAccessFacade> map_linkTypeID_linkAccessFacade;
    private final Map<String, CrossModuleLinksLinkedDataAccessFacade> map_contributionVirtualDataTypeID_linkedDataAccessFacade;
    private final Map<String, ModuleIDAndDataManager> map_cockpitTypeID_moduleIDAndDataManager;
    private final Map<String, ILicenseTypeProvider> map_moduleID_licenseTypeProvider;
    private boolean initialisationPending;

    public static CrossModuleLinkManager getInstance(String projectUID) {
        CrossModuleLinkManager instance = map_projectUID_instance.get(projectUID);
        if (instance == null) {
            instance = new CrossModuleLinkManager(projectUID);
            map_projectUID_instance.put(projectUID, instance);
        }
        return instance;
    }

    public static void clearInstance(String projectUID) {
        map_projectUID_instance.remove(projectUID);
    }

    private CrossModuleLinkManager(String projectUID) {
        this.projectUID = projectUID;
        this.map_linkTypeID_linkType = new HashMap<String, ICrossModuleLinkType>();
        this.map_linkTypeID_linkAccessFacade = new HashMap<String, ILinkTypeLinkAccessFacade>();
        this.map_contributionVirtualDataTypeID_linkedDataAccessFacade = new HashMap<String, CrossModuleLinksLinkedDataAccessFacade>();
        this.map_cockpitTypeID_moduleIDAndDataManager = new HashMap<String, ModuleIDAndDataManager>();
        this.map_moduleID_licenseTypeProvider = new HashMap<String, ILicenseTypeProvider>();
        this.initialisationPending = true;
        this.readCrossModuleLinkTypeExtensionPoint();
    }

    public void setLinkManager(IModuleLinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public synchronized void registerLinkTypesWithFrameLinkManager() {
        if (this.initialisationPending) {
            this.checkRegisteredLinkTypes();
        }
        for (ICrossModuleLinkType linkType : this.map_linkTypeID_linkType.values()) {
            Object cardinality = linkType.getModuleDataCardinality() != null && linkType.getModuleDataCardinality().equals(CARDINALITY_NONEORONE) ? (linkType.getLinkableObjectCardinality() != null && linkType.getLinkableObjectCardinality().equals(CARDINALITY_NONEORONE) ? new Cardinality11() : new CardinalityN1()) : (linkType.getLinkableObjectCardinality() != null && linkType.getLinkableObjectCardinality().equals(CARDINALITY_NONEORONE) ? new Cardinality1N() : new CardinalityNN());
            ILinkTypeLinkAccessFacade linkAccessFacade = this.linkManager.registerLinkType((ILinkType)new LinkType(linkType.getId(), linkType.getName().getLabel(Locale.getDefault()), CrossModuleLinkManager.getLinkableObjectContributionVirtualDataTypeID(linkType.getId()), CrossModuleLinkManager.getModuleDataContributionVirtualDataTypeID(linkType.getId()), (ILinkCardinality)cardinality, DECLARATIONMODULEID_CROSSMODULELINKS, null, false, true));
            this.map_linkTypeID_linkAccessFacade.put(linkType.getId(), linkAccessFacade);
            Collection<String> possibleLOTypes = linkType.getAllowedTypesForLinkableObjectContribution();
            if (possibleLOTypes == ALLOW_ALL_MODULEDATA_TYPES) {
                possibleLOTypes = this.map_cockpitTypeID_moduleIDAndDataManager.keySet();
            }
            this.linkManager.registerTypeTranslation(CrossModuleLinkManager.getLinkableObjectContributionVirtualDataTypeID(linkType.getId()), possibleLOTypes);
            Collection<String> possibleMDTypes = linkType.getAllowedTypesForModuleDataContribution();
            if (possibleMDTypes == ALLOW_ALL_MODULEDATA_TYPES) {
                possibleMDTypes = this.map_cockpitTypeID_moduleIDAndDataManager.keySet();
            }
            this.linkManager.registerTypeTranslation(CrossModuleLinkManager.getModuleDataContributionVirtualDataTypeID(linkType.getId()), possibleMDTypes);
        }
    }

    public synchronized void registerLinkedDataAccessFacadesWithFrameLinkManager() {
        if (this.initialisationPending) {
            this.checkRegisteredLinkTypes();
        }
        for (ICrossModuleLinkType linkType : this.map_linkTypeID_linkType.values()) {
            String moduleDataContributionVirtualDataTypeID = CrossModuleLinkManager.getModuleDataContributionVirtualDataTypeID(linkType.getId());
            CrossModuleLinksLinkedDataAccessFacade moduleDataFacade = new CrossModuleLinksLinkedDataAccessFacade(moduleDataContributionVirtualDataTypeID, this.getMapping_cockpitTypeID_dataManager(linkType.getAllowedTypesForModuleDataContribution()), linkType.getAllowedTypesForModuleDataContribution() == ALLOW_ALL_MODULEDATA_TYPES);
            this.linkManager.registerLinkedDataAccessFacade((ILinkedDataAccessFacade)moduleDataFacade);
            this.map_contributionVirtualDataTypeID_linkedDataAccessFacade.put(moduleDataContributionVirtualDataTypeID, moduleDataFacade);
            String linkableObjectContributionVirtualDataTypeID = CrossModuleLinkManager.getLinkableObjectContributionVirtualDataTypeID(linkType.getId());
            CrossModuleLinksLinkedDataAccessFacade linkableObjectFacade = new CrossModuleLinksLinkedDataAccessFacade(linkableObjectContributionVirtualDataTypeID, this.getMapping_cockpitTypeID_dataManager(linkType.getAllowedTypesForLinkableObjectContribution()), linkType.getAllowedTypesForLinkableObjectContribution() == ALLOW_ALL_MODULEDATA_TYPES);
            this.linkManager.registerLinkedDataAccessFacade((ILinkedDataAccessFacade)linkableObjectFacade);
            this.map_contributionVirtualDataTypeID_linkedDataAccessFacade.put(linkableObjectContributionVirtualDataTypeID, linkableObjectFacade);
        }
    }

    public synchronized Collection<IPlatformAdapterModule> getPlatformAdaptorModules() {
        if (this.initialisationPending) {
            this.checkRegisteredLinkTypes();
        }
        return PlatformAdapterModuleProviderCrossModuleLinks.getPlatformAdapterModules(this.map_linkTypeID_linkType.values(), this.getMapping_cockpitTypeID_moduleID(), (LinkManager)this.linkManager, ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID).getLockManager(), this.map_moduleID_licenseTypeProvider, ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID));
    }

    public synchronized void registerDataTypesForModule(Collection<String> cockpitTypeIDs, String moduleID, AbstractDataMgr dataManager, AbstractDataFacade dataFacade, ILicenseTypeProvider licenseTypeProvider) {
        if (!this.initialisationPending) {
            throw new IllegalStateException("Can not register data manager after initialisation phase is completed.");
        }
        for (String cockpitTypeID : cockpitTypeIDs) {
            this.map_cockpitTypeID_moduleIDAndDataManager.put(cockpitTypeID, new ModuleIDAndDataManager(moduleID, dataManager, dataFacade));
        }
        this.map_moduleID_licenseTypeProvider.put(moduleID, licenseTypeProvider);
    }

    private void readCrossModuleLinkTypeExtensionPoint() {
        List crossModuleLinkTypes = ExtensionMgr.getDefault().getExtension(ModuleLib2Plugin.getDefault().getPluginID(), EXTENSION_POINT_ID, ELEMENT_TYPE_ID, ATTRIBUTE_ID, ICrossModuleLinkType.class);
        for (ICrossModuleLinkType linkType : crossModuleLinkTypes) {
            this.map_linkTypeID_linkType.put(linkType.getId(), linkType);
        }
    }

    public boolean isLinkTypeRegistered(String linkTypeID) {
        return this.map_linkTypeID_linkType.containsKey(linkTypeID);
    }

    public ICrossModuleLinkType getLinkTypeDescription(String linkTypeID) {
        return this.map_linkTypeID_linkType.get(linkTypeID);
    }

    public static String getModuleDataContributionVirtualDataTypeID(String linkTypeID) {
        return String.valueOf(linkTypeID) + MODULEDATACONTRIBUTION_POSTFIX;
    }

    public static String getLinkableObjectContributionVirtualDataTypeID(String linkTypeID) {
        return String.valueOf(linkTypeID) + LINKABLEOBJECTCONTRIBUTION_POSTFIX;
    }

    private Map<String, AbstractDataMgr> getMapping_cockpitTypeID_dataManager(Collection<String> allowedTypes) {
        HashMap<String, AbstractDataMgr> map_cockpitTypeID_dataManager = new HashMap<String, AbstractDataMgr>();
        Collection<String> allAllowedTypes = allowedTypes != ALLOW_ALL_MODULEDATA_TYPES ? allowedTypes : this.map_cockpitTypeID_moduleIDAndDataManager.keySet();
        for (String allowedType : allAllowedTypes) {
            ModuleIDAndDataManager moduleIDAndDataManager = this.map_cockpitTypeID_moduleIDAndDataManager.get(allowedType);
            map_cockpitTypeID_dataManager.put(allowedType, moduleIDAndDataManager.getDataManager());
        }
        return map_cockpitTypeID_dataManager;
    }

    private Map<String, String> getMapping_cockpitTypeID_moduleID() {
        HashMap<String, String> map_cockpitTypeID_moduleID = new HashMap<String, String>();
        for (Map.Entry<String, ModuleIDAndDataManager> entry : this.map_cockpitTypeID_moduleIDAndDataManager.entrySet()) {
            map_cockpitTypeID_moduleID.put(entry.getKey(), entry.getValue().getModuleID());
        }
        return map_cockpitTypeID_moduleID;
    }

    private void checkRegisteredLinkTypes() {
        this.initialisationPending = false;
        Iterator<ICrossModuleLinkType> linkTypeIterator = this.map_linkTypeID_linkType.values().iterator();
        while (linkTypeIterator.hasNext()) {
            ICrossModuleLinkType linkType = linkTypeIterator.next();
            HashSet<String> allowedTypes = new HashSet<String>();
            allowedTypes.addAll(linkType.getAllowedTypesForModuleDataContribution());
            allowedTypes.addAll(linkType.getAllowedTypesForLinkableObjectContribution());
            for (String allowedType : allowedTypes) {
                if (this.map_cockpitTypeID_moduleIDAndDataManager.containsKey(allowedType)) continue;
                linkTypeIterator.remove();
                logger.info("Rejecting cross module link type \"" + linkType.getId() + "\" - the allowed contribution type \"" + allowedType + "\" has not been registered (probably the defining module is not installed)");
            }
        }
    }

    public Collection<IModuleData> getModuleDataItems(IModuleData linkableObject, String linkTypeID) {
        return this.getModuleDataItems(linkableObject.getUID(), linkTypeID);
    }

    public Collection<IModuleData> getModuleDataItems(String linkableObjectUID, String linkTypeID) {
        Collection moduleDataItems_u;
        ILinkTypeLinkAccessFacade linkAccessFacade = this.map_linkTypeID_linkAccessFacade.get(linkTypeID);
        Collection moduleDataItems = moduleDataItems_u = linkAccessFacade.getModuleData(linkableObjectUID);
        moduleDataItems.removeAll(Collections.singleton(null));
        return moduleDataItems;
    }

    public Collection<IModuleData> getLinkableObjects(IModuleData moduleDataItem, String linkTypeID) {
        return this.getLinkableObjects(moduleDataItem.getUID(), linkTypeID);
    }

    public Collection<IModuleData> getLinkableObjects(String moduleDataItemUID, String linkTypeID) {
        Collection linkableObjects_u;
        ILinkTypeLinkAccessFacade linkAccessFacade = this.map_linkTypeID_linkAccessFacade.get(linkTypeID);
        Collection linkableObjects = linkableObjects_u = linkAccessFacade.getLinkableObjects(moduleDataItemUID);
        linkableObjects.removeAll(Collections.singleton(null));
        return linkableObjects;
    }

    public IModuleData getLinkedItem_LinkableObject(String linkableObjectUID, String linkTypeID) {
        CrossModuleLinksLinkedDataAccessFacade linkedDataAccessFacade = this.map_contributionVirtualDataTypeID_linkedDataAccessFacade.get(CrossModuleLinkManager.getLinkableObjectContributionVirtualDataTypeID(linkTypeID));
        return (IModuleData)linkedDataAccessFacade.getLinkedItem(linkableObjectUID);
    }

    public IModuleData getLinkedItem_ModuleData(String moduleDataUID, String linkTypeID) {
        CrossModuleLinksLinkedDataAccessFacade linkedDataAccessFacade = this.map_contributionVirtualDataTypeID_linkedDataAccessFacade.get(CrossModuleLinkManager.getModuleDataContributionVirtualDataTypeID(linkTypeID));
        return (IModuleData)linkedDataAccessFacade.getLinkedItem(moduleDataUID);
    }

    public boolean checkPermissionForLinkingAndUnlinking_ModuleData(String moduleDataUID, String linkTypeID) {
        IModuleData item = this.getLinkedItem_ModuleData(moduleDataUID, linkTypeID);
        AbstractDataMgr dataManager = this.map_cockpitTypeID_moduleIDAndDataManager.get(item.getTypeID()).getDataManager();
        IModuleData parent = dataManager.getParent(item);
        return dataManager.getPermissionMgr().mayEditItemStructurally(item, parent);
    }

    public boolean checkPermissionForLinkingAndUnlinking_LinkableObject(String linkableObjectUID, String linkTypeID) {
        IModuleData item = this.getLinkedItem_LinkableObject(linkableObjectUID, linkTypeID);
        if (item == null) {
            return true;
        }
        AbstractDataMgr dataManager = this.map_cockpitTypeID_moduleIDAndDataManager.get(item.getTypeID()).getDataManager();
        IModuleData parent = dataManager.getParent(item);
        return dataManager.getPermissionMgr().mayEditItemStructurally(item, parent);
    }

    public AbstractDataFacade getResponsibleDataFacade(String cockpitTypeID) {
        ModuleIDAndDataManager moduleIDAndDataManager = this.map_cockpitTypeID_moduleIDAndDataManager.get(cockpitTypeID);
        return moduleIDAndDataManager.getDataFacade();
    }
}

