/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.docgen.provider;

import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.dataexchange.CrossModuleLinksDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.IProjectLocaleProvider;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IProjectRelatedModuleReportContext;
import com.arcway.cockpit.modulelib2.client.docgen.provider.ProjectRelatedModuleReportContext;
import com.arcway.cockpit.modulelib2.client.docgen.provider.interfaces.IGeneralModuleReportProvider;
import com.arcway.cockpit.modulelib2.client.docgen.provider.interfaces.IModuleData;
import com.arcway.lib.java.Equals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class ReportDataProvider
implements IProjectRelatedReportProvider,
IGeneralModuleReportProvider,
IProjectLocaleProvider {
    private IProjectRelatedReportContext reportContext;
    private IProjectRelatedModuleReportContext moduleReportContext;
    private CrossModuleLinksDataFacade dataFacade;

    public void setup(IProjectRelatedReportContext reportContext) {
        this.reportContext = reportContext;
        this.moduleReportContext = new ProjectRelatedModuleReportContext(reportContext);
        this.dataFacade = new CrossModuleLinksDataFacade((IProjectLocaleProvider)this, reportContext.getFilterCollection());
    }

    public Collection<IModuleDataDocGenProxy> getModuleDataItems(IModuleData linkableObject, String crossModuleLinkTypeID) {
        AbstractImExModuleData linkableObject_asImEx = ((IModuleDataDocGenProxy)linkableObject).getWrappedExportableItem();
        Collection exportableItems = this.dataFacade.getModuleDataItems(linkableObject_asImEx, crossModuleLinkTypeID);
        ArrayList<IModuleDataDocGenProxy> docGenProxies = new ArrayList<IModuleDataDocGenProxy>(exportableItems.size());
        for (AbstractImExModuleData exportableItem : exportableItems) {
            docGenProxies.add(this.getDocGenProxy(exportableItem));
        }
        return docGenProxies;
    }

    public Collection<IModuleDataDocGenProxy> getModuleDataItemsWithCategory(IModuleData linkableObject, String crossModuleLinkTypeID, String categoryID) {
        Collection<IModuleDataDocGenProxy> docGenProxies = this.getModuleDataItems(linkableObject, crossModuleLinkTypeID);
        return ReportDataProvider.filterByCategoryID(docGenProxies, categoryID);
    }

    public Collection<IModuleDataDocGenProxy> getModuleDataItemsWithDefaultCategory(IModuleData linkableObject, String crossModuleLinkTypeID) {
        return this.getModuleDataItemsWithCategory(linkableObject, crossModuleLinkTypeID, null);
    }

    public Collection<IModuleDataDocGenProxy> getLinkableObjects(IModuleData moduleDataItem, String crossModuleLinkTypeID) {
        AbstractImExModuleData moduleDataItem_asImEx = ((IModuleDataDocGenProxy)moduleDataItem).getWrappedExportableItem();
        Collection exportableItems = this.dataFacade.getLinkableObjects(moduleDataItem_asImEx, crossModuleLinkTypeID);
        ArrayList<IModuleDataDocGenProxy> docGenProxies = new ArrayList<IModuleDataDocGenProxy>(exportableItems.size());
        for (AbstractImExModuleData exportableItem : exportableItems) {
            docGenProxies.add(this.getDocGenProxy(exportableItem));
        }
        return docGenProxies;
    }

    public Collection<IModuleDataDocGenProxy> getLinkableObjectsWithCategory(IModuleData moduleDataItem, String crossModuleLinkTypeID, String categoryID) {
        Collection<IModuleDataDocGenProxy> docGenProxies = this.getLinkableObjects(moduleDataItem, crossModuleLinkTypeID);
        return ReportDataProvider.filterByCategoryID(docGenProxies, categoryID);
    }

    public Collection<IModuleDataDocGenProxy> getLinkableObjectsWithDefaultCategory(IModuleData moduleDataItem, String crossModuleLinkTypeID) {
        return this.getLinkableObjectsWithCategory(moduleDataItem, crossModuleLinkTypeID, null);
    }

    private IModuleDataDocGenProxy getDocGenProxy(AbstractImExModuleData exportableItem) {
        return this.moduleReportContext.getDocGenProxy(exportableItem);
    }

    public Locale getProjectLocale() {
        return new Locale(this.reportContext.getProjectAgent().getLanguageID());
    }

    protected static final <T extends IModuleDataDocGenProxy> Collection<T> filterByCategoryID(Collection<T> toFilter, String categoryID) {
        if (toFilter == null) {
            return null;
        }
        ArrayList<IModuleDataDocGenProxy> filtered = new ArrayList<IModuleDataDocGenProxy>(toFilter.size());
        for (IModuleDataDocGenProxy customPropertyAccess : toFilter) {
            if (!Equals.equals((Object)customPropertyAccess.getCategoryID(), (Object)categoryID)) continue;
            filtered.add(customPropertyAccess);
        }
        return filtered;
    }
}

