/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.interFace.client.eclipse.interFace;

import com.arcway.lib.java.Assert;
import java.net.URI;
import java.net.URISyntaxException;

public class COCKPITObjectUID {
    private static final String UID_SEPERATOR = "-";
    private final String projectUID;
    private final String objectTypeUID;
    private final String objectUID;

    COCKPITObjectUID(String projectUID, String objectTypeUID, String objectUID) {
        Assert.checkArgumentBeeingNotNull((Object)projectUID);
        Assert.checkStringToBeNotEmpty((String)projectUID);
        Assert.checkArgumentBeeingNotNull((Object)objectTypeUID);
        Assert.checkStringToBeNotEmpty((String)objectTypeUID);
        Assert.checkArgumentBeeingNotNull((Object)objectUID);
        Assert.checkStringToBeNotEmpty((String)objectUID);
        this.projectUID = projectUID;
        this.objectTypeUID = objectTypeUID;
        this.objectUID = objectUID;
    }

    public COCKPITObjectUID(String uIDString) {
        this(uIDString, UID_SEPERATOR);
    }

    public COCKPITObjectUID(URI uri) {
        this(uri.getPath().substring("/".length()), "/");
    }

    private COCKPITObjectUID(String uIDString, String separator) {
        int seperartorPos2;
        int seperartorPos1 = uIDString.indexOf(separator);
        if (seperartorPos1 < 0) {
            Assert.illegalArgument((String)("wrong UID format: " + uIDString));
        }
        if ((seperartorPos2 = uIDString.indexOf(separator, seperartorPos1 + 1)) < 0) {
            Assert.illegalArgument((String)("wrong UID format: " + uIDString));
        }
        String projectUIDFromXML = uIDString.substring(0, seperartorPos1);
        String objectTypeUIDFromXML = uIDString.substring(seperartorPos1 + separator.length(), seperartorPos2);
        String objectUIDFromXML = uIDString.substring(seperartorPos2 + separator.length());
        Assert.checkStringToBeNotEmpty((String)projectUIDFromXML);
        Assert.checkStringToBeNotEmpty((String)objectTypeUIDFromXML);
        Assert.checkStringToBeNotEmpty((String)objectUIDFromXML);
        if (projectUIDFromXML.length() == 0 || objectTypeUIDFromXML.length() == 0 || objectUIDFromXML.length() == 0) {
            Assert.illegalArgument((String)("wrong UID format: " + uIDString));
        }
        this.projectUID = projectUIDFromXML;
        this.objectTypeUID = objectTypeUIDFromXML;
        this.objectUID = objectUIDFromXML;
    }

    public final String toUIDString() {
        return String.valueOf(this.projectUID) + UID_SEPERATOR + this.objectTypeUID + UID_SEPERATOR + this.objectUID;
    }

    public final URI toURI(String query) {
        URI uri;
        String scheme = "cockpit";
        String path = "/" + this.projectUID + "/" + this.objectTypeUID + "/" + this.objectUID;
        String fragment = null;
        try {
            uri = new URI(scheme, null, path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    String getProjectUID() {
        return this.projectUID;
    }

    String getObjectTypeUID() {
        return this.objectTypeUID;
    }

    String getObjectUID() {
        return this.objectUID;
    }

    public final boolean isEqualUID(COCKPITObjectUID uIDtoCompare) {
        return this.projectUID.equals(uIDtoCompare.projectUID) && this.objectTypeUID.equals(uIDtoCompare.objectTypeUID) && this.objectUID.equals(uIDtoCompare.objectUID);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.toUIDString() + ")";
    }
}

