/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages.description;

import com.arcway.cockpit.client.base.interfaces.frame.IProjectAgent;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import de.plans.lib.resources.IIconResource;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Image;

public class NaturalOrderDataTypeDescriptionForFrame
extends AbstractModuleDataTypeDescriptionForFrame
implements IExecutableExtension {
    private static final String GENERICMODULE_NATURALORDER_TYPEPREFIX = "com.arcway.cockpit.genericmodule.";
    private static final String GENERICMODULE_NATURALORDER_TYPEINFIX = ".virtualtypefornaturalorder.typerank-";
    private ModuleDataTypeDescriptionForFrame cockpitModuleDataType;
    private static final Map<String, ModuleDataTypeDescriptionForFrame> map_moduleAndTypeRank_typeDescription = new HashMap<String, ModuleDataTypeDescriptionForFrame>();

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String moduleID = SpecificationProvider.getDefault().getModuleID(data);
        ObjectType objectType = (ObjectType)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        this.cockpitModuleDataType = NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeDescriptionForFrame(moduleID, objectType.getTypeRank());
    }

    public Collection<IAttributeType> getAttributeTypes(IProjectAgent projectAgent) {
        return this.cockpitModuleDataType.getAttributeTypes(projectAgent);
    }

    public String getCockpitDataTypeID() {
        return this.cockpitModuleDataType.getCockpitDataTypeID();
    }

    public String getModuleID() {
        return this.cockpitModuleDataType.getModuleID();
    }

    public String getDisplayName() {
        return this.cockpitModuleDataType.getDisplayName();
    }

    public String getDisplayName(ICockpitProjectData data) {
        return this.cockpitModuleDataType.getDisplayName(data);
    }

    public Image getIcon() {
        return this.cockpitModuleDataType.getIcon();
    }

    public Image getImage(ICockpitProjectData data) {
        return this.cockpitModuleDataType.getImage(data);
    }

    public boolean allowsUserDefinedAttributeTypes() {
        return this.cockpitModuleDataType.allowsUserDefinedAttributeTypes();
    }

    public boolean isSupportingCategories() {
        return this.cockpitModuleDataType.isSupportingCategories();
    }

    public Collection<String> getAllPermissionRelevantFixedAttributeTypesWithDefaultPermission(String projectUID) {
        return this.cockpitModuleDataType.getAllPermissionRelevantFixedAttributeTypesWithDefaultPermission(projectUID);
    }

    public Collection<String> getAllPermissionRelevantFixedAttributeTypesWithoutDefaultPermission(String projectUID) {
        return this.cockpitModuleDataType.getAllPermissionRelevantFixedAttributeTypesWithoutDefaultPermission(projectUID);
    }

    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID, IFrameProjectAgent projectAgent) {
        return this.cockpitModuleDataType.getAttributeType(attributeTypeID, projectAgent);
    }

    public boolean hasCustomPropertyPermissions() {
        return this.cockpitModuleDataType.hasCustomPropertyPermissions();
    }

    public boolean hasNaturalOrder() {
        return this.cockpitModuleDataType.hasNaturalOrder();
    }

    public boolean isToBeDisplayedInDataView() {
        return this.cockpitModuleDataType.isToBeDisplayedInDataView();
    }

    public boolean equals(Object obj) {
        return this.cockpitModuleDataType.equals(obj);
    }

    public int hashCode() {
        return this.cockpitModuleDataType.hashCode();
    }

    public static ModuleDataTypeDescriptionForFrame getNaturalOrderDataTypeDescriptionForFrame(String moduleID, int typeRank) {
        String key = String.valueOf(moduleID) + "\n" + Integer.toString(typeRank);
        if (map_moduleAndTypeRank_typeDescription.containsKey(key)) {
            return map_moduleAndTypeRank_typeDescription.get(key);
        }
        ModuleDataSpecification dataSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID).getModuleDataSpecification();
        String label = "";
        IIconResource icon = null;
        int typeCount = 0;
        for (ObjectType objectType : dataSpecification.getObjectTypeList()) {
            if (objectType.getTypeRank() != typeRank || objectType.getParentTypeList().size() == 1 && objectType.getParentType(0).getParentObjectTypeID().equals("noparent")) continue;
            if (typeCount > 0) {
                label = String.valueOf(label) + " & ";
            }
            GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(moduleID, objectType);
            label = String.valueOf(label) + typeDescription.getTypeName(Locale.getDefault());
            icon = typeDescription.getTypeIcon();
            ++typeCount;
        }
        if (typeCount == 0) {
            label = "Object of Type Rank " + typeRank;
        }
        if (typeCount > 1) {
            icon = null;
        }
        ModuleDataTypeDescriptionForFrame typeDescription = new ModuleDataTypeDescriptionForFrame(NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeCockpitTypeID(moduleID, typeRank), ModuleIdentification.getFullModuleID(moduleID), label, icon, false, true, false, false, Collections.emptySet(), Collections.emptySet());
        map_moduleAndTypeRank_typeDescription.put(key, typeDescription);
        return typeDescription;
    }

    public static String getNaturalOrderDataTypeCockpitTypeID(String moduleID, int typeRank) {
        return GENERICMODULE_NATURALORDER_TYPEPREFIX + moduleID + GENERICMODULE_NATURALORDER_TYPEINFIX + Integer.toString(typeRank);
    }
}

