/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages.description;

import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.SpecificationConstantsHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.StatusHelper;
import com.arcway.cockpit.genericmodule.client.messages.description.NaturalOrderDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.ModuleLabelProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.AbstractModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextObjectTypeName;
import com.arcway.frontend.definition.lib.interFace.declaration.label.TextPropertyValue;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import de.plans.lib.localisation.ConcatenatingLabelProvider;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.resources.IIconResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class GenericModuleDataTypeDescription
extends AbstractModuleDataTypeDescription {
    private static final ILogger logger = Logger.getLogger(GenericModuleDataTypeDescription.class);
    private final ObjectType objectTypeSpecification;
    private final String moduleID;
    private final String typeID;
    private ModuleDataTypeDescriptionForFrame moduleDataTypeDescriptionForFrame;
    private String idAttributeID;
    private final LinkedHashMap<String, String> map_childrenIDFormatAttribute_childCockpitTypeID;
    private final Collection<String> permissionRelevantAttributesWithDefaultPermission;
    private static final MapMap<String, String, GenericModuleDataTypeDescription> map_moduleAndObjectType_typeDescription = new MapMap();
    private final LabelProvider objectTypeNameLabelProvider;

    public static GenericModuleDataTypeDescription getTypeDescription(String moduleID, ObjectType objectTypeSpecification) {
        return GenericModuleDataTypeDescription.getTypeDescription(moduleID, objectTypeSpecification, false);
    }

    public static GenericModuleDataTypeDescription getTypeDescription(String moduleID, ObjectType objectTypeSpecification, boolean forPlatformAdapter) {
        if (!forPlatformAdapter) {
            String objectTypeID = objectTypeSpecification.getObjectTypeID();
            GenericModuleDataTypeDescription typeDescription = (GenericModuleDataTypeDescription)((Object)map_moduleAndObjectType_typeDescription.get((Object)moduleID, (Object)objectTypeID));
            if (typeDescription == null) {
                typeDescription = new GenericModuleDataTypeDescription(moduleID, objectTypeSpecification, false);
                map_moduleAndObjectType_typeDescription.put((Object)moduleID, (Object)objectTypeID, (Object)typeDescription);
            }
            return typeDescription;
        }
        return new GenericModuleDataTypeDescription(moduleID, objectTypeSpecification, true);
    }

    private GenericModuleDataTypeDescription(String moduleID, ObjectType objectTypeSpecification, boolean forPlatformAdapter) {
        this.objectTypeSpecification = objectTypeSpecification;
        this.moduleID = moduleID;
        this.typeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectTypeSpecification.getObjectTypeID());
        this.permissionRelevantAttributesWithDefaultPermission = new HashSet<String>(objectTypeSpecification.getAttributeList().size());
        this.map_childrenIDFormatAttribute_childCockpitTypeID = new LinkedHashMap(objectTypeSpecification.getAttributeList().size());
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(moduleID);
        for (Attribute attribute : objectTypeSpecification.getAttributeList()) {
            AbstractModuleSpecificationPart cAttribute;
            if (attribute instanceof IDAttribute) {
                IDAttribute idAttribute = (IDAttribute)attribute;
                this.addSimpleAttribute(idAttribute.getAttributeID(), (ILabelProvider)new LabelProvider(idAttribute.getAttributeName()), true);
                if (this.idAttributeID == null) {
                    this.idAttributeID = idAttribute.getAttributeID();
                } else {
                    logger.warn("Object type has two id attributes (" + objectTypeSpecification.getObjectTypeID() + " in module " + moduleID + ")");
                }
                this.permissionRelevantAttributesWithDefaultPermission.add(idAttribute.getAttributeID());
                continue;
            }
            if (attribute instanceof SimpleAttribute) {
                SimpleAttribute sAttribute = (SimpleAttribute)attribute;
                this.addSimpleAttribute(sAttribute.getAttributeID(), (ILabelProvider)new LabelProvider(sAttribute.getAttributeName()), sAttribute.isMandatory());
                this.permissionRelevantAttributesWithDefaultPermission.add(sAttribute.getAttributeID());
                continue;
            }
            if (attribute instanceof ChildrenIDFormatAttribute) {
                cAttribute = (ChildrenIDFormatAttribute)attribute;
                if (!forPlatformAdapter) {
                    this.addSimpleAttribute(String.valueOf(((ChildrenIDFormatAttribute)cAttribute).getAttributeID()) + "-pattern", (ILabelProvider)new ConcatenatingLabelProvider(new ILabelProvider[]{new ModuleLabelProvider(AttributeHelper.NAME_CHILDRENIDFORMAT_PATTERN, Messages.class), new LabelProviderUnlocalisedString(" ("), new LabelProvider(((ChildrenIDFormatAttribute)cAttribute).getAttributeName()), new LabelProviderUnlocalisedString(")")}), false);
                    this.addSimpleAttribute(String.valueOf(((ChildrenIDFormatAttribute)cAttribute).getAttributeID()) + "-prefix", (ILabelProvider)new ConcatenatingLabelProvider(new ILabelProvider[]{new ModuleLabelProvider(AttributeHelper.NAME_CHILDRENIDFORMAT_PREFIX, Messages.class), new LabelProviderUnlocalisedString(" ("), new LabelProvider(((ChildrenIDFormatAttribute)cAttribute).getAttributeName()), new LabelProviderUnlocalisedString(")")}), false);
                    this.addSimpleAttribute(String.valueOf(((ChildrenIDFormatAttribute)cAttribute).getAttributeID()) + "-usedefaultprefix", (ILabelProvider)new ConcatenatingLabelProvider(new ILabelProvider[]{new ModuleLabelProvider(AttributeHelper.NAME_CHILDRENIDFORMAT_USEDEFAULTPREFIX, Messages.class), new LabelProviderUnlocalisedString(" ("), new LabelProvider(((ChildrenIDFormatAttribute)cAttribute).getAttributeName()), new LabelProviderUnlocalisedString(")")}), false);
                    this.addSimpleAttribute(String.valueOf(((ChildrenIDFormatAttribute)cAttribute).getAttributeID()) + "-overrideparentsettings", (ILabelProvider)new ConcatenatingLabelProvider(new ILabelProvider[]{new ModuleLabelProvider(AttributeHelper.NAME_CHILDRENIDFORMAT_OVERRIDEPARENTSETTINGS, Messages.class), new LabelProviderUnlocalisedString(" ("), new LabelProvider(((ChildrenIDFormatAttribute)cAttribute).getAttributeName()), new LabelProviderUnlocalisedString(")")}), true);
                } else {
                    this.addSimpleAttribute(((ChildrenIDFormatAttribute)cAttribute).getAttributeID(), (ILabelProvider)new LabelProvider(((ChildrenIDFormatAttribute)cAttribute).getAttributeName()), true);
                }
                this.map_childrenIDFormatAttribute_childCockpitTypeID.put(((ChildrenIDFormatAttribute)cAttribute).getAttributeID(), ClientDataFactory_TypesHelper.getDataTypeID(moduleID, ((ChildrenIDFormatAttribute)cAttribute).getChildObjectTypeID()));
                this.permissionRelevantAttributesWithDefaultPermission.add(((ChildrenIDFormatAttribute)cAttribute).getAttributeID());
                continue;
            }
            if (attribute instanceof EnumerationAttribute) {
                EnumerationAttribute eAttribute = (EnumerationAttribute)attribute;
                this.addSimpleAttribute(eAttribute.getAttributeID(), (ILabelProvider)new LabelProvider(eAttribute.getAttributeName()), true);
                this.permissionRelevantAttributesWithDefaultPermission.add(eAttribute.getAttributeID());
                continue;
            }
            if (attribute instanceof LinkedModuleDataAttribute) {
                LinkedModuleDataAttribute lAttribute = (LinkedModuleDataAttribute)attribute;
                this.addLinkedModuleDataAttribute(lAttribute.getAttributeID(), (ILabelProvider)new LabelProvider(lAttribute.getAttributeName()), linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectTypeSpecification.getObjectTypeID(), lAttribute.getAttributeID()), ClientDataFactory_TypesHelper.getDataTypeID(moduleID, lAttribute.getObjectTypeID()));
                this.permissionRelevantAttributesWithDefaultPermission.add(lAttribute.getAttributeID());
                continue;
            }
            if (attribute instanceof LinkedFrameDataAttribute) {
                LinkedFrameDataAttribute fAttribute = (LinkedFrameDataAttribute)attribute;
                this.addLinkedFrameDataAttribute(fAttribute.getAttributeID(), (ILabelProvider)new LabelProvider(fAttribute.getAttributeName()), linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectTypeSpecification.getObjectTypeID(), fAttribute.getAttributeID()), SpecificationConstantsHelper.getCockpitDataTypeIDForLinkedFrameObjectType(fAttribute.getFrameObjectTypeID()));
                this.permissionRelevantAttributesWithDefaultPermission.add(fAttribute.getAttributeID());
                continue;
            }
            if (!(attribute instanceof CalculatedAttribute)) continue;
            cAttribute = (CalculatedAttribute)attribute;
            this.addCalculatedAttribute(((CalculatedAttribute)cAttribute).getAttributeID(), (ILabelProvider)new LabelProvider(((CalculatedAttribute)cAttribute).getAttributeName()));
        }
        this.objectTypeNameLabelProvider = new LabelProvider(objectTypeSpecification.getObjectTypeName());
    }

    public String getIDAttribute() {
        return this.idAttributeID;
    }

    public String getNameAttribute() {
        return null;
    }

    public List<String> getChildrenIDFormatAttributeIDs() {
        return new ArrayList<String>(this.map_childrenIDFormatAttribute_childCockpitTypeID.keySet());
    }

    public String getChildCockpitTypeForIDFormatAttribute(String childrenIDFormatAttributeID) {
        return this.map_childrenIDFormatAttribute_childCockpitTypeID.get(childrenIDFormatAttributeID);
    }

    public IIconResource getTypeIcon() {
        if (this.objectTypeSpecification.getObjectTypeIcon() != null && this.objectTypeSpecification.getObjectTypeIcon().length() > 0) {
            return new IconResource(this.moduleID, this.objectTypeSpecification.getObjectTypeIcon());
        }
        return null;
    }

    public String getTypeName(Locale locale) {
        return this.objectTypeNameLabelProvider.getLabel(locale);
    }

    public String getDefaultIDPrefix(Locale locale) {
        if (this.idAttributeID != null) {
            IDAttribute idAttribute = (IDAttribute)this.objectTypeSpecification.getAttribute(this.idAttributeID);
            String idPrefix = new LabelProvider(idAttribute.getDefaultPrefix()).getLabel(locale);
            if (idPrefix != null && idPrefix.trim().length() > 0) {
                return idPrefix;
            }
            String fallbackPrefix = new LabelProvider(this.objectTypeSpecification.getObjectTypeName()).getLabel(locale);
            if (fallbackPrefix.length() > 3) {
                fallbackPrefix = fallbackPrefix.substring(0, 3);
            }
            fallbackPrefix = fallbackPrefix.toUpperCase();
            return fallbackPrefix;
        }
        return null;
    }

    private boolean isSupportingCustomProperties() {
        return ClientDataFactory_TypesHelper.isHierarchyType(this.objectTypeSpecification) && !this.objectTypeSpecification.isDisableCustomProperties();
    }

    public boolean isSupportingCategories() {
        return this.isSupportingCustomProperties() && !this.objectTypeSpecification.isDisableObjectTypeCategories();
    }

    public boolean isNaturalOrderUserDetermined() {
        return !GMDataTypesHelper.getDefault(this.moduleID).isAdministrativeDataType(this.typeID);
    }

    public Comparator<? extends IModuleData> getNaturalOrderComparator() {
        if (GMDataTypesHelper.getDefault(this.moduleID).isAdministrativeDataType(this.typeID)) {
            return new Comparator<GenericModuleData>(){

                @Override
                public int compare(GenericModuleData o1, GenericModuleData o2) {
                    return o1.getDisplayRepresentation().compareToIgnoreCase(o2.getDisplayRepresentation());
                }
            };
        }
        return null;
    }

    public IModuleDataTypeDescriptionForFrame getDataTypeForNaturalOrdering() {
        if (this.objectTypeSpecification.getParentTypeList().size() == 1 && this.objectTypeSpecification.getParentType(0).getParentObjectTypeID().equals("noparent")) {
            return this.getModuleDataTypeDescriptionForFrame();
        }
        return NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeDescriptionForFrame(this.moduleID, this.objectTypeSpecification.getTypeRank());
    }

    public int getNaturalOrderPriority() {
        return this.objectTypeSpecification.getTypeRank();
    }

    public IModuleData getNewInstance() {
        return new GenericModuleData(this.moduleID, this.objectTypeSpecification);
    }

    public String getTypeID() {
        return this.typeID;
    }

    public ModuleDataTypeDescriptionForFrame getModuleDataTypeDescriptionForFrame() {
        if (this.moduleDataTypeDescriptionForFrame == null) {
            boolean isHierarchyType = ClientDataFactory_TypesHelper.isHierarchyType(this.objectTypeSpecification);
            this.moduleDataTypeDescriptionForFrame = new ModuleDataTypeDescriptionForFrame(this.getTypeID(), ModuleIdentification.getFullModuleID(this.moduleID), this.getTypeName(Locale.getDefault()), this.getTypeIcon(), this.isSupportingCustomProperties(), false, this.isSupportingCategories(), isHierarchyType, this.permissionRelevantAttributesWithDefaultPermission, Collections.emptyList());
        }
        return this.moduleDataTypeDescriptionForFrame;
    }

    public boolean isCreatableGenerically() {
        return true;
    }

    public boolean isDeletableGenerically() {
        return true;
    }

    public boolean isModifiableGenerically() {
        return true;
    }

    public Icon getStatusDependantIconSpecification(IPropertyDeclarations propertyDeclarations) {
        return StatusHelper.translateStatusDependantIconSpecificationIntoPlatformLanguage(this.moduleID, this.objectTypeSpecification, propertyDeclarations);
    }

    public Text getStatusDependantLabelSpecification(RepositoryIDCreator repositoryIDCreator) {
        Text text;
        String labelAttributeID = this.objectTypeSpecification.getLabelAttributeID();
        if (!this.objectTypeSpecification.getLabelAttributeID().equals("none")) {
            Attribute attribute = this.objectTypeSpecification.getAttribute(labelAttributeID);
            if (!(attribute instanceof CalculatedAttribute)) {
                text = this.getStatusDependantLabelSpecificationForSimpleAttribute(labelAttributeID, repositoryIDCreator);
            } else {
                text = AttributeUIHelper.getPlatformLabelSpecificationForCalculatedAttribute(this.moduleID, this.objectTypeSpecification.getObjectTypeID(), (CalculatedAttribute)attribute, repositoryIDCreator);
                if (text == null) {
                    text = this.getStatusDependantLabelSpecificationForSimpleAttribute(this.objectTypeSpecification.getPlatformLabelAttributeID(), repositoryIDCreator);
                }
            }
        } else {
            return new TextObjectTypeName();
        }
        return text;
    }

    private Text getStatusDependantLabelSpecificationForSimpleAttribute(String attributeID, RepositoryIDCreator repositoryIDCreator) {
        String dataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.objectTypeSpecification.getObjectTypeID());
        RepositoryObjectTypeID repositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(dataTypeID);
        IRepositoryPropertyTypeID repositoryPropertyID = repositoryIDCreator.createPropertyTypeIDForAttribute(repositoryObjectTypeID, attributeID);
        return new TextPropertyValue(repositoryPropertyID);
    }

    public String getHistoryRecordMode() {
        if (this.objectTypeSpecification.getHistoryRecordMode() != null && this.objectTypeSpecification.getHistoryRecordMode().trim().length() > 0) {
            return this.objectTypeSpecification.getHistoryRecordMode();
        }
        return "off";
    }
}

