/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ConditionTerm;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Status;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.platformadapter.IPropertyDeclarations;
import com.arcway.cockpit.modulelib2.client.platformadapter.containerclasses.ModuleStreamResource;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.DiscreteValueHelper;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionAnd;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionNot;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionOr;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionValue1IsLowerThanValue2;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ConditionValuesAreEqual;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconIf;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconObject;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconObjectWithStatusDecorator;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Value;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValueConstantForProperty;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValueNow;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ValuePropertyValue;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.util.valueranges.ValueRangeHelperTimestamp;
import java.util.ArrayList;
import java.util.Collection;

public class StatusHelper {
    public static Collection<String> getPossibleStatuses(ObjectType objectType) {
        ArrayList<String> statusIDs = new ArrayList<String>(objectType.getStatusList().size());
        for (Status status : objectType.getStatusList()) {
            statusIDs.add(status.getStatusID());
        }
        return statusIDs;
    }

    public static String getStatus(ObjectType objectType, GenericModuleData item) {
        for (Status status : objectType.getStatusList()) {
            for (com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Condition condition : status.getConditionList()) {
                boolean conditionFulfilled = true;
                for (ConditionTerm conditionTerm : condition.getConditionTermList()) {
                    block27: {
                        String attributeID;
                        if (conditionTerm.getConditionTermType().equals("enumeration-attribute")) {
                            attributeID = conditionTerm.getValueSpecification();
                            try {
                                ModuleDataAttributeDiscrete discreteAttribute = (ModuleDataAttributeDiscrete)item.getAttribute(attributeID);
                                int actualValueIndex = discreteAttribute.getValue();
                                int requiredValueIndex = Integer.parseInt(conditionTerm.getValuePattern());
                                if (requiredValueIndex == actualValueIndex) continue;
                                conditionFulfilled = false;
                                break;
                            }
                            catch (NumberFormatException nfE) {
                                assert (false) : "Invalid condition term of type \"discrete attribute \" (Status:  " + status.getStatusID() + ")";
                                break block27;
                            }
                        }
                        if (conditionTerm.getConditionTermType().equals("timestamp-attribute")) {
                            attributeID = conditionTerm.getValueSpecification();
                            try {
                                ModuleDataAttributeTimestamp dateAttribute = (ModuleDataAttributeTimestamp)item.getAttribute(attributeID);
                                Long timestamp = dateAttribute.getValue();
                                boolean termFulfilled = false;
                                if (timestamp != null) {
                                    String requiredTimeRelation;
                                    long currentTime = System.currentTimeMillis();
                                    if (!((ValueRangeHelperTimestamp)dateAttribute.getValueRangeHelper()).getIncludeTime()) {
                                        currentTime = ModuleDataAttributeTimestamp.normalizeDateTimeStamp((Long)currentTime);
                                    }
                                    if ((requiredTimeRelation = conditionTerm.getValuePattern()).equals("before")) {
                                        termFulfilled = currentTime <= timestamp;
                                    } else if (requiredTimeRelation.equals("after")) {
                                        termFulfilled = currentTime > timestamp;
                                    } else assert (false) : "Unknown value pattern: " + requiredTimeRelation + " (in a timestamp attribute condition term of status " + status.getStatusID() + ")";
                                }
                                if (termFulfilled) continue;
                                conditionFulfilled = false;
                                break;
                            }
                            catch (NumberFormatException nfE) {
                                assert (false) : "Invalid condition term of type \"discrete attribute \"";
                                break block27;
                            }
                        }
                        if (conditionTerm.getConditionTermType().equals("boolean-attribute")) {
                            attributeID = conditionTerm.getValueSpecification();
                            try {
                                ModuleDataAttributeBoolean booleanAttribute = (ModuleDataAttributeBoolean)item.getAttribute(attributeID);
                                boolean actualValue = booleanAttribute.getValue();
                                String requiredBooleanValue = conditionTerm.getValuePattern();
                                boolean termFulfilled = false;
                                if (requiredBooleanValue.equals("true")) {
                                    termFulfilled = actualValue;
                                } else if (requiredBooleanValue.equals("false")) {
                                    termFulfilled = !actualValue;
                                } else assert (false) : "Unknown value pattern: " + requiredBooleanValue + " (in a booelan attribute condition term of status " + status.getStatusID() + ")";
                                if (termFulfilled) continue;
                                conditionFulfilled = false;
                                break;
                            }
                            catch (NumberFormatException nfE) {
                                if ($assertionsDisabled) break block27;
                                throw new AssertionError((Object)"Invalid condition term of type \"discrete attribute \"");
                            }
                        }
                    }
                    assert (false) : "Unknown condition term type: " + conditionTerm.getConditionTermType();
                    conditionFulfilled = false;
                    break;
                }
                if (!conditionFulfilled) continue;
                return status.getID();
            }
        }
        return "MD_STATUS_DEFAULT";
    }

    public static IIconResource getStatusDependentIconDecoratorForObject(String moduleID, ObjectType objectType, GenericModuleData item) {
        return StatusHelper.getStatusDependentIconDecoratorForObject(moduleID, objectType, StatusHelper.getStatus(objectType, item));
    }

    public static IIconResource getStatusDependentIconDecoratorForObject(String moduleID, ObjectType objectType, String status) {
        String iconName = StatusHelper.getIconNameForStatus(objectType.getStatusDependentObjectIcons(), status);
        if (iconName != null) {
            return new IconResource(moduleID, iconName);
        }
        return null;
    }

    public static IIconResource getStatusDependentIconForAttribute(String moduleID, ObjectType objectType, String attributeID, GenericModuleData item) {
        return StatusHelper.getStatusDependentIconForAttribute(moduleID, objectType, attributeID, StatusHelper.getStatus(objectType, item));
    }

    public static IIconResource getStatusDependentIconForAttribute(String moduleID, ObjectType objectType, String attributeID, String status) {
        Attribute attribute = objectType.getAttribute(attributeID);
        String statusDependantIconSpec = null;
        if (attribute instanceof IDAttribute) {
            statusDependantIconSpec = ((IDAttribute)attribute).getStatusDependentIcons();
        } else if (attribute instanceof SimpleAttribute) {
            statusDependantIconSpec = ((SimpleAttribute)attribute).getStatusDependentIcons();
        } else if (attribute instanceof LinkedModuleDataAttribute) {
            statusDependantIconSpec = ((LinkedModuleDataAttribute)attribute).getStatusDependentIcons();
        } else if (attribute instanceof LinkedFrameDataAttribute) {
            statusDependantIconSpec = ((LinkedFrameDataAttribute)attribute).getStatusDependentIcons();
        } else if (attribute instanceof CalculatedAttribute) {
            statusDependantIconSpec = ((CalculatedAttribute)attribute).getStatusDependentIcons();
        }
        String iconName = StatusHelper.getIconNameForStatus(statusDependantIconSpec, status);
        if (iconName != null) {
            return new IconResource(moduleID, iconName);
        }
        return null;
    }

    public static Icon translateStatusDependantIconSpecificationIntoPlatformLanguage(String moduleID, ObjectType objectTypeSpecification, IPropertyDeclarations propertyDeclarations) {
        IconObject statusDependantIconSpecification = new IconObject();
        for (Status status : objectTypeSpecification.getStatusList()) {
            boolean notApplicableForPlatformDueToCalculatedAttributes = false;
            ArrayList<ConditionAnd> conditionConditionCollection = new ArrayList<ConditionAnd>();
            for (com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Condition conditionSpecification : status.getConditionList()) {
                ArrayList<ConditionValuesAreEqual> termConditionCollection = new ArrayList<ConditionValuesAreEqual>();
                for (ConditionTerm term : conditionSpecification.getConditionTermList()) {
                    IRepositoryPropertyTypeID propertyTypeID;
                    if (objectTypeSpecification.getAttribute(term.getValueSpecification()) instanceof CalculatedAttribute) {
                        notApplicableForPlatformDueToCalculatedAttributes = true;
                        break;
                    }
                    Object termCondition = null;
                    if (term.getConditionTermType().equals("boolean-attribute")) {
                        propertyTypeID = propertyDeclarations.createPropertyTypeID(term.getValueSpecification());
                        IRepositoryData valueSample = term.getValuePattern().equals("true") ? RDTBoolean.getInstance().createData(Boolean.TRUE) : RDTBoolean.getInstance().createData(Boolean.FALSE);
                        termCondition = new ConditionValuesAreEqual((Value)new ValuePropertyValue(propertyTypeID), (Value)new ValueConstantForProperty(propertyTypeID, valueSample));
                    } else if (term.getConditionTermType().equals("enumeration-attribute")) {
                        try {
                            propertyTypeID = propertyDeclarations.createPropertyTypeID(term.getValueSpecification());
                            String uniqueEntryID = DiscreteValueHelper.getPlatformEnumerationElementID((String)term.getValuePattern());
                            ISet_ enumerationEntryValues = propertyDeclarations.getEnumerationElementValues(term.getValueSpecification());
                            if (!enumerationEntryValues.contains((Object)uniqueEntryID)) {
                                uniqueEntryID = null;
                            }
                            IRepositoryData valueSample = RDTSingleChoice.getInstance().createData(uniqueEntryID);
                            termCondition = new ConditionValuesAreEqual((Value)new ValuePropertyValue(propertyTypeID), (Value)new ValueConstantForProperty(propertyTypeID, valueSample));
                        }
                        catch (NumberFormatException nfE) {
                            assert (false) : "Invalid condition term of type \"discrete attribute \" (Status:  " + status.getStatusID() + ")";
                        }
                    } else if (term.getConditionTermType().equals("timestamp-attribute")) {
                        propertyTypeID = propertyDeclarations.createPropertyTypeID(term.getValueSpecification());
                        IRepositoryDataTypeParameters dataTypeParameters = propertyDeclarations.getPropertyType(term.getValueSpecification()).getRepositoryDataTypeParameters();
                        assert (dataTypeParameters instanceof RDTDateUTC64Bitmsec.Parameters);
                        boolean withTimeComponent = ((RDTDateUTC64Bitmsec.Parameters)dataTypeParameters).isWithTimeComponent();
                        termCondition = term.getValuePattern().equals("before") ? new ConditionOr(new Condition[]{new ConditionAnd(new Condition[]{new ConditionNot((Condition)new ConditionValuesAreEqual((Value)new ValueConstantForProperty(propertyTypeID, RDTDateUTC64Bitmsec.getInstance().createData(null)), (Value)new ValuePropertyValue(propertyTypeID))), new ConditionValue1IsLowerThanValue2((Value)new ValueNow(withTimeComponent), (Value)new ValuePropertyValue(propertyTypeID))}), new ConditionValuesAreEqual((Value)new ValueNow(withTimeComponent), (Value)new ValuePropertyValue(propertyTypeID))}) : new ConditionAnd(new Condition[]{new ConditionNot((Condition)new ConditionValuesAreEqual((Value)new ValueConstantForProperty(propertyTypeID, RDTDateUTC64Bitmsec.getInstance().createData(null)), (Value)new ValuePropertyValue(propertyTypeID))), new ConditionValue1IsLowerThanValue2((Value)new ValuePropertyValue(propertyTypeID), (Value)new ValueNow(withTimeComponent))});
                    }
                    if (termCondition == null) continue;
                    termConditionCollection.add((ConditionValuesAreEqual)termCondition);
                }
                if (notApplicableForPlatformDueToCalculatedAttributes) break;
                ConditionAnd conditionCondition = new ConditionAnd(termConditionCollection.toArray(new Condition[termConditionCollection.size()]));
                conditionConditionCollection.add(conditionCondition);
            }
            if (notApplicableForPlatformDueToCalculatedAttributes) continue;
            ConditionOr statusCondition = new ConditionOr(conditionConditionCollection.toArray(new Condition[conditionConditionCollection.size()]));
            IIconResource decoratorIcon = StatusHelper.getStatusDependentIconDecoratorForObject(moduleID, objectTypeSpecification, status.getStatusID());
            statusDependantIconSpecification = decoratorIcon != null ? new IconIf((Condition)statusCondition, (Icon)new IconObjectWithStatusDecorator(status.getStatusID(), (IStreamResource)new ModuleStreamResource(decoratorIcon)), (Icon)statusDependantIconSpecification) : new IconIf((Condition)statusCondition, (Icon)new IconObject(), (Icon)statusDependantIconSpecification);
        }
        return statusDependantIconSpecification;
    }

    private static String getIconNameForStatus(String statusDependentIconsSpecification, String status) {
        String[] statuses;
        if (statusDependentIconsSpecification == null || statusDependentIconsSpecification.length() == 0) {
            return null;
        }
        String[] stringArray = statuses = statusDependentIconsSpecification.split(";");
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            String statuse = stringArray[n2];
            String[] statusIconDefinition = statuse.split(":", -1);
            assert (statusIconDefinition.length == 2) : "Invalid Status-Dependent Icon Definition: " + statusDependentIconsSpecification;
            if (statusIconDefinition.length == 2 && statusIconDefinition[0].equals(status)) {
                return statusIconDefinition[1];
            }
            ++n2;
        }
        return null;
    }
}

