/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.DetailsPageLayout;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.DocumentGeneration;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Exporter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Filters;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.HelpContribution;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.HistoryViewer;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Importer;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Perspective;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.View;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.editors.EditorLayouts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleUISpecification
extends AbstractModuleSpecificationPart {
    private final Perspective perspective;
    private final Map<String, View> viewMap;
    private final List<View> viewList;
    private EditorLayouts editorLayouts;
    private final Map<String, DetailsPageLayout> detailsPageLayoutMap;
    private final List<DetailsPageLayout> detailsPageLayoutList;
    private final Map<String, Filters> filtersMap;
    private final List<Filters> filtersList;
    private final Map<String, HistoryViewer> historyViewerMap;
    private final List<HistoryViewer> historyViewerList;
    private final DocumentGeneration documentGeneration;
    private final Map<String, Exporter> exporterMap;
    private final List<Exporter> exporterList;
    private final Map<String, Importer> importerMap;
    private final List<Importer> importerList;
    private final Map<String, HelpContribution> helpContributionMap;
    private final List<HelpContribution> helpContributionList;

    public ModuleUISpecification(Perspective perspective, List<View> viewList, EditorLayouts editorLayouts, List<DetailsPageLayout> detailsPageLayoutList, List<Filters> filtersList, List<HistoryViewer> historyViewerList, DocumentGeneration documentGeneration, List<Exporter> exporterList, List<Importer> importerList, List<HelpContribution> helpContributionList) {
        this.perspective = perspective;
        this.viewMap = new HashMap<String, View>();
        this.viewList = new ArrayList<View>();
        int viewListCounter = 1;
        for (View part : viewList) {
            ((AbstractModuleSpecificationPart)((Object)part)).setIndex(viewListCounter);
            String partID = part.getID();
            this.viewMap.put(partID, part);
            this.viewList.add(part);
            ++viewListCounter;
        }
        this.editorLayouts = editorLayouts;
        this.detailsPageLayoutMap = new HashMap<String, DetailsPageLayout>();
        this.detailsPageLayoutList = new ArrayList<DetailsPageLayout>();
        int detailsPageLayoutListCounter = 1;
        for (DetailsPageLayout part : detailsPageLayoutList) {
            part.setIndex(detailsPageLayoutListCounter);
            String partID = part.getID();
            this.detailsPageLayoutMap.put(partID, part);
            this.detailsPageLayoutList.add(part);
            ++detailsPageLayoutListCounter;
        }
        this.filtersMap = new HashMap<String, Filters>();
        this.filtersList = new ArrayList<Filters>();
        int filtersListCounter = 1;
        for (Filters part : filtersList) {
            part.setIndex(filtersListCounter);
            String partID = part.getID();
            this.filtersMap.put(partID, part);
            this.filtersList.add(part);
            ++filtersListCounter;
        }
        this.historyViewerMap = new HashMap<String, HistoryViewer>();
        this.historyViewerList = new ArrayList<HistoryViewer>();
        int historyViewerListCounter = 1;
        for (HistoryViewer part : historyViewerList) {
            part.setIndex(historyViewerListCounter);
            String partID = part.getID();
            this.historyViewerMap.put(partID, part);
            this.historyViewerList.add(part);
            ++historyViewerListCounter;
        }
        this.documentGeneration = documentGeneration;
        this.exporterMap = new HashMap<String, Exporter>();
        this.exporterList = new ArrayList<Exporter>();
        int exporterListCounter = 1;
        for (Exporter part : exporterList) {
            part.setIndex(exporterListCounter);
            String partID = part.getID();
            this.exporterMap.put(partID, part);
            this.exporterList.add(part);
            ++exporterListCounter;
        }
        this.importerMap = new HashMap<String, Importer>();
        this.importerList = new ArrayList<Importer>();
        int importerListCounter = 1;
        for (Importer part : importerList) {
            part.setIndex(importerListCounter);
            String partID = part.getID();
            this.importerMap.put(partID, part);
            this.importerList.add(part);
            ++importerListCounter;
        }
        this.helpContributionMap = new HashMap<String, HelpContribution>();
        this.helpContributionList = new ArrayList<HelpContribution>();
        int helpContributionListCounter = 1;
        for (HelpContribution part : helpContributionList) {
            part.setIndex(helpContributionListCounter);
            String partID = part.getID();
            this.helpContributionMap.put(partID, part);
            this.helpContributionList.add(part);
            ++helpContributionListCounter;
        }
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public List<View> getViewList() {
        return this.viewList;
    }

    public View getView(String id) {
        return this.viewMap.get(id);
    }

    public View getView(int index) {
        return this.getViewList().get(index);
    }

    public <T extends View> List<T> getViewListOfType(Class<T> type) {
        ArrayList<View> list = new ArrayList<View>(this.viewMap.size());
        for (View child : this.viewMap.values()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            list.add((View)type.cast(child));
        }
        ModuleUISpecification.sortSpecificationPartList(list);
        return list;
    }

    public EditorLayouts getEditorLayouts() {
        return this.editorLayouts;
    }

    public List<DetailsPageLayout> getDetailsPageLayoutList() {
        return this.detailsPageLayoutList;
    }

    public DetailsPageLayout getDetailsPageLayout(String id) {
        return this.detailsPageLayoutMap.get(id);
    }

    public DetailsPageLayout getDetailsPageLayout(int index) {
        return this.getDetailsPageLayoutList().get(index);
    }

    public List<Filters> getFiltersList() {
        return this.filtersList;
    }

    public Filters getFilters(String id) {
        return this.filtersMap.get(id);
    }

    public Filters getFilters(int index) {
        return this.getFiltersList().get(index);
    }

    public List<HistoryViewer> getHistoryViewerList() {
        return this.historyViewerList;
    }

    public HistoryViewer getHistoryViewer(String id) {
        return this.historyViewerMap.get(id);
    }

    public HistoryViewer getHistoryViewer(int index) {
        return this.getHistoryViewerList().get(index);
    }

    public DocumentGeneration getDocumentGeneration() {
        return this.documentGeneration;
    }

    public List<Exporter> getExporterList() {
        return this.exporterList;
    }

    public Exporter getExporter(String id) {
        return this.exporterMap.get(id);
    }

    public Exporter getExporter(int index) {
        return this.getExporterList().get(index);
    }

    public List<Importer> getImporterList() {
        return this.importerList;
    }

    public Importer getImporter(String id) {
        return this.importerMap.get(id);
    }

    public Importer getImporter(int index) {
        return this.getImporterList().get(index);
    }

    public List<HelpContribution> getHelpContributionList() {
        return this.helpContributionList;
    }

    public HelpContribution getHelpContribution(String id) {
        return this.helpContributionMap.get(id);
    }

    public HelpContribution getHelpContribution(int index) {
        return this.getHelpContributionList().get(index);
    }

    public void setEditorLayouts(EditorLayouts editorLayouts_) {
        this.editorLayouts = editorLayouts_;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.add(this.perspective);
        children.addAll(this.getViewList());
        children.addAll(this.getDetailsPageLayoutList());
        children.addAll(this.getFiltersList());
        children.addAll(this.getHistoryViewerList());
        children.add(this.documentGeneration);
        children.addAll(this.getExporterList());
        children.addAll(this.getImporterList());
        children.addAll(this.getHelpContributionList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "ModuleUISpecification";
    }
}

