/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.DocumentGenerationInterface;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.GraphicalRepresentation;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.HelpContribution;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LegacyInterface;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LegacyInterfaceForLinkDataProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LegacyInterfaceForObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LegacyInterfaceRequiredPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleSpecificFacade
extends AbstractModuleSpecificationPart
implements DocumentGenerationInterface {
    private final String dataProviderKey;
    private final String crossModuleLinksDataProviderKey;
    private final Map<String, GraphicalRepresentation> graphicalRepresentationMap;
    private final List<GraphicalRepresentation> graphicalRepresentationList;
    private final Map<String, HelpContribution> helpContributionMap;
    private final List<HelpContribution> helpContributionList;
    private final LegacyInterface legacyInterface;
    private final Map<String, LegacyInterfaceForObjectType> legacyInterfaceForObjectTypeMap;
    private final List<LegacyInterfaceForObjectType> legacyInterfaceForObjectTypeList;
    private final LegacyInterfaceForLinkDataProvider legacyInterfaceForLinkDataProvider;
    private final Map<String, LegacyInterfaceRequiredPlugin> legacyInterfaceRequiredPluginMap;
    private final List<LegacyInterfaceRequiredPlugin> legacyInterfaceRequiredPluginList;

    public ModuleSpecificFacade(String dataProviderKey, String crossModuleLinksDataProviderKey, List<GraphicalRepresentation> graphicalRepresentationList, List<HelpContribution> helpContributionList, LegacyInterface legacyInterface, List<LegacyInterfaceForObjectType> legacyInterfaceForObjectTypeList, LegacyInterfaceForLinkDataProvider legacyInterfaceForLinkDataProvider, List<LegacyInterfaceRequiredPlugin> legacyInterfaceRequiredPluginList) {
        this.dataProviderKey = dataProviderKey;
        this.crossModuleLinksDataProviderKey = crossModuleLinksDataProviderKey;
        this.graphicalRepresentationMap = new HashMap<String, GraphicalRepresentation>();
        this.graphicalRepresentationList = new ArrayList<GraphicalRepresentation>();
        int graphicalRepresentationListCounter = 1;
        for (GraphicalRepresentation part : graphicalRepresentationList) {
            part.setIndex(graphicalRepresentationListCounter);
            String partID = part.getID();
            this.graphicalRepresentationMap.put(partID, part);
            this.graphicalRepresentationList.add(part);
            ++graphicalRepresentationListCounter;
        }
        this.helpContributionMap = new HashMap<String, HelpContribution>();
        this.helpContributionList = new ArrayList<HelpContribution>();
        int helpContributionListCounter = 1;
        for (HelpContribution part : helpContributionList) {
            part.setIndex(helpContributionListCounter);
            String partID = part.getID();
            this.helpContributionMap.put(partID, part);
            this.helpContributionList.add(part);
            ++helpContributionListCounter;
        }
        this.legacyInterface = legacyInterface;
        this.legacyInterfaceForObjectTypeMap = new HashMap<String, LegacyInterfaceForObjectType>();
        this.legacyInterfaceForObjectTypeList = new ArrayList<LegacyInterfaceForObjectType>();
        int legacyInterfaceForObjectTypeListCounter = 1;
        for (LegacyInterfaceForObjectType part : legacyInterfaceForObjectTypeList) {
            part.setIndex(legacyInterfaceForObjectTypeListCounter);
            String partID = part.getID();
            this.legacyInterfaceForObjectTypeMap.put(partID, part);
            this.legacyInterfaceForObjectTypeList.add(part);
            ++legacyInterfaceForObjectTypeListCounter;
        }
        this.legacyInterfaceForLinkDataProvider = legacyInterfaceForLinkDataProvider;
        this.legacyInterfaceRequiredPluginMap = new HashMap<String, LegacyInterfaceRequiredPlugin>();
        this.legacyInterfaceRequiredPluginList = new ArrayList<LegacyInterfaceRequiredPlugin>();
        int legacyInterfaceRequiredPluginListCounter = 1;
        for (LegacyInterfaceRequiredPlugin part : legacyInterfaceRequiredPluginList) {
            part.setIndex(legacyInterfaceRequiredPluginListCounter);
            String partID = part.getID();
            this.legacyInterfaceRequiredPluginMap.put(partID, part);
            this.legacyInterfaceRequiredPluginList.add(part);
            ++legacyInterfaceRequiredPluginListCounter;
        }
    }

    public String getDataProviderKey() {
        return this.dataProviderKey;
    }

    public String getCrossModuleLinksDataProviderKey() {
        return this.crossModuleLinksDataProviderKey;
    }

    public List<GraphicalRepresentation> getGraphicalRepresentationList() {
        return this.graphicalRepresentationList;
    }

    public GraphicalRepresentation getGraphicalRepresentation(String id) {
        return this.graphicalRepresentationMap.get(id);
    }

    public GraphicalRepresentation getGraphicalRepresentation(int index) {
        return this.getGraphicalRepresentationList().get(index);
    }

    public List<HelpContribution> getHelpContributionList() {
        return this.helpContributionList;
    }

    public HelpContribution getHelpContribution(String id) {
        return this.helpContributionMap.get(id);
    }

    public HelpContribution getHelpContribution(int index) {
        return this.getHelpContributionList().get(index);
    }

    public LegacyInterface getLegacyInterface() {
        return this.legacyInterface;
    }

    public List<LegacyInterfaceForObjectType> getLegacyInterfaceForObjectTypeList() {
        return this.legacyInterfaceForObjectTypeList;
    }

    public LegacyInterfaceForObjectType getLegacyInterfaceForObjectType(String id) {
        return this.legacyInterfaceForObjectTypeMap.get(id);
    }

    public LegacyInterfaceForObjectType getLegacyInterfaceForObjectType(int index) {
        return this.getLegacyInterfaceForObjectTypeList().get(index);
    }

    public LegacyInterfaceForLinkDataProvider getLegacyInterfaceForLinkDataProvider() {
        return this.legacyInterfaceForLinkDataProvider;
    }

    public List<LegacyInterfaceRequiredPlugin> getLegacyInterfaceRequiredPluginList() {
        return this.legacyInterfaceRequiredPluginList;
    }

    public LegacyInterfaceRequiredPlugin getLegacyInterfaceRequiredPlugin(String id) {
        return this.legacyInterfaceRequiredPluginMap.get(id);
    }

    public LegacyInterfaceRequiredPlugin getLegacyInterfaceRequiredPlugin(int index) {
        return this.getLegacyInterfaceRequiredPluginList().get(index);
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getGraphicalRepresentationList());
        children.addAll(this.getHelpContributionList());
        children.add(this.legacyInterface);
        children.addAll(this.getLegacyInterfaceForObjectTypeList());
        children.add(this.legacyInterfaceForLinkDataProvider);
        children.addAll(this.getLegacyInterfaceRequiredPluginList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "ModuleSpecificFacade";
    }
}

