/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.relationgraph;

import com.arcway.cockpit.frame.client.lib.relationviews.dependencynet.IDependencyModel;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;
import java.util.Collections;

public class RelationGraphDependencyModel
implements IDependencyModel {
    private final String moduleID;
    private final String linkTypeID;
    private final String linkStartDataTypeID;
    private final String linkEndDataTypeID;

    public RelationGraphDependencyModel(String moduleID, String linkTypeID, String linkStartDataTypeID, String linkEndDataTypeID) {
        this.moduleID = moduleID;
        this.linkTypeID = linkTypeID;
        this.linkStartDataTypeID = linkStartDataTypeID;
        this.linkEndDataTypeID = linkEndDataTypeID;
    }

    public Collection<? extends ICockpitProjectData> getDependencyPredecessors(ICockpitProjectData item) {
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        if (modelController != null) {
            if (item.getTypeID().equals(this.linkEndDataTypeID)) {
                return modelController.getModuleData(item.getUID(), this.linkTypeID);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public Collection<? extends ICockpitProjectData> getDependencySuccessors(ICockpitProjectData item) {
        IModelController modelController = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(item.getProjectUID());
        if (modelController != null) {
            if (item.getTypeID().equals(this.linkStartDataTypeID)) {
                return modelController.getLinkableObjects((IModuleData)item, this.linkTypeID);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

