/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.dataview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewHierarchy;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.gui.actions.ActionAdministrateAttributeObjects;
import com.arcway.cockpit.genericmodule.client.gui.dataview.GMDataViewProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Column;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ColumnContent;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.TableTreeDataView;
import com.arcway.cockpit.genericmodule.client.messages.GMUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataView;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewHierarchy;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewProvider;
import de.plans.psc.shared.message.IPermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class DataView
extends StandardTreeDataView {
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private TableTreeDataView tableTreeDataViewSpec;
    private Set<String> visibleObjectTypes;
    private GMDataViewProvider dataViewProvider;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.tableTreeDataViewSpec = (TableTreeDataView)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        this.visibleObjectTypes = DataView.getVisibleObjectTypes(this.tableTreeDataViewSpec, this.moduleID);
    }

    protected void createPermanentParts() {
        super.createPermanentParts();
        for (ActionAdministrateAttributeObjects action : this.dataViewProvider.getAttributeObjectAdministrationActions()) {
            this.getUIPropertyChangesListenerManager().registerPropertyChangesListener((IPropertyChangesListener)action, IPermission.class);
            this.getUIPropertyChangesListenerManager().registerPropertyChangesListener((IPropertyChangesListener)action, IRoleAndStakeholder.class);
        }
    }

    public void dispose() {
        for (ActionAdministrateAttributeObjects action : this.dataViewProvider.getAttributeObjectAdministrationActions()) {
            this.getUIPropertyChangesListenerManager().deregisterPropertyChangesListener((IPropertyChangesListener)action);
        }
        super.dispose();
    }

    protected StandardTreeDataViewProvider createStandardTreeDataViewProvider() {
        this.dataViewProvider = new GMDataViewProvider(this, this.moduleID, this.moduleSpecification, this.tableTreeDataViewSpec);
        return this.dataViewProvider;
    }

    public ITreeDataViewHierarchy createTreeDataViewHierarchy() {
        return new StandardTreeDataViewHierarchy((IModelControllerProvider)GenericModulePlugin.getDefault().getProjectManager(this.moduleID), this.dataViewProvider.getDataTypesHelper(), GMUIDataTypesHelper.getDefault(this.moduleID), this.visibleObjectTypes);
    }

    protected String getHelpContextID() {
        return String.valueOf(GenericModulePlugin.getDefault().getPluginID()) + "." + this.moduleID + ".module_data_view_index";
    }

    public Set<String> getVisibleObjectTypes() {
        return Collections.unmodifiableSet(this.visibleObjectTypes);
    }

    public static Set<String> getVisibleObjectTypes(TableTreeDataView tableTreeDataViewSpec, String moduleID) {
        HashSet<String> visibleObjectTypes = new HashSet<String>();
        for (Column column : tableTreeDataViewSpec.getColumnProviderListOfType(Column.class)) {
            for (ColumnContent columnContent : column.getColumnContentList()) {
                visibleObjectTypes.add(ClientDataFactory_TypesHelper.getDataTypeID(moduleID, columnContent.getID()));
            }
        }
        return visibleObjectTypes;
    }
}

