/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.permissions.LinkContributionPermissionTemplate;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionConstants;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.java.collectionmaps.MapMap;
import de.plans.lib.resources.IIconResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class PermissionTemplateProvider
extends AbstractPermissionTemplateProvider {
    private static final String PERMISSION_DIALOG_TAB_DESCRIPTION_PREFIX = Messages.getString("Permissions.TabDescription.Prefix");
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private PermissionDataCache currentCacheContents = null;

    public PermissionTemplateProvider(String moduleID_, ModuleSpecification moduleSpecification_) {
        super(GMDataTypesHelper.getDefault(moduleID_));
        this.moduleID = moduleID_;
        this.moduleSpecification = moduleSpecification_;
    }

    private PermissionDataCache getFilledPermissionDataCache(IModuleProjectAgent projectAgent) {
        if (this.currentCacheContents == null || !this.currentCacheContents.projectUID.equals(projectAgent.getProjectUID())) {
            this.currentCacheContents = this.computePermissionDataCacheContent(projectAgent);
        }
        return this.currentCacheContents;
    }

    public void clearPermissionTemplatesCache() {
        this.currentCacheContents = null;
    }

    private PermissionDataCache computePermissionDataCacheContent(IModuleProjectAgent projectAgent) {
        GMLinkTypeHelper_Shared gmLinkTypeHelper_Shared = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        ArrayList<ModulePermissionTemplate> allPermissionTemplates = new ArrayList<ModulePermissionTemplate>();
        HashSet<String> allPermissionOperandTypes = new HashSet<String>();
        HashMap<ModulePermissionTemplate, IPermissionTemplateCategory> map_template_category = new HashMap<ModulePermissionTemplate, IPermissionTemplateCategory>();
        boolean hasGeneralPermissions = false;
        boolean hasTreePermissions = false;
        for (ObjectType objectType : this.moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
            if (ClientDataFactory_TypesHelper.isHierarchyType(objectType)) {
                ModuleDataTypeDescriptionForFrame dataTypeDescriptionForFrame = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectType).getModuleDataTypeDescriptionForFrame();
                IPermissionTemplateCategory permissionTemplateCategory = this.getPermissionCategory(objectType);
                HashSet<String> permissionOperandTypes_Create = new HashSet<String>();
                HashSet<String> permissionOperandTypes_Edit = new HashSet<String>();
                this.retrievePermissionOperandTypesForObjectType(objectType, permissionOperandTypes_Edit, permissionOperandTypes_Create, new HashSet<String>(), false);
                for (String permissionOperandType : permissionOperandTypes_Create) {
                    allPermissionOperandTypes.add(permissionOperandType);
                    ModulePermissionTemplate template = new ModulePermissionTemplate(PermissionConstants.getOperationType_CreateChild(objectType.getObjectTypeID()), Arrays.asList(new PermissionOperationDescription("Create", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()))), permissionOperandType, (IPermissionOperand)(permissionOperandType.equals("hierarchyroot") ? PermissionConstants.TREE_ROOT_NODE : null));
                    allPermissionTemplates.add(template);
                    map_template_category.put(template, permissionTemplateCategory);
                    hasTreePermissions = true;
                }
                for (String permissionOperandType : permissionOperandTypes_Edit) {
                    allPermissionOperandTypes.add(permissionOperandType);
                    ModulePermissionTemplate editItemTemplate = new ModulePermissionTemplate(PermissionConstants.getOperationType_EditItem(objectType.getObjectTypeID()), Arrays.asList(new PermissionOperationDescription("Modify", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID())), new PermissionOperationDescription("Delete", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()))), permissionOperandType, (IPermissionOperand)(permissionOperandType.equals("hierarchyroot") ? PermissionConstants.TREE_ROOT_NODE : null));
                    allPermissionTemplates.add(editItemTemplate);
                    map_template_category.put(editItemTemplate, permissionTemplateCategory);
                    for (ModuleDataRelationType mdRelationType : this.moduleSpecification.getModuleDataSpecification().getRelationTypeListOfType(ModuleDataRelationType.class)) {
                        List<MDRelationParticipant> mdRelationParticipantList = mdRelationType.getMDRelationParticipantList();
                        for (MDRelationParticipant mdRelationParticipant : mdRelationParticipantList) {
                            if (!objectType.getID().equals(mdRelationParticipant.getObjectTypeIDOfParticipant())) continue;
                            int relationContributionIndex = mdRelationParticipant.getIndex() == 1 ? 0 : 1;
                            String relationContributionId = Integer.toString(relationContributionIndex);
                            LinkContributionPermissionTemplate linktemplate = new LinkContributionPermissionTemplate(mdRelationType.getRelationTypeID(), gmLinkTypeHelper_Shared.getRelationLinkTypeID(mdRelationType.getRelationTypeID()), relationContributionId, permissionOperandType, (IPermissionOperand)(permissionOperandType.equals("hierarchyroot") ? PermissionConstants.TREE_ROOT_NODE : null), (CockpitPermissionTemplate)editItemTemplate);
                            allPermissionTemplates.add(linktemplate);
                            map_template_category.put(linktemplate, permissionTemplateCategory);
                        }
                    }
                    ModulePermissionTemplate template = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)dataTypeDescriptionForFrame, (String)permissionOperandType, (boolean)true, (IPermissionOperand)(permissionOperandType.equals("hierarchyroot") ? PermissionConstants.TREE_ROOT_NODE : null)), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", dataTypeDescriptionForFrame.getCockpitDataTypeID())));
                    allPermissionTemplates.add(template);
                    map_template_category.put(template, permissionTemplateCategory);
                    Collection templates = PermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)dataTypeDescriptionForFrame, (String)permissionOperandType);
                    allPermissionTemplates.addAll(templates);
                    for (ModulePermissionTemplate attributeTemplate : templates) {
                        map_template_category.put(attributeTemplate, permissionTemplateCategory);
                    }
                    hasTreePermissions = true;
                }
                continue;
            }
            if (objectType.getPermissionManagement() == null || !objectType.getPermissionManagement().isEnabledViaOwnObjects() && !objectType.getPermissionManagement().isEnabledViaAncestorObjects()) continue;
            ModulePermissionTemplate template = new ModulePermissionTemplate(PermissionConstants.getOperationType_AdministrateType(objectType.getObjectTypeID()), Arrays.asList(new PermissionOperationDescription("Create", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID())), new PermissionOperationDescription("Modify", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID())), new PermissionOperationDescription("Delete", ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()))), PermissionConstants.GENERAL_ROOT_NODE.getPermissionOperandType(), PermissionConstants.GENERAL_ROOT_NODE);
            allPermissionTemplates.add(template);
            map_template_category.put(template, null);
            hasGeneralPermissions = true;
        }
        return new PermissionDataCache(projectAgent.getProjectUID(), allPermissionTemplates, allPermissionOperandTypes, map_template_category, hasGeneralPermissions, hasTreePermissions);
    }

    private void retrievePermissionOperandTypesForObjectType(ObjectType objectType, Set<String> permissionOperandTypes_Edit, Set<String> permissionOperandTypes_Create, Set<String> consideredTypes, boolean recursiveCall) {
        String parentObjectTypeID;
        consideredTypes.add(objectType.getObjectTypeID());
        if (objectType.getPermissionManagement() != null && objectType.getPermissionManagement().isEnabledViaOwnObjects()) {
            permissionOperandTypes_Edit.add(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()));
            if (recursiveCall) {
                permissionOperandTypes_Create.add(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()));
            } else {
                for (ParentType parentType : objectType.getParentTypeList()) {
                    parentObjectTypeID = parentType.getParentObjectTypeID();
                    if (parentObjectTypeID.equals("hierarchyroot")) {
                        permissionOperandTypes_Create.add("hierarchyroot");
                        continue;
                    }
                    if (parentObjectTypeID.equals("noparent")) continue;
                    permissionOperandTypes_Create.add(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, parentObjectTypeID));
                }
            }
        }
        if (objectType.getPermissionManagement() != null && objectType.getPermissionManagement().isEnabledViaAncestorObjects()) {
            for (ParentType parentType : objectType.getParentTypeList()) {
                parentObjectTypeID = parentType.getParentObjectTypeID();
                if (parentObjectTypeID.equals("hierarchyroot")) {
                    permissionOperandTypes_Edit.add("hierarchyroot");
                    permissionOperandTypes_Create.add("hierarchyroot");
                    continue;
                }
                if (parentObjectTypeID.equals("noparent") || consideredTypes.contains(parentObjectTypeID)) continue;
                ObjectType parentObjectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(parentObjectTypeID);
                this.retrievePermissionOperandTypesForObjectType(parentObjectType, permissionOperandTypes_Edit, permissionOperandTypes_Create, consideredTypes, true);
            }
        }
    }

    public String getName() {
        return new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault());
    }

    public String getDescription() {
        return String.valueOf(PERMISSION_DIALOG_TAB_DESCRIPTION_PREFIX) + new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault());
    }

    public boolean areAnyPermissionsDefined(IModuleProjectAgent projectAgent) {
        PermissionDataCache cache = this.getFilledPermissionDataCache(projectAgent);
        return cache.hasGeneralPermissions || cache.hasTreePermissions;
    }

    public Collection<ModulePermissionTemplate> getTemplates(IFrameProjectAgent projectAgent) {
        PermissionDataCache cache = this.getFilledPermissionDataCache((IModuleProjectAgent)projectAgent);
        return cache.allPermissionTemplates;
    }

    public boolean isTemplateDefined(IModuleProjectAgent projectAgent, IPermissionOperand permissionOperand, String operationTypeID, String operationTypeID2) {
        PermissionDataCache cache = this.getFilledPermissionDataCache(projectAgent);
        Collection templates = (Collection)cache.allPermissionTemplates_index_OperandType_Operation.get((Object)permissionOperand.getPermissionOperandType(), (Object)operationTypeID);
        if (templates != null) {
            for (ModulePermissionTemplate template : templates) {
                if ((template.getOperation2() != null || operationTypeID2 != null) && (template.getOperation2() == null || !template.getOperation2().equals(operationTypeID2))) continue;
                return true;
            }
        }
        return false;
    }

    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplateLabelProvider(this.moduleID, this.moduleSpecification, projectAgent);
    }

    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return this;
    }

    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new TreeContentProvider(ModuleIdentification.getFullModuleID(this.moduleID), projectAgent);
    }

    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new TreeLabelProvider(this.moduleID, this.moduleSpecification);
    }

    public ViewerSorter getTreeSorter() {
        return null;
    }

    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        PermissionDataCache cache = this.getFilledPermissionDataCache((IModuleProjectAgent)projectAgent);
        return cache.map_template_category.get(template);
    }

    private IPermissionTemplateCategory getPermissionCategory(final ObjectType objectType) {
        final GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectType);
        return new IPermissionTemplateCategory(){

            public String getID() {
                return objectType.getObjectTypeID();
            }

            public String getDisplayName() {
                return typeDescription.getTypeName(Locale.getDefault());
            }
        };
    }

    private static class PermissionDataCache {
        public final String projectUID;
        public final List<ModulePermissionTemplate> allPermissionTemplates;
        public final MapMap<String, String, Collection<ModulePermissionTemplate>> allPermissionTemplates_index_OperandType_Operation;
        public final Set<String> allPermissionOperandTypes;
        public final Map<ModulePermissionTemplate, IPermissionTemplateCategory> map_template_category;
        public final boolean hasGeneralPermissions;
        public final boolean hasTreePermissions;

        public PermissionDataCache(String projectUID, List<ModulePermissionTemplate> allPermissionTemplates, Set<String> allPermissionOperandTypes, Map<ModulePermissionTemplate, IPermissionTemplateCategory> map_template_category, boolean hasGeneralPermissions, boolean hasTreePermissions) {
            this.projectUID = projectUID;
            this.allPermissionTemplates = Collections.unmodifiableList(allPermissionTemplates);
            this.allPermissionTemplates_index_OperandType_Operation = new MapMap();
            for (ModulePermissionTemplate template : allPermissionTemplates) {
                ArrayList<ModulePermissionTemplate> templates = (ArrayList<ModulePermissionTemplate>)this.allPermissionTemplates_index_OperandType_Operation.get((Object)template.getOperandType(), (Object)template.getOperation());
                if (templates == null) {
                    templates = new ArrayList<ModulePermissionTemplate>();
                    this.allPermissionTemplates_index_OperandType_Operation.put((Object)template.getOperandType(), (Object)template.getOperation(), templates);
                }
                templates.add(template);
            }
            this.allPermissionOperandTypes = Collections.unmodifiableSet(allPermissionOperandTypes);
            this.map_template_category = Collections.unmodifiableMap(map_template_category);
            this.hasGeneralPermissions = hasGeneralPermissions;
            this.hasTreePermissions = hasTreePermissions;
        }
    }

    private static class TemplateLabelProvider
    extends AbstractPermissionTemplateProvider.AbstractTemplateLabelProvider {
        private final String moduleID;
        private final ModuleSpecification moduleSpecification;

        public TemplateLabelProvider(String p_moduleID, ModuleSpecification p_moduleSpecification, IFrameProjectAgent projectAgent) {
            super(projectAgent, GMDataTypesHelper.getDefault(p_moduleID));
            this.moduleID = p_moduleID;
            this.moduleSpecification = p_moduleSpecification;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (!(element instanceof ModulePermissionTemplate)) {
                return null;
            }
            ModulePermissionTemplate template = (ModulePermissionTemplate)element;
            if (template.getBaseTemplate() instanceof AllAttributeModificationPermissionTemplate) {
                return ((AllAttributeModificationPermissionTemplate)template.getBaseTemplate()).getPermissionName();
            }
            if (template.getBaseTemplate() instanceof AttributeModificationPermissionTemplate) {
                AttributeModificationPermissionTemplate attrTemplate = (AttributeModificationPermissionTemplate)template.getBaseTemplate();
                String label = this.getAttributePermissionTemplateLabel(attrTemplate);
                if (label != null) {
                    return label;
                }
                String objectTypeID = ClientDataFactory_TypesHelper.getShortTypeID(attrTemplate.getCockpitDataTypeID());
                ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
                GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectType);
                String objectTypeName = typeDescription.getTypeName(Locale.getDefault());
                String attributeID = attrTemplate.getAttributeTypeUID();
                Attribute attribute = objectType.getAttribute(attributeID);
                String attributeName = attribute instanceof ChildrenIDFormatAttribute ? Messages.getString("AttributeName.IDFormat") : typeDescription.getAttributeName(attributeID);
                return "\"" + attributeName + "\" " + Messages.getString("PermissionTemplateProvider.AttributePermissionInfix") + " " + objectTypeName;
            }
            if (template instanceof LinkContributionPermissionTemplate) {
                LinkContributionPermissionTemplate linkContributionPermissionTemplate = (LinkContributionPermissionTemplate)template;
                RelationType relationType = this.moduleSpecification.getModuleDataSpecification().getRelationType(linkContributionPermissionTemplate.getRelationTypeID_short());
                assert (relationType instanceof ModuleDataRelationType);
                ModuleDataRelationType moduleDataRelationType = (ModuleDataRelationType)relationType;
                String relationTypeNameLocalisationCode = moduleDataRelationType.getRelationTypeName();
                String relationTypeLabel = new LabelProvider(relationTypeNameLocalisationCode).getLabel(Locale.getDefault());
                MDRelationParticipant mdRelationParticipant = moduleDataRelationType.getMDRelationParticipant(Integer.valueOf(linkContributionPermissionTemplate.getRelationParticipantID()));
                String participantRoleNameLocalisationCode = mdRelationParticipant.getParticipantRoleName();
                String participantRoleLabel = new LabelProvider(participantRoleNameLocalisationCode).getLabel(Locale.getDefault());
                String objectTypeID = mdRelationParticipant.getObjectTypeIDOfParticipant();
                GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID));
                String objectTypeLabel = typeDescription.getTypeName(Locale.getDefault());
                String label = NLS.bind((String)Messages.getString("PermissionTemplateProvider.OperationAdministrateLinkContribution"), (Object[])new String[]{objectTypeLabel, relationTypeLabel, participantRoleLabel});
                return label;
            }
            String label = "";
            String operationID = template.getOperation();
            if (PermissionConstants.isOperationType_CreateChild(operationID)) {
                label = String.valueOf(label) + Messages.getString("PermissionTemplateProvider.OperationCreateChild");
            } else if (PermissionConstants.isOperationType_EditItem(operationID)) {
                label = String.valueOf(label) + Messages.getString("PermissionTemplateProvider.OperationEditItem");
            } else if (PermissionConstants.isOperationType_AdministrateType(operationID)) {
                label = String.valueOf(label) + Messages.getString("PermissionTemplateProvider.AdministrateType");
            } else if (PermissionConstants.isOperationType_AdministrateRelationContribution(operationID)) {
                assert (template instanceof LinkContributionPermissionTemplate);
                assert (false);
            }
            String objectTypeID = PermissionConstants.getObjectTypeIDForOperationType(operationID);
            GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID));
            label = String.valueOf(label) + " " + typeDescription.getTypeName(Locale.getDefault());
            return label;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TreeContentProvider
    extends AbstractPermissionTemplateProvider.AbstractTreeContentProvider {
        public TreeContentProvider(String p_fullModuleID, IModuleProjectAgent p_projectAgent) {
            super(p_projectAgent, p_fullModuleID);
        }

        private PermissionDataCache getFilledPermissionDataCache() {
            return PermissionTemplateProvider.this.getFilledPermissionDataCache(this.getProjectAgent());
        }

        public IPermissionOperand[] getElements(Object input) {
            IPermissionOperand[] permissionOperands = this.getFilledPermissionDataCache().hasGeneralPermissions ? (this.getFilledPermissionDataCache().hasTreePermissions ? new IPermissionOperand[]{PermissionConstants.GENERAL_ROOT_NODE, PermissionConstants.TREE_ROOT_NODE} : new IPermissionOperand[]{PermissionConstants.GENERAL_ROOT_NODE}) : (this.getFilledPermissionDataCache().hasTreePermissions ? new IPermissionOperand[]{PermissionConstants.TREE_ROOT_NODE} : new IPermissionOperand[]{});
            return permissionOperands;
        }

        public boolean hasChildren(IPermissionOperand element) {
            boolean hasChildren;
            if (element == PermissionConstants.GENERAL_ROOT_NODE) {
                hasChildren = false;
            } else if (element == PermissionConstants.TREE_ROOT_NODE) {
                Collection rootItems = this.getModelController().getAllRootItems();
                this.filterItemsForPermissionOperands(rootItems);
                hasChildren = !rootItems.isEmpty();
            } else if (element instanceof GenericModuleData) {
                Collection childItems = this.getModelController().getChildren((IModuleData)((GenericModuleData)element));
                this.filterItemsForPermissionOperands(childItems);
                hasChildren = !childItems.isEmpty();
            } else {
                hasChildren = false;
            }
            return hasChildren;
        }

        public IPermissionOperand[] getChildren(IPermissionOperand element) {
            Collection<Object> children;
            if (element == PermissionConstants.GENERAL_ROOT_NODE) {
                children = Collections.emptySet();
            } else if (element == PermissionConstants.TREE_ROOT_NODE) {
                Collection rootItems = this.getModelController().getAllRootItems();
                this.filterItemsForPermissionOperands(rootItems);
                children = rootItems;
            } else if (element instanceof GenericModuleData) {
                Collection childItems = this.getModelController().getChildren((IModuleData)((GenericModuleData)element));
                this.filterItemsForPermissionOperands(childItems);
                children = childItems;
            } else {
                children = Collections.emptySet();
            }
            IPermissionOperand[] childrenArray = new IPermissionOperand[children.size()];
            children.toArray(childrenArray);
            return childrenArray;
        }

        public IPermissionOperand getParent(IPermissionOperand element) {
            IPermissionOperand parent;
            if (element == PermissionConstants.GENERAL_ROOT_NODE || element == PermissionConstants.TREE_ROOT_NODE) {
                parent = null;
            } else if (element instanceof GenericModuleData) {
                parent = (IPermissionOperand)this.getModelController().getParent((IModuleData)((GenericModuleData)element));
                if (parent == null) {
                    parent = PermissionConstants.TREE_ROOT_NODE;
                }
            } else {
                parent = null;
            }
            return parent;
        }

        private void filterItemsForPermissionOperands(Collection<IModuleData> items) {
            Iterator<IModuleData> itemIterator = items.iterator();
            while (itemIterator.hasNext()) {
                IModuleData item = itemIterator.next();
                if (this.getFilledPermissionDataCache().allPermissionOperandTypes.contains(item.getTypeID())) continue;
                Collection children = this.getModelController().getChildren(item);
                this.filterItemsForPermissionOperands(children);
                if (!children.isEmpty()) continue;
                itemIterator.remove();
            }
        }

        public IPermissionOperand getTreeRootNode() {
            if (this.getFilledPermissionDataCache().hasTreePermissions) {
                return PermissionConstants.TREE_ROOT_NODE;
            }
            return null;
        }
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private final String moduleID;
        private final ModuleSpecification moduleSpecification;

        public TreeLabelProvider(String p_moduleID, ModuleSpecification p_moduleSpecification) {
            this.moduleID = p_moduleID;
            this.moduleSpecification = p_moduleSpecification;
        }

        public Image getImage(Object element) {
            if (element == PermissionConstants.GENERAL_ROOT_NODE) {
                ImageDescriptor imageDescriptor = GenericModulePlugin.getImageDescriptor("categories.gif");
                return GenericModulePlugin.getDefault().getImageDescriptorRegistry().get(imageDescriptor);
            }
            if (element == PermissionConstants.TREE_ROOT_NODE) {
                return new IconResource(this.moduleID, this.moduleSpecification.getModuleIcon()).getImage();
            }
            if (element instanceof GenericModuleData) {
                IIconResource icon = ((GenericModuleData)((Object)element)).getTypeDescription().getTypeIcon();
                return icon != null ? icon.getImage() : null;
            }
            return null;
        }

        public String getText(Object element) {
            if (element == PermissionConstants.GENERAL_ROOT_NODE) {
                return PermissionConstants.GENERAL_ROOT_NODE.getPermissionOperandDisplayName();
            }
            if (element == PermissionConstants.TREE_ROOT_NODE) {
                return PermissionConstants.TREE_ROOT_NODE.getPermissionOperandDisplayName();
            }
            if (element instanceof GenericModuleData) {
                return ((GenericModuleData)((Object)element)).getDisplayRepresentation();
            }
            return "[no label defined]";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

