/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.permissions;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;

public class PermissionConstants {
    private static final String OPERATIONTYPE_CREATECHILD_PREFIX = "Create-Child-Of-Type-";
    private static final String OPERATIONTYPE_EDITITEM_PREFIX = "Edit-Item-Of-Type-";
    private static final String OPERATIONTYPE_ADMINISTRATETYPE_PREFIX = "Administrate-Type-";
    private static final String OPERATIONTYPE_ADMINISTRATERELATIONCONTRIBUTION_PREFIX = "Administrate-Relation-Contribution-";
    public static final IPermissionOperand TREE_ROOT_NODE = new IPermissionOperand(){

        public String getPermissionOperandUID() {
            return "TreeRootNode-UID";
        }

        public String getPermissionOperandType() {
            return "hierarchyroot";
        }

        public String getPermissionOperandDisplayName() {
            return Messages.getString("PermissionConstants.TreeRootNode.Label");
        }
    };
    public static final IPermissionOperand GENERAL_ROOT_NODE = new IPermissionOperand(){

        public String getPermissionOperandUID() {
            return "GeneralRootNode-UID";
        }

        public String getPermissionOperandType() {
            return "GeneralRootNode-OperandTypeID";
        }

        public String getPermissionOperandDisplayName() {
            return Messages.getString("PermissionConstants.GeneralRootNode.Label");
        }
    };

    public static String getOperationType_CreateChild(String childObjectTypeID) {
        return OPERATIONTYPE_CREATECHILD_PREFIX + childObjectTypeID;
    }

    public static String getOperationType_EditItem(String objectTypeID) {
        return OPERATIONTYPE_EDITITEM_PREFIX + objectTypeID;
    }

    public static String getOperationType_AdministrateType(String objectTypeID) {
        return OPERATIONTYPE_ADMINISTRATETYPE_PREFIX + objectTypeID;
    }

    public static boolean isOperationType_CreateChild(String operationTypeID) {
        return operationTypeID.startsWith(OPERATIONTYPE_CREATECHILD_PREFIX);
    }

    public static boolean isOperationType_EditItem(String operationTypeID) {
        return operationTypeID.startsWith(OPERATIONTYPE_EDITITEM_PREFIX);
    }

    public static boolean isOperationType_AdministrateType(String operationTypeID) {
        return operationTypeID.startsWith(OPERATIONTYPE_ADMINISTRATETYPE_PREFIX);
    }

    public static boolean isOperationType_AdministrateRelationContribution(String operationTypeID) {
        return operationTypeID.startsWith(OPERATIONTYPE_ADMINISTRATERELATIONCONTRIBUTION_PREFIX);
    }

    public static String getObjectTypeIDForOperationType(String operationTypeID) {
        if (PermissionConstants.isOperationType_CreateChild(operationTypeID)) {
            return operationTypeID.substring(OPERATIONTYPE_CREATECHILD_PREFIX.length());
        }
        if (PermissionConstants.isOperationType_EditItem(operationTypeID)) {
            return operationTypeID.substring(OPERATIONTYPE_EDITITEM_PREFIX.length());
        }
        if (PermissionConstants.isOperationType_AdministrateType(operationTypeID)) {
            return operationTypeID.substring(OPERATIONTYPE_ADMINISTRATETYPE_PREFIX.length());
        }
        return null;
    }

    public static String getOperationType_AdministrateRelationContribution(String relationTypeID, String relationParticipantID) {
        return OPERATIONTYPE_ADMINISTRATERELATIONCONTRIBUTION_PREFIX + relationTypeID + "--" + relationParticipantID;
    }
}

