/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleUserInterface;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper;
import com.arcway.cockpit.genericmodule.client.core.ModelController;
import com.arcway.cockpit.genericmodule.client.core.ModuleFacade;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataFacade;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataManager;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ExportDataProvider;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionTemplateProvider;
import com.arcway.cockpit.genericmodule.client.gui.ModuleUserInterface;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.messages.GMUIDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.platformadapter.GMLicenseTypeProvider;
import com.arcway.cockpit.genericmodule.client.platformadapter.GenericModulePlatformAdapter_CoreModule;
import com.arcway.cockpit.genericmodule.client.platformadapter.GenericModulePlatformAdapter_PELinks;
import com.arcway.cockpit.modulelib2.client.core.AbstractModuleFactory;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.IDataFacade;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.ModulePlatformAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IUIDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.IWorkbenchWindow;

public class ModuleFactory
extends AbstractModuleFactory
implements IExecutableExtension {
    private static Map<String, ModuleFactory> instances = new HashMap<String, ModuleFactory>();
    private ModuleSpecification moduleSpecification;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleSpecification = (ModuleSpecification)SpecificationProvider.getDefault().getModuleSpecificationPart(data);
        super.construct((IClientDataFactory)new ClientDataFactory(this.moduleSpecification.getModuleID(), this.moduleSpecification.getModuleDataSpecification()), GenericModulePlugin.getDefault().getProjectManager(this.moduleSpecification.getModuleID()));
        instances.put(this.moduleSpecification.getModuleID(), this);
    }

    public static ModuleFactory getInstance(String moduleID) {
        return instances.get(moduleID);
    }

    protected com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade createModuleFacade() {
        return new ModuleFacade();
    }

    protected AbstractDataMgr createDataMgr() {
        DataManager dataManager = new DataManager();
        dataManager.setModuleDataSpecification(this.moduleSpecification.getModuleID(), this.moduleSpecification.getModuleDataSpecification());
        return dataManager;
    }

    protected com.arcway.cockpit.modulelib2.client.core.project.ModelController createModelController() {
        return new ModelController(this.moduleSpecification.getModuleID(), this.moduleSpecification.getModuleDataSpecification());
    }

    protected AbstractPermissionMgr createPermissionMgr() {
        return new PermissionManager();
    }

    protected AbstractPermissionTemplateProvider getPermissionTemplateProvider() {
        return new PermissionTemplateProvider(this.moduleSpecification.getModuleID(), this.moduleSpecification);
    }

    protected ModuleLockManager createLockMgr() {
        return new ModuleLockManager();
    }

    public String getModuleID() {
        return ModuleIdentification.getFullModuleID(this.moduleSpecification.getModuleID());
    }

    public String getModuleIDForPlatform() {
        return ModuleIdentification.getModuleIDForPlatform(this.moduleSpecification.getModuleID());
    }

    protected ProjectionMgr createProjectionMgr() {
        return null;
    }

    protected IDataFacade createDataFacade() {
        return new DataFacade(this.moduleSpecification.getModuleID(), this.moduleSpecification);
    }

    protected com.arcway.cockpit.modulelib2.client.core.project.ExportDataProvider createExportDataProvider() {
        return new ExportDataProvider(this.moduleSpecification);
    }

    public IModuleUserInterface getNewModuleUserInterface(IWorkbenchWindow workbenchWindow) {
        return new ModuleUserInterface(this.moduleSpecification.getModuleID(), this.moduleSpecification, workbenchWindow);
    }

    protected Object createAdditionalProjectAgents(AbstractDataMgr dataMgr, LinkMgr linkMgr, IProjectAgent projectAgent, ModuleLockManager lockManager, AbstractPermissionMgr permissionMgr, IDataFacade dataFacade) {
        return null;
    }

    protected void connectAdditionalProjectAgents(IModelController modelController, Object additionalProjectAgents) {
    }

    protected Collection<IPlatformAdapterModule> getPlatformAdapterModules(IFrameProjectAgent projectAgent, AbstractDataMgr dataManager, LinkMgr linkManager) {
        return Arrays.asList(new IPlatformAdapterModule[]{new GenericModulePlatformAdapter_CoreModule(this.moduleSpecification.getModuleID(), this.moduleSpecification.getModuleDataName(), this.moduleSpecification.getModuleIcon(), this.moduleSpecification.getModuleDataSpecification(), projectAgent, dataManager, linkManager), new GenericModulePlatformAdapter_PELinks(this.moduleSpecification.getModuleID(), this.moduleSpecification.getModuleDataName(), this.moduleSpecification.getModuleIcon(), this.moduleSpecification.getModuleDataSpecification(), projectAgent, linkManager, dataManager)});
    }

    protected ILinkTypeHelper createLinkTypeHelper() {
        return GMLinkTypeHelper.getDefault(this.moduleSpecification.getModuleID());
    }

    protected IUIDataTypesHelper createUIDataTypesHelper() {
        return GMUIDataTypesHelper.getDefault(this.moduleSpecification.getModuleID());
    }

    protected ModulePlatformAccess createPlatformAccessAgent() {
        return new ModulePlatformAccess(ModuleIdentification.getModuleIDForPlatform(this.moduleSpecification.getModuleID()));
    }

    protected ILicenseTypeProvider getLicenseTypeProvider() {
        return new GMLicenseTypeProvider(this.moduleSpecification.getModuleID());
    }
}

