/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityN1;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.infrastructure.SpecificationConstantsHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.modulelib2.client.messages.ModuleLinkType;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.cockpit.modulelib2.shared.messages.AbstractLinkTypeHelper_Shared;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class GMLinkTypeHelper_Shared
extends AbstractLinkTypeHelper_Shared {
    private static final String HIERARCHY_LINK_PREFIX = "hierarchylink-genericmodule-";
    private static final String ATTRIBUTE_LINK_PREFIX = "attributelink-genericmodule-";
    private static final String RELATION_LINK_PREFIX = "relationlink-genericmodule-";
    private static final String CROSSMODULE_LINK_PREFIX = "crossmodulelink-genericmodule-";
    private static final String MODELELEMENT_LINK_PREFIX = "modelelementlink-genericmodule-";
    private static final String SEPARATOR = "--";
    private final String moduleID;
    private final ModuleDataSpecification moduleDataSpecification;
    private final SetMap<String, String> map_linkedAttributeObjectTypeID_attributelinkTypeIDs;
    private static Map<String, GMLinkTypeHelper_Shared> singletons = new HashMap<String, GMLinkTypeHelper_Shared>();

    public static GMLinkTypeHelper_Shared getDefault(String moduleID) {
        ModuleSpecification moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID);
        if (moduleSpecification != null) {
            return GMLinkTypeHelper_Shared.getDefault(moduleSpecification);
        }
        return null;
    }

    public static GMLinkTypeHelper_Shared getDefault(ModuleSpecification moduleSpecification) {
        GMLinkTypeHelper_Shared singleton = singletons.get(moduleSpecification.getModuleID());
        if (singleton == null) {
            singleton = new GMLinkTypeHelper_Shared(moduleSpecification.getModuleID(), moduleSpecification.getModuleDataSpecification());
            singletons.put(moduleSpecification.getModuleID(), singleton);
        }
        return singleton;
    }

    private GMLinkTypeHelper_Shared(String moduleID, ModuleDataSpecification moduleDataSpecification) {
        this.moduleID = moduleID;
        this.moduleDataSpecification = moduleDataSpecification;
        this.map_linkedAttributeObjectTypeID_attributelinkTypeIDs = new SetMap();
        for (ObjectType objectType : moduleDataSpecification.getObjectTypeList()) {
            for (LinkedModuleDataAttribute attribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                this.map_linkedAttributeObjectTypeID_attributelinkTypeIDs.add((Object)attribute.getObjectTypeID(), (Object)this.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), attribute.getAttributeID()));
            }
        }
    }

    public String getHierarchyLinkTypeID(String parentTypeID, String childTypeID) {
        return this.getHierarchyLinkTypeID_forShortTypeIDs(ClientDataFactory_TypesHelper.getShortTypeID(parentTypeID), ClientDataFactory_TypesHelper.getShortTypeID(childTypeID));
    }

    public String getHierarchyLinkTypeID_forShortTypeIDs(String shortParentTypeID, String shortChildTypeID) {
        return HIERARCHY_LINK_PREFIX + this.moduleID + SEPARATOR + shortChildTypeID + SEPARATOR + shortParentTypeID;
    }

    public String getAttributeLinkTypeID(String dataTypeID, String attributeID) {
        return this.getAttributeLinkTypeID_forShortTypeID(ClientDataFactory_TypesHelper.getShortTypeID(dataTypeID), attributeID);
    }

    public String getAttributeLinkTypeID_forShortTypeID(String objectTypeID, String attributeID) {
        return ATTRIBUTE_LINK_PREFIX + this.moduleID + SEPARATOR + objectTypeID + SEPARATOR + attributeID;
    }

    public String getRelationLinkTypeID(String relationTypeID) {
        return RELATION_LINK_PREFIX + this.moduleID + SEPARATOR + relationTypeID;
    }

    public String getCrossModuleLinkTypeID(String relationTypeID) {
        return CROSSMODULE_LINK_PREFIX + this.moduleID + SEPARATOR + relationTypeID;
    }

    public String getModelElementLinkTypeID(String dataTypeID) {
        return this.getModelElementLinkTypeID_forShortTypeID(ClientDataFactory_TypesHelper.getShortTypeID(dataTypeID));
    }

    public String getModelElementLinkTypeID_forShortTypeID(String objectTypeID) {
        return MODELELEMENT_LINK_PREFIX + this.moduleID + SEPARATOR + objectTypeID;
    }

    private String getParentTypeIDForHierarchyLinkType(String linkTypeID) {
        return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, linkTypeID.substring(linkTypeID.lastIndexOf(SEPARATOR) + SEPARATOR.length()));
    }

    private String getChildTypeIDForHierarchyLinkType(String linkTypeID) {
        return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, linkTypeID.substring(linkTypeID.indexOf(SEPARATOR) + SEPARATOR.length(), linkTypeID.lastIndexOf(SEPARATOR)));
    }

    private String getDataTypeIDForAttributeLinkType(String linkTypeID) {
        return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.getObjectTypeIDForAttributeLinkType(linkTypeID));
    }

    private String getObjectTypeIDForAttributeLinkType(String linkTypeID) {
        return linkTypeID.substring(linkTypeID.indexOf(SEPARATOR) + SEPARATOR.length(), linkTypeID.lastIndexOf(SEPARATOR));
    }

    private String getAttributeIDForAttributeLinkType(String linkTypeID) {
        return linkTypeID.substring(linkTypeID.lastIndexOf(SEPARATOR) + SEPARATOR.length());
    }

    private String getRelationTypeIDForRelationLinkType(String linkTypeID) {
        return linkTypeID.substring(linkTypeID.lastIndexOf(SEPARATOR) + SEPARATOR.length());
    }

    private String getDataTypeIDForModelElementLinkType(String linkTypeID) {
        return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, linkTypeID.substring(linkTypeID.lastIndexOf(SEPARATOR) + SEPARATOR.length()));
    }

    public Collection<String> getLinkTypeIDsForModuleDataDataType(String dataTypeUID) {
        HashSet<String> linkTypeIDs = new HashSet<String>();
        String simpleTypeID = ClientDataFactory_TypesHelper.getShortTypeID(dataTypeUID);
        ObjectType objectType = this.moduleDataSpecification.getObjectType(simpleTypeID);
        for (ParentType parentType : objectType.getParentTypeList()) {
            if (parentType.getParentObjectTypeID().equals("hierarchyroot") || parentType.getParentObjectTypeID().equals("noparent")) continue;
            linkTypeIDs.add(this.getHierarchyLinkTypeID_forShortTypeIDs(parentType.getParentObjectTypeID(), simpleTypeID));
        }
        for (LinkedModuleDataAttribute linkedModuleDataAttribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
            linkTypeIDs.add(this.getAttributeLinkTypeID_forShortTypeID(simpleTypeID, linkedModuleDataAttribute.getAttributeID()));
        }
        for (LinkedFrameDataAttribute linkedFrameDataAttribute : objectType.getAttributeListOfType(LinkedFrameDataAttribute.class)) {
            linkTypeIDs.add(this.getAttributeLinkTypeID_forShortTypeID(simpleTypeID, linkedFrameDataAttribute.getAttributeID()));
        }
        for (ModuleDataRelationType moduleDataRelationType : this.moduleDataSpecification.getRelationTypeListOfType(ModuleDataRelationType.class)) {
            if (!moduleDataRelationType.getMDRelationParticipant(0).getObjectTypeIDOfParticipant().equals(simpleTypeID)) continue;
            linkTypeIDs.add(this.getRelationLinkTypeID(moduleDataRelationType.getRelationTypeID()));
        }
        for (ModelElementLinkType modelElementLinkType : this.moduleDataSpecification.getRelationTypeListOfType(ModelElementLinkType.class)) {
            if (!modelElementLinkType.getLinkedObjectTypeID().equals(simpleTypeID)) continue;
            linkTypeIDs.add(this.getModelElementLinkTypeID(dataTypeUID));
        }
        return linkTypeIDs;
    }

    public Collection<String> getLinkTypeIDsForLinkableObjectDataType(String dataTypeUID) {
        HashSet<String> linkTypeIDs = new HashSet<String>();
        String simpleTypeID = ClientDataFactory_TypesHelper.getShortTypeID(dataTypeUID);
        for (ObjectType currentObjectType : this.moduleDataSpecification.getObjectTypeList()) {
            if (currentObjectType.getParentType(simpleTypeID) == null) continue;
            linkTypeIDs.add(this.getHierarchyLinkTypeID_forShortTypeIDs(simpleTypeID, currentObjectType.getObjectTypeID()));
        }
        for (ObjectType currentObjectType : this.moduleDataSpecification.getObjectTypeList()) {
            for (LinkedModuleDataAttribute attribute : currentObjectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                if (!attribute.getObjectTypeID().equals(simpleTypeID)) continue;
                linkTypeIDs.add(this.getAttributeLinkTypeID_forShortTypeID(currentObjectType.getObjectTypeID(), attribute.getAttributeID()));
            }
        }
        for (ModuleDataRelationType relationType : this.moduleDataSpecification.getRelationTypeListOfType(ModuleDataRelationType.class)) {
            if (!relationType.getMDRelationParticipant(1).getObjectTypeIDOfParticipant().equals(simpleTypeID)) continue;
            linkTypeIDs.add(this.getRelationLinkTypeID(relationType.getRelationTypeID()));
        }
        return linkTypeIDs;
    }

    protected String getLinkableObjectDataTypeIDForLinkType_(String linkTypeID) {
        if (linkTypeID.startsWith(HIERARCHY_LINK_PREFIX)) {
            return this.getParentTypeIDForHierarchyLinkType(linkTypeID);
        }
        if (linkTypeID.startsWith(ATTRIBUTE_LINK_PREFIX)) {
            String objectTypeID = this.getObjectTypeIDForAttributeLinkType(linkTypeID);
            String attributeID = this.getAttributeIDForAttributeLinkType(linkTypeID);
            ObjectType objectType = this.moduleDataSpecification.getObjectType(objectTypeID);
            Attribute attribute = objectType.getAttribute(attributeID);
            if (attribute instanceof LinkedModuleDataAttribute) {
                LinkedModuleDataAttribute lAttribute = (LinkedModuleDataAttribute)attribute;
                return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, lAttribute.getObjectTypeID());
            }
            if (attribute instanceof LinkedFrameDataAttribute) {
                LinkedFrameDataAttribute fAttribute = (LinkedFrameDataAttribute)attribute;
                return SpecificationConstantsHelper.getCockpitDataTypeIDForLinkedFrameObjectType(fAttribute.getFrameObjectTypeID());
            }
            return null;
        }
        if (linkTypeID.startsWith(RELATION_LINK_PREFIX)) {
            String relationTypeID = this.getRelationTypeIDForRelationLinkType(linkTypeID);
            ModuleDataRelationType relationType = (ModuleDataRelationType)this.moduleDataSpecification.getRelationType(relationTypeID);
            MDRelationParticipant loParticipant = relationType.getMDRelationParticipant(1);
            return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, loParticipant.getObjectTypeIDOfParticipant());
        }
        if (linkTypeID.startsWith(MODELELEMENT_LINK_PREFIX)) {
            return null;
        }
        assert (false);
        return null;
    }

    protected String getModuleDataDataTypeIDForLinkType_(String linkTypeID) {
        if (linkTypeID.startsWith(HIERARCHY_LINK_PREFIX)) {
            return this.getChildTypeIDForHierarchyLinkType(linkTypeID);
        }
        if (linkTypeID.startsWith(ATTRIBUTE_LINK_PREFIX)) {
            return this.getDataTypeIDForAttributeLinkType(linkTypeID);
        }
        if (linkTypeID.startsWith(RELATION_LINK_PREFIX)) {
            String relationTypeID = this.getRelationTypeIDForRelationLinkType(linkTypeID);
            ModuleDataRelationType relationType = (ModuleDataRelationType)this.moduleDataSpecification.getRelationType(relationTypeID);
            MDRelationParticipant mdParticipant = relationType.getMDRelationParticipant(0);
            return ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, mdParticipant.getObjectTypeIDOfParticipant());
        }
        if (linkTypeID.startsWith(MODELELEMENT_LINK_PREFIX)) {
            return this.getDataTypeIDForModelElementLinkType(linkTypeID);
        }
        assert (false);
        return null;
    }

    public String getModelElementLinkTypeIDForModuleDataDataType(String dataTypeUID) {
        String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(dataTypeUID);
        RelationType relationType = this.moduleDataSpecification.getRelationType(shortTypeID);
        if (relationType != null && relationType instanceof ModelElementLinkType) {
            return this.getModelElementLinkTypeID(dataTypeUID);
        }
        return null;
    }

    public boolean isLELinkType(String linkTypeID) {
        return false;
    }

    public boolean isUELinkType(String linkTypeID) {
        return linkTypeID.startsWith(MODELELEMENT_LINK_PREFIX);
    }

    public ILinkType getModuleDataAttributeLinkType(String objectTypeID, String attributeID) {
        ObjectType objectType = this.moduleDataSpecification.getObjectType(objectTypeID);
        String objectTypeName = new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault());
        Attribute attribute = objectType.getAttribute(attributeID);
        LinkedModuleDataAttribute lAttribute = (LinkedModuleDataAttribute)attribute;
        String attributeName = new LabelProvider(lAttribute.getAttributeName()).getLabel(Locale.getDefault());
        return new ModuleLinkType(this.getAttributeLinkTypeID_forShortTypeID(objectTypeID, attributeID), String.valueOf(Messages.getString("GenericModuleLinks.AttributeLinkDisplayNamePrefix")) + " " + objectTypeName + "->" + attributeName, ModuleIdentification.getFullModuleID(this.moduleID), (ILinkCardinality)new CardinalityN1(), true, false, (ILinkTypeHelper_Shared)this);
    }

    public ILinkType getFrameAttributeLinkType(String cockpitTypeID, String attributeID, String frameAttributeCockpitTypeID) {
        ObjectType objectType = this.moduleDataSpecification.getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(cockpitTypeID));
        String objectTypeName = new LabelProvider(objectType.getObjectTypeName()).getLabel(Locale.getDefault());
        Attribute attribute = objectType.getAttribute(attributeID);
        LinkedFrameDataAttribute fAttribute = (LinkedFrameDataAttribute)attribute;
        String attributeName = new LabelProvider(fAttribute.getAttributeName()).getLabel(Locale.getDefault());
        return new ModuleLinkType(this.getAttributeLinkTypeID(cockpitTypeID, attributeID), String.valueOf(Messages.getString("GenericModuleLinks.AttributeLinkDisplayNamePrefix")) + " " + objectTypeName + "->" + attributeName, ModuleIdentification.getFullModuleID(this.moduleID), frameAttributeCockpitTypeID, (ILinkCardinality)new CardinalityN1(), true, false, (ILinkTypeHelper_Shared)this);
    }

    public Collection<String> getAttributeLinkTypes_forShortTypeID(String attributeObjectTypeID) {
        return this.map_linkedAttributeObjectTypeID_attributelinkTypeIDs.get((Object)attributeObjectTypeID);
    }
}

