/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.exceladapter.importer;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.exceladapter.exporter.Messages;
import com.arcway.cockpit.genericmodule.client.exceladapter.importer.ImportWizardContribution;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleImportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleImportAdapter;
import com.arcway.cockpit.genericmodule.client.gui.dialogues.AdministrateAttributeObjectsDialog;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.ImValue;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel.ModuleExcelListImporter;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeAndEnumValueMappings;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.AttributeMappingPageContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportAdapter;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.IImportableData;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.EnumValueReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.ExistingAttributeReference;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.attributemappingpage.IListManagementDialogueCreator;
import com.arcway.cockpit.modulelib2.client.gui.AbstractListManagementDialog;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.eclipse.adapter.excel.ExcelImportExportException;
import com.arcway.lib.eclipse.adapter.excel.imports.ColumnDescription;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheet;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheetType;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import de.plans.lib.util.gui.IProgressDisplay;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.widgets.Shell;

public class ExcelImporter
implements IGenericModuleImportAdapter {
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ObjectType objectTypeSpecification;
    private ModuleExcelListImporter excelListImporter;
    private ImportWizardContribution importWizardContribution;
    private IModuleDataTypeDescription dataTypeDescription;
    private IListManagementDialogueCreator listManagementDialogueCreator;
    private GMLinkTypeHelper_Shared linkTypeHelper;

    public void construct(String moduleID_, String objectTypeID) {
        this.moduleID = moduleID_;
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID_);
        this.objectTypeSpecification = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
        this.linkTypeHelper = GMLinkTypeHelper_Shared.getDefault((String)moduleID_);
        this.dataTypeDescription = GenericModuleDataTypeDescription.getTypeDescription((String)moduleID_, (ObjectType)this.objectTypeSpecification);
        this.listManagementDialogueCreator = new IListManagementDialogueCreator(){

            public AbstractListManagementDialog createListManagementDialogue(String cockpitTypeID, IModelController modelController, Shell shell) {
                return new AdministrateAttributeObjectsDialog(ExcelImporter.this.moduleID, ExcelImporter.this.moduleSpecification.getModuleDataSpecification().getObjectType(ClientDataFactory_TypesHelper.getShortTypeID((String)cockpitTypeID)), ExcelImporter.this.linkTypeHelper.getAttributeLinkTypes_forShortTypeID(cockpitTypeID), shell, modelController);
            }
        };
        this.excelListImporter = new ModuleExcelListImporter(ModuleIdentification.getFullModuleID((String)this.moduleID));
    }

    public IImportWizardContribution getWizardContribution() {
        if (this.importWizardContribution == null) {
            this.importWizardContribution = new ImportWizardContribution(this.moduleID, this.moduleSpecification, this.objectTypeSpecification);
        }
        return this.importWizardContribution;
    }

    public boolean isUsingAttributeMapping() {
        return true;
    }

    public List<AttributeMappingPageContribution> getAttributeMappingPageContributions(List<?> parameterList, Locale expectedLocale, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        try {
            this.excelListImporter.setExcelFile((String)parameterList.get(0), Messages.getString("ExcelExporter.LabelForRootItem"), expectedLocale, monitor);
        }
        catch (ExcelImportExportException eieE) {
            throw new ExportOrImportFailedException(1, eieE.getMessage(), eieE.getCause());
        }
        List dataPotDescriptions = this.excelListImporter.getDataPotDescriptions();
        LinkedList<AttributeMappingPageContribution> attributeMappingContributions = new LinkedList<AttributeMappingPageContribution>();
        for (List dataPotList : dataPotDescriptions) {
            attributeMappingContributions.add(new AttributeMappingPageContribution(this.dataTypeDescription, dataPotList, ModuleExcelListImporter.getAllowedAttributeMappings(), ModuleExcelListImporter.getWarningsForMappings(), false, this.listManagementDialogueCreator));
        }
        return attributeMappingContributions;
    }

    public IImportableData getImportableData(List<?> parameterList, List<AttributeAndEnumValueMappings> configuredAttributeMappings, Locale expectedLocale, IRepositoryInterfaceRO repositoryInterface, IImportAdapter.ICockpitObjectIDGenerator idGenerator, IProgressDisplay progressMonitor, Shell shell) throws ExportOrImportFailedException {
        GenericModuleImportableData dataToBeImported = new GenericModuleImportableData(true);
        List importedSheetTypes = this.excelListImporter.getSheetTypes();
        int sheetTypeIndex = 0;
        while (sheetTypeIndex < importedSheetTypes.size()) {
            ImportedSheetType sheetType = (ImportedSheetType)importedSheetTypes.get(sheetTypeIndex);
            AttributeAndEnumValueMappings mappingsForSheetType = configuredAttributeMappings.get(sheetTypeIndex);
            IMap_ attributeMap = mappingsForSheetType.getAttributeMap();
            IMap_ enumValueMap = mappingsForSheetType.getEnumValueMappingMap();
            for (ImportedSheet sheet : sheetType.getImportedSheets()) {
                String parentName = sheet.getSheetName();
                List childItems = sheet.getItems();
                dataToBeImported.map_parentItem_childItemsToImport.put(parentName, new ArrayList(childItems.size()));
                for (List childValueList : childItems) {
                    ImExGenericModuleData importableItem = new ImExGenericModuleData(this.moduleID, this.objectTypeSpecification.getObjectTypeID());
                    int dataPotIndex = 0;
                    while (dataPotIndex < childValueList.size()) {
                        ColumnDescription dataPotDescription = (ColumnDescription)sheetType.getColumnDescriptions().get(dataPotIndex);
                        String dataPotKey = dataPotDescription.getColumnKey();
                        String dataPotDataType = dataPotDescription.getColumnDataType();
                        ITargetAttributeDescription targetAttribute = (ITargetAttributeDescription)attributeMap.getByKey((Object)dataPotKey);
                        if (targetAttribute != null) {
                            String value = (String)childValueList.get(dataPotIndex);
                            if (value.length() == 0 && (Integer)targetAttribute.getDataTypeKey() != 10 && (Integer)targetAttribute.getDataTypeKey() != 12 && (Integer)targetAttribute.getDataTypeKey() != 9 && (Integer)targetAttribute.getDataTypeKey() != 11) {
                                importableItem.addAttributeValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue("", null));
                            } else {
                                if (dataPotDataType == "MultiLineString" && ((Integer)targetAttribute.getDataTypeKey() == 1 || (Integer)targetAttribute.getDataTypeKey() == 13)) {
                                    value = StringUtil.removeNewlines((String)value);
                                }
                                if (((ExistingAttributeReference)targetAttribute.getKey()).getAttributeKind() == 1) {
                                    if ((Integer)targetAttribute.getDataTypeKey() == 10 || (Integer)targetAttribute.getDataTypeKey() == 12 || (Integer)targetAttribute.getDataTypeKey() == 9) {
                                        EnumValueMapping enumValueMapping = (EnumValueMapping)enumValueMap.getByKey((Object)dataPotKey);
                                        Object id = ((EnumValueReference)enumValueMapping.getByKey((Object)value)).getEnumValueReference();
                                        if (id == null) {
                                            id = "";
                                        }
                                        importableItem.addAttributeValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(null, id));
                                    } else if ((Integer)targetAttribute.getDataTypeKey() == 3) {
                                        String normalisedValue = this.excelListImporter.getBooleanValue(value, expectedLocale) ? ModuleDataAttributeBoolean.getStringRepresentationForTrue() : ModuleDataAttributeBoolean.getStringRepresentationForFalse();
                                        importableItem.addAttributeValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(normalisedValue, null));
                                    } else {
                                        importableItem.addAttributeValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(value, null));
                                    }
                                } else if (((ExistingAttributeReference)targetAttribute.getKey()).getAttributeKind() == 2) {
                                    if ((Integer)targetAttribute.getDataTypeKey() == 10 || (Integer)targetAttribute.getDataTypeKey() == 11) {
                                        EnumValueMapping enumValueMapping = (EnumValueMapping)enumValueMap.getByKey((Object)dataPotKey);
                                        importableItem.addCustomPropertyValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(null, ((EnumValueReference)enumValueMapping.getByKey((Object)value)).getEnumValueReference()));
                                    } else if ((Integer)targetAttribute.getDataTypeKey() == 3) {
                                        String normalisedValue = this.excelListImporter.getBooleanValue(value, expectedLocale) ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                                        importableItem.addCustomPropertyValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(normalisedValue, null));
                                    } else if ((Integer)targetAttribute.getDataTypeKey() == 8) {
                                        double normalisedDoubleValue = this.excelListImporter.getRealValue(value);
                                        importableItem.addCustomPropertyValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(Double.toString(normalisedDoubleValue), null));
                                    } else {
                                        importableItem.addCustomPropertyValue(((ExistingAttributeReference)targetAttribute.getKey()).getAttributeID(), new ImValue(value, null));
                                    }
                                } else if (((ExistingAttributeReference)targetAttribute.getKey()).getAttributeKind() == 3) {
                                    EnumValueMapping enumValueMapping = (EnumValueMapping)enumValueMap.getByKey((Object)dataPotKey);
                                    importableItem.setImportedObjectTypeCategoryID((ObjectTypeCategoryID)((EnumValueReference)enumValueMapping.getByKey((Object)value)).getEnumValueReference());
                                } else assert (false);
                            }
                        }
                        ++dataPotIndex;
                    }
                    List childrenList = (List)dataToBeImported.map_parentItem_childItemsToImport.get(parentName);
                    childrenList.add(importableItem);
                }
            }
            ++sheetTypeIndex;
        }
        this.excelListImporter.resetImporter();
        return dataToBeImported;
    }

    public void abortImport() {
        this.excelListImporter.resetImporter();
    }
}

