/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.cockpit.frameserverproxy.menu.actions.SnapshotProjectDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SnapshotProjectActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final ILogger logger = Logger.getLogger(SnapshotProjectActionDelegate.class);
    private IWorkbenchWindow activeWindow;

    public void run(IAction proxyAction) {
        ArrayList<ServerProjectContainer> projectsWithServer = new ArrayList<ServerProjectContainer>();
        for (ServerConnection server : ProjectMgr.getProjectMgr().getGeneralServerProxy().getServerConnections()) {
            if (!server.isConnected()) continue;
            EOList projects = null;
            try {
                projects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectsWithPermissionForOperation("snapshotProject", null);
            }
            catch (EXServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (ServerNotAvailableException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            if (projects == null) continue;
            for (EOProject project : projects) {
                projectsWithServer.add(new ServerProjectContainer(server, project));
            }
        }
        if (projectsWithServer.size() == 0) {
            String msg = Messages.getString("SnapshotProjectActionDelegate.1");
            msg = String.valueOf(msg) + Messages.getString("SnapshotProjectActionDelegate.2");
            MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("SnapshotProjectActionDelegate.0"), null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return;
        }
        SnapshotProjectDialog dialog = new SnapshotProjectDialog(this.activeWindow.getShell(), projectsWithServer);
        int result = dialog.open();
        if (result == 0) {
            Collection<ServerProjectContainer> projectsToClone = dialog.getSelectedProjectAgents();
            for (ServerProjectContainer projectContainer : projectsToClone) {
                IProjectManagerServerProxy managerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectContainer.getServer().getServerID());
                try {
                    managerServerProxy.createProjectSnapshotOnServer(projectContainer.getProject());
                    MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("SnapshotProjectActionDelegate.3"), null, Messages.getString("SnapshotProjectActionDelegate.4"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    mDialog.open();
                }
                catch (EXServerException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
                catch (ServerNotAvailableException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                }
            }
        }
    }

    public void selectionChanged(IAction proxyAction, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
        this.activeWindow = window;
    }

    public void dispose() {
    }
}

