/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.cockpit.frameserverproxy.menu.actions.PublishProjectStatusDialog;
import com.arcway.cockpit.frameserverproxy.menu.actions.ReplaceProjectDialog;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PublishProjectStatusActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final String WORKING_PROJECT_POSTFIX = "*";
    private static final ILogger logger = Logger.getLogger(PublishProjectStatusActionDelegate.class);
    private IWorkbenchWindow activeWindow;
    private static final String ATTR_TAG_PROJECT_NAME = "projectname";

    public void run(IAction action) {
        List<ServerProjectContainer> snapshotableProjects = PublishProjectStatusActionDelegate.determineSnapshotableProjects();
        if (snapshotableProjects.size() == 0) {
            String msg = Messages.getString("PublishProjectStatusActionDelegate.1");
            msg = String.valueOf(msg) + Messages.getString("PublishProjectStatusActionDelegate.2");
            MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("PublishProjectStatusActionDelegate.0"), null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return;
        }
        PublishProjectStatusDialog dialog = new PublishProjectStatusDialog(this.activeWindow.getShell(), snapshotableProjects);
        int result = dialog.open();
        if (result == 0) {
            int userChoice;
            ServerProjectContainer projectToReplace;
            String targetProjectName;
            String workingAreaPostfix;
            Collection<ServerProjectContainer> selectedProjectsToPublish = dialog.getSelectedProjectAgents();
            if (selectedProjectsToPublish.size() != 1) {
                String msg = Messages.getString("ReplaceProjekt.2");
                msg = String.valueOf(msg) + Messages.getString("ReplaceProjekt.3");
                MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("ReplaceProjekt.1"), null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                return;
            }
            ServerProjectContainer projectToPublish = selectedProjectsToPublish.iterator().next();
            String selectedProjectToPublishName = projectToPublish.getProjectName();
            if (selectedProjectToPublishName.endsWith(workingAreaPostfix = WORKING_PROJECT_POSTFIX)) {
                MessageDialog replaceProjectDialog;
                ServerConnection server = projectToPublish.getServer();
                projectToReplace = PublishProjectStatusActionDelegate.findProject(server, targetProjectName = selectedProjectToPublishName.substring(0, selectedProjectToPublishName.length() - workingAreaPostfix.length()));
                if (projectToReplace != null) {
                    replaceProjectDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("PublishProjectStatusActionDelegate.3"), null, String.valueOf(Messages.getString("PublishProjectStatusActionDelegate.4")) + projectToReplace.getProjectName() + Messages.getString("PublishProjectStatusActionDelegate.5"), 3, new String[]{Messages.getString("Replace"), Messages.getString("Cancel")}, 0);
                    userChoice = replaceProjectDialog.open();
                } else {
                    replaceProjectDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("PublishProjectStatusActionDelegate.3a"), null, String.valueOf(Messages.getString("PublishProjectStatusActionDelegate.4a")) + targetProjectName + Messages.getString("PublishProjectStatusActionDelegate.5a"), 3, new String[]{Messages.getString("Create"), Messages.getString("Cancel")}, 0);
                    userChoice = replaceProjectDialog.open();
                }
            } else {
                List<ServerProjectContainer> replaceableProjects = PublishProjectStatusActionDelegate.determineReplaceableProjects(projectToPublish);
                ReplaceProjectDialog replaceDialog = new ReplaceProjectDialog(this.activeWindow.getShell(), replaceableProjects);
                int userChoiceReplaceDialog = replaceDialog.open();
                if (userChoiceReplaceDialog == 0) {
                    Collection<ServerProjectContainer> selectedProjectsToReplace = replaceDialog.getSelectedProjectAgents();
                    if (selectedProjectsToReplace.size() != 1) {
                        String msg = Messages.getString("ReplaceProjekt.2");
                        msg = String.valueOf(msg) + Messages.getString("ReplaceProjekt.3");
                        MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("ReplaceProjekt.1"), null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                        mDialog.open();
                        return;
                    }
                    projectToReplace = selectedProjectsToReplace.iterator().next();
                    EOProject eoProjectToReplace = projectToReplace.getProject();
                    targetProjectName = PublishProjectStatusActionDelegate.getProjectName(eoProjectToReplace);
                    MessageDialog replaceProjectDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("PublishProjectStatusActionDelegate.3"), null, String.valueOf(Messages.getString("PublishProjectStatusActionDelegate.4")) + projectToReplace.getProjectName() + Messages.getString("PublishProjectStatusActionDelegate.5"), 3, new String[]{Messages.getString("Replace"), Messages.getString("Cancel")}, 0);
                    userChoice = replaceProjectDialog.open();
                } else {
                    userChoice = userChoiceReplaceDialog;
                    projectToReplace = null;
                    targetProjectName = null;
                }
            }
            if (userChoice == 0) {
                String targetProjectUID;
                ProjectAgent targetProjectAgentIfLocallyAvailable;
                String serverID = projectToPublish.getServer().getServerID();
                boolean targetProjectIsOpenedIfLocallyAvailable = false;
                ArrayList<EOPermission> permissionsToAdd = new ArrayList<EOPermission>();
                String projectToPublishUID = projectToPublish.getProject().getProjectUID();
                if (projectToReplace == null) {
                    targetProjectAgentIfLocallyAvailable = null;
                    targetProjectUID = UUIDGenerator.getUniqueID();
                } else {
                    EOProject projectToDelete = projectToReplace.getProject();
                    targetProjectUID = projectToDelete.getProjectUID();
                    Collection<EOPermission> allPermissionsOfTargetProject = this.getAllPermissions(targetProjectUID, serverID);
                    permissionsToAdd.addAll(this.getAllPermissionsToDeleteTheProject(allPermissionsOfTargetProject));
                    targetProjectAgentIfLocallyAvailable = ProjectMgr.getProjectMgr().getProjectAgent(targetProjectUID);
                    if (targetProjectAgentIfLocallyAvailable != null) {
                        targetProjectIsOpenedIfLocallyAvailable = targetProjectAgentIfLocallyAvailable.isOpened();
                    }
                    IProjectManagerServerProxy managerServerProxyForDelete = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                    try {
                        managerServerProxyForDelete.deleteProjectOnServer(targetProjectUID);
                    }
                    catch (EXServerException e) {
                        logger.error("Exception when deleting project on server", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (UnknownServerException e) {
                        logger.error("Exception when deleting project on server", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (LoginCanceledException e) {
                        logger.error("Exception when deleting project on server", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (ServerNotAvailableException e) {
                        logger.error("Server not availbale when deleting project on server", (Throwable)e);
                        throw new Error(e);
                    }
                }
                Collection<EOPermission> allPermissionsOfSourceProject = this.getAllPermissions(projectToPublishUID, serverID);
                permissionsToAdd.addAll(this.getAllPermissionsToOpenThePublishedProject(targetProjectUID, allPermissionsOfSourceProject));
                IProjectManagerServerProxy managerServerProxyToPublishProject = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
                try {
                    managerServerProxyToPublishProject.createProjectToPublishOnServer(projectToPublish.getProject(), targetProjectUID, targetProjectName, permissionsToAdd);
                }
                catch (EXServerException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    throw new Error(e);
                }
                catch (UnknownServerException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    throw new Error(e);
                }
                catch (LoginCanceledException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    throw new Error(e);
                }
                catch (ServerNotAvailableException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    throw new Error(e);
                }
                MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("PublishProjectStatusActionDelegate.6"), null, Messages.getString("PublishProjectStatusActionDelegate.7"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                if (projectToReplace == null && targetProjectAgentIfLocallyAvailable != null && targetProjectIsOpenedIfLocallyAvailable) {
                    ProjectMgr.getProjectMgr().getProjectAgent(targetProjectUID).close(this.activeWindow.getShell());
                    try {
                        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)this.activeWindow);
                        boolean triggerUserOnOpenActions = true;
                        targetProjectAgentIfLocallyAvailable.open(targetProjectIsOpenedIfLocallyAvailable, triggerUserOnOpenActions, currentPage);
                    }
                    catch (LoginCanceledException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (ServerNotAvailableException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (UnknownServerException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (EXServerException e) {
                        logger.error("unhandled catch block", (Throwable)e);
                        throw new Error(e);
                    }
                    catch (ExProjectOpenAbortWithMessage e) {
                        logger.error("unhandled catch block", (Throwable)e);
                        throw new Error(e);
                    }
                }
            }
        }
    }

    private static ServerProjectContainer findProject(ServerConnection server, String projectName) {
        ServerProjectContainer foundProjectWithServer = null;
        if (server.isConnected()) {
            EOProject[] allProjects = null;
            try {
                allProjects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getAllProjectsOfServer();
            }
            catch (EXServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (UnknownServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (LoginCanceledException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (ServerNotAvailableException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            if (allProjects != null) {
                EOProject[] eOProjectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    EOProject project = eOProjectArray[n2];
                    if (PublishProjectStatusActionDelegate.getProjectName(project).equals(projectName)) {
                        foundProjectWithServer = new ServerProjectContainer(server, project);
                    }
                    ++n2;
                }
            }
        }
        return foundProjectWithServer;
    }

    private static List<ServerProjectContainer> determineReplaceableProjects(ServerProjectContainer selectedProjectToPublish) {
        ArrayList<ServerProjectContainer> replaceableProjectsWithServer = new ArrayList<ServerProjectContainer>();
        ServerConnection server = selectedProjectToPublish.getServer();
        if (server.isConnected()) {
            String masterUID = selectedProjectToPublish.getProject().getProjectUID();
            EOList deletableProjects = null;
            try {
                deletableProjects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectsWithPermissionForOperation("deleteProjectOnServer", null);
            }
            catch (EXServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (UnknownServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (LoginCanceledException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            catch (ServerNotAvailableException e) {
                logger.error("unhandled catch block", (Throwable)e);
                throw new Error(e);
            }
            if (deletableProjects != null) {
                for (EOProject project : deletableProjects) {
                    if (project.getProjectUID().equals(masterUID)) continue;
                    replaceableProjectsWithServer.add(new ServerProjectContainer(server, project));
                }
            }
        }
        return replaceableProjectsWithServer;
    }

    private static List<ServerProjectContainer> determineSnapshotableProjects() {
        ArrayList<ServerProjectContainer> projectsWithServerToPublish = new ArrayList<ServerProjectContainer>();
        for (ServerConnection server : ProjectMgr.getProjectMgr().getGeneralServerProxy().getServerConnections()) {
            List<EOProject> snapshotableProjects;
            if (!server.isConnected() || (snapshotableProjects = PublishProjectStatusActionDelegate.determineSnapshotableProjects(server)) == null) continue;
            for (EOProject project : snapshotableProjects) {
                projectsWithServerToPublish.add(new ServerProjectContainer(server, project));
            }
        }
        return projectsWithServerToPublish;
    }

    private static List<EOProject> determineSnapshotableProjects(ServerConnection server) {
        EOList snapshotableProjects = null;
        try {
            snapshotableProjects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectsWithPermissionForOperation("snapshotProject", null);
        }
        catch (EXServerException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
        catch (UnknownServerException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
        catch (LoginCanceledException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
        catch (ServerNotAvailableException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
        return snapshotableProjects;
    }

    private static String getProjectName(EOProject project) {
        String projectName = null;
        for (EOAttribute attribute : project.getAttributes()) {
            if (!attribute.getAttributeTypeUID().getEOAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_NAME.getUID())) continue;
            projectName = ((EOString)attribute.getValueAsEO()).getString();
        }
        if (projectName == null) {
            projectName = project.getOldAttributeValue(ATTR_TAG_PROJECT_NAME);
        }
        if (projectName == null) {
            logger.warn("Couldn't determine project name.");
            projectName = "";
        }
        return projectName;
    }

    public Collection<EOPermission> getAllPermissionsToDeleteTheProject(Collection<EOPermission> permissionList) {
        ArrayList<EOPermission> deletePermissions = new ArrayList<EOPermission>();
        for (EOPermission permission : permissionList) {
            if (!permission.getOperation().equals("deleteProjectOnServer")) continue;
            deletePermissions.add(permission);
        }
        return deletePermissions;
    }

    public Collection<EOPermission> getAllPermissionsToOpenThePublishedProject(String targetProjectUID, Collection<EOPermission> permissionList) {
        ArrayList<EOPermission> openPermissions = new ArrayList<EOPermission>();
        for (EOPermission permission : permissionList) {
            if (!permission.getOperation().equals("openPublishedProject")) continue;
            EOPermission openPermission = new EOPermission(permission);
            openPermission.setOperation("openProject");
            openPermission.setSubSetUID(targetProjectUID);
            openPermission.setOperandUID(targetProjectUID);
            openPermission.setPermissionUID(UUIDGenerator.getUniqueID());
            openPermissions.add(openPermission);
        }
        return openPermissions;
    }

    public Collection<EOPermission> getAllPermissions(String projectUID, String serverID) {
        EOGenericMessage parameter = new EOGenericMessage();
        parameter.addAttribute("permissionSubSetUID", projectUID);
        parameter.addAttribute("permissionSubSetType", "PROJECT");
        EOClientRequest getRequest = new EOClientRequest("permission", "getPermissionOfSubSet", (EncodableObjectBase)parameter);
        try {
            EOServerResponse response = PSCServices.getServiceFacade().sendRequest(serverID, getRequest);
            return (EOList)response.getResponseData();
        }
        catch (Throwable ta) {
            logger.error("error while getting permissions from server", ta);
            return Collections.EMPTY_LIST;
        }
    }

    public void selectionChanged(IAction proxyAction, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
        this.activeWindow = window;
    }

    public void dispose() {
    }
}

