/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.actions;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.cockpit.frameserverproxy.menu.actions.DeleteProjectDialog;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class DeleteProjectActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final ILogger logger = Logger.getLogger(DeleteProjectActionDelegate.class);
    private IWorkbenchWindow activeWindow;

    public void run(IAction proxyAction) {
        ArrayList<ServerProjectContainer> projectsWithServer = new ArrayList<ServerProjectContainer>();
        for (ServerConnection server : ProjectMgr.getProjectMgr().getGeneralServerProxy().getServerConnections()) {
            if (!server.isConnected()) continue;
            EOList projects = null;
            try {
                projects = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectsWithPermissionForOperation("deleteProjectOnServer", null);
            }
            catch (EXServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (LoginCanceledException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            catch (ServerNotAvailableException e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            if (projects == null) continue;
            for (EOProject project : projects) {
                projectsWithServer.add(new ServerProjectContainer(server, project));
            }
        }
        if (projectsWithServer.size() == 0) {
            String msg = Messages.getString("DeleteProjectActionDelegate.1");
            msg = String.valueOf(msg) + Messages.getString("DeleteProjectActionDelegate.2");
            MessageDialog mDialog = new MessageDialog(this.activeWindow.getShell(), Messages.getString("DeleteProjectActionDelegate.0"), null, msg, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
            return;
        }
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.activeWindow.getShell(), projectsWithServer);
        int result = dialog.open();
        if (result == 0) {
            Collection<ServerProjectContainer> projectsToDelete = dialog.getSelectedProjectAgents();
            for (ServerProjectContainer projectContainer : projectsToDelete) {
                MessageDialog removeProjectDialog = new MessageDialog(this.activeWindow.getShell(), com.arcway.cockpit.frame.client.global.Messages.getString((String)"ProjectMgr.Delete_Project_on_Server_40"), null, String.valueOf(com.arcway.cockpit.frame.client.global.Messages.getString((String)"ProjectMgr.really_delete_project")) + projectContainer.getProjectName() + com.arcway.cockpit.frame.client.global.Messages.getString((String)"ProjectMgr.from_server"), 3, new String[]{com.arcway.cockpit.frame.client.global.Messages.getString((String)"ProjectMgr.OK_42"), com.arcway.cockpit.frame.client.global.Messages.getString((String)"ProjectMgr.Cancel_43")}, 0);
                int success = removeProjectDialog.open();
                if (success != 0) continue;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectContainer.getProject().getProjectUID());
                if (projectAgent != null && projectAgent.getServerID().equals(projectContainer.getServer().getServerID())) {
                    IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)this.activeWindow);
                    ProjectMgr.getProjectMgr().deleteProjectOnServer((IFrameProjectAgent)projectAgent, currentPage);
                    continue;
                }
                IProjectManagerServerProxy managerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectContainer.getServer().getServerID());
                try {
                    managerServerProxy.deleteProjectOnServer(projectContainer.getProject().getProjectUID());
                }
                catch (EXServerException e) {
                    logger.error("Exception when deleting project on server", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("Exception when deleting project on server", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("Exception when deleting project on server", (Throwable)e);
                }
                catch (ServerNotAvailableException e) {
                    logger.error("Server not availbale when deleting project on server", (Throwable)e);
                }
            }
        }
    }

    public void selectionChanged(IAction proxyAction, ISelection selection) {
    }

    public void init(IWorkbenchWindow window) {
        this.activeWindow = window;
    }

    public void dispose() {
    }
}

