/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.gui.Messages;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class SelectProjectOnServerWidgetController {
    private final List<String> serverNameList = new ArrayList<String>();
    private String selectedServerName = null;
    private final ListMap<String, ServerProjectContainer> serverNameProjectMap = new ListMap();
    private List<ServerProjectContainer> selectedProjects = new ArrayList<ServerProjectContainer>();
    private final ServerProjectContainerLabelProvider labelProvider = new ServerProjectContainerLabelProvider();
    private final List<ServerProjectContainerSelectedListener> selectionListeners = new ArrayList<ServerProjectContainerSelectedListener>();
    Text projectNameFilterText = null;
    String projectNameFilterString = "";
    private boolean allowMultiSelection = false;
    private static final ILogger LOGGER = Logger.getLogger(SelectProjectOnServerWidgetController.class);

    public SelectProjectOnServerWidgetController(Collection<ServerProjectContainer> projects, boolean allowMultiSelection) {
        this.allowMultiSelection = allowMultiSelection;
        for (ServerProjectContainer serverProjectContainer : projects) {
            String serverName = serverProjectContainer.getServer().getServerName();
            if (!this.serverNameList.contains(serverName)) {
                this.serverNameList.add(serverName);
            }
            this.serverNameProjectMap.add((Object)serverName, (Object)serverProjectContainer);
        }
    }

    public Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        Composite childComposite = new Composite(base, 16);
        childComposite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, false);
        childComposite.setLayoutData((Object)layoutData);
        Label lblProject = new Label(childComposite, 0);
        lblProject.setText(Messages.getString("SelectProjectOnServerWidget.Server"));
        final Combo serverCombo = new Combo(childComposite, 76);
        serverCombo.setLayoutData((Object)new GridData(768));
        for (String serverName : this.serverNameList) {
            serverCombo.add(serverName);
        }
        Label lblSearch = new Label(childComposite, 0);
        lblSearch.setLayoutData((Object)new GridData());
        lblSearch.setText(Messages.getString("SelectProjectOnServerWidget.ProjectFilter"));
        this.projectNameFilterText = new Text(childComposite, 2048);
        this.projectNameFilterText.setLayoutData((Object)new GridData(768));
        int swtStyle = 2048;
        swtStyle = this.allowMultiSelection ? (swtStyle |= 2) : (swtStyle |= 4);
        final FilteredList fList = new FilteredList(base, swtStyle, (ILabelProvider)this.labelProvider, true, true, true);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 300;
        fList.setLayoutData((Object)layoutData);
        fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.selectionChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                this.selectionChanged();
            }

            private void selectionChanged() {
                Object[] selection = fList.getSelection();
                fList.getSelectionIndices();
                ArrayList<ServerProjectContainer> selected = new ArrayList<ServerProjectContainer>();
                if (selection.length == 0) {
                    SelectProjectOnServerWidgetController.this.selectProjectContainer(null);
                } else {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        selected.add((ServerProjectContainer)o);
                        ++n2;
                    }
                }
                SelectProjectOnServerWidgetController.this.selectProjectContainer(selected);
            }
        });
        serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.serverNameChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                this.serverNameChanged();
            }

            private void serverNameChanged() {
                int index = serverCombo.getSelectionIndex();
                SelectProjectOnServerWidgetController.this.selectedServerName = serverCombo.getItem(index);
                fList.setElements(SelectProjectOnServerWidgetController.this.serverNameProjectMap.get((Object)SelectProjectOnServerWidgetController.this.selectedServerName).toArray());
                SelectProjectOnServerWidgetController.this.selectProjectContainer(null);
            }
        });
        this.projectNameFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectProjectOnServerWidgetController.this.projectNameFilterString = "*" + SelectProjectOnServerWidgetController.this.projectNameFilterText.getText().toLowerCase();
                fList.setFilter(SelectProjectOnServerWidgetController.this.projectNameFilterString);
            }
        });
        if (this.serverNameList.size() > 0) {
            serverCombo.select(0);
            this.selectedServerName = serverCombo.getItem(0);
            fList.setElements(this.serverNameProjectMap.get((Object)this.selectedServerName).toArray());
        }
        return base;
    }

    private void selectProjectContainer(List<ServerProjectContainer> selectedContainers) {
        if (selectedContainers == null) {
            this.selectedProjects.clear();
        } else {
            this.selectedProjects = selectedContainers;
        }
        for (ServerProjectContainerSelectedListener listener : this.selectionListeners) {
            listener.serverProjectSelectionChanged(this.selectedProjects);
        }
    }

    public List<ServerProjectContainer> getSelectedProjects() {
        return this.selectedProjects;
    }

    public boolean addSelectionListener(ServerProjectContainerSelectedListener listener) {
        return this.selectionListeners.add(listener);
    }

    public boolean removeSelectionListener(ServerProjectContainerSelectedListener listener) {
        return this.selectionListeners.remove(listener);
    }

    class ServerProjectContainerLabelProvider
    implements ILabelProvider {
        private Image projectImage;

        ServerProjectContainerLabelProvider() {
        }

        public Image getImage(Object element) {
            if (this.projectImage == null) {
                this.projectImage = FramePlugin.getImageDescriptor((String)"cprj_obj.gif").createImage();
            }
            return this.projectImage;
        }

        public String getText(Object element) {
            assert (element instanceof ServerProjectContainer) : "inavlid entry of type " + element.getClass();
            ServerProjectContainer container = (ServerProjectContainer)element;
            EOProject project = container.getProject();
            return Project.getProjectName((EOProject)project);
        }

        public void dispose() {
            if (this.projectImage != null) {
                this.projectImage.dispose();
                this.projectImage = null;
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static interface ServerProjectContainerSelectedListener {
        public void serverProjectSelectionChanged(List<ServerProjectContainer> var1);
    }
}

