/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.WorkspaceInitializer;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IGeneralServerProxy;
import com.arcway.cockpit.frameserverproxy.client.LocalClientProductLicenseManager;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.parameter.EOParameterSetList;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.shared.message.EOServer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchPage;

public class GeneralServerProxy
implements IGeneralServerProxy {
    private static final String SYS_PROP_COCKPIT_DEFAULTSERVER_PREFIX = "cockpit.defaultserver";
    private static final String DEFAULTSERVER_NAME_SUFFIX = ".name";
    private static final String DEFAULTSERVER_URL_SUFFIX = ".url";
    private static final String DEFAULTSERVER_INTERVAL_SUFFIX = ".keepAliveInterval";
    private static final String DEFAULTSERVER_PROJECT_INFIX = ".project";
    private static final String DEFAULTSERVER_PROJECT_UID_SUFFIX = ".uid";
    private static final String DEFAULTSERVER_PROJECT_NAME_SUFFIX = ".name";
    private static final ILogger logger = Logger.getLogger(GeneralServerProxy.class);

    public void addServerStatusChangedListener(IServerStatusChangedListener listener) {
        PSCServices.getServiceFacade().getRequestForwarder().addServerStatusChangedListener(listener);
    }

    public void removeServerStatusChangedListener(IServerStatusChangedListener listener) {
        PSCServices.getServiceFacade().getRequestForwarder().removeServerStatusChangedListener(listener);
    }

    public Collection<ServerConnection> getServerConnections() {
        return PSCServices.getServiceFacade().getServerConnections();
    }

    public ServerConnection getServerConnection(String serverID) {
        return PSCServices.getServiceFacade().getServerConnection(serverID);
    }

    public void disconnect(String serverID) {
        PSCServices.getServiceFacade().disconnect(serverID);
    }

    public boolean mayAdministrateServers() {
        return true;
    }

    public boolean deleteServer(EOServer server) {
        if (PSCServices.getServiceFacade().getRequestForwarder().removeServerConnection(server)) {
            try {
                XMLConfigParameterMgr parameterMgr = PSCServices.getServiceFacade().getParameterManager();
                EOParameterSetList parameterServerList = (EOParameterSetList)parameterMgr.getSubtree("serverList");
                ArrayList localServerList = new ArrayList();
                localServerList.addAll(parameterServerList.getArrayList());
                localServerList.remove(server);
                parameterServerList.setNewElements(localServerList);
                parameterMgr.commitParameters();
                return true;
            }
            catch (IOException e) {
                logger.error("could not save parameters", (Throwable)e);
            }
        }
        return false;
    }

    public boolean arePermissionsNeeded() {
        return true;
    }

    public boolean isOldWorkspaceMigratable(File oldWorkspaceFolder) {
        File fmcaXML = WorkspaceInitializer.calculateFMCAXML((File)oldWorkspaceFolder);
        boolean isMigratable = fmcaXML.exists() && !fmcaXML.isDirectory();
        return isMigratable;
    }

    public void setupWorkspace(IWorkbenchPage initalWorkbenchPage, File oldWorkspaceFolder) {
        GeneralServerProxy.createCofigurationsForDefaultServers();
    }

    private static void createCofigurationsForDefaultServers() {
        if (PSCServices.getServiceFacade().getServerConnections().size() == 0) {
            int serverNr = 0;
            while (serverNr < 10) {
                block11: {
                    String numberdsyspropprefix = serverNr == 0 ? SYS_PROP_COCKPIT_DEFAULTSERVER_PREFIX : SYS_PROP_COCKPIT_DEFAULTSERVER_PREFIX + Integer.toString(serverNr);
                    try {
                        String serverName = System.getProperty(String.valueOf(numberdsyspropprefix) + ".name");
                        String serverURLString = System.getProperty(String.valueOf(numberdsyspropprefix) + DEFAULTSERVER_URL_SUFFIX);
                        String keepAliveIntervalString = System.getProperty(String.valueOf(numberdsyspropprefix) + DEFAULTSERVER_INTERVAL_SUFFIX);
                        String sysPropProjectPrefix = String.valueOf(numberdsyspropprefix) + DEFAULTSERVER_PROJECT_INFIX;
                        if (serverName != null && serverURLString != null) {
                            int keepAliveIntervalSeconds;
                            if (keepAliveIntervalString != null) {
                                try {
                                    keepAliveIntervalSeconds = Integer.parseInt(keepAliveIntervalString.trim());
                                }
                                catch (NumberFormatException nfe) {
                                    keepAliveIntervalSeconds = -1;
                                }
                                if (keepAliveIntervalSeconds < 10) {
                                    keepAliveIntervalSeconds = 180;
                                    logger.warn("Workspace initialisation problem - Specified Keep Alive Interval for default server " + serverNr + " is illegal - schould be a integer value >= " + 10 + ". Using the default timer interval of " + 180 + " seconds instead.");
                                }
                            } else {
                                keepAliveIntervalSeconds = 180;
                            }
                            String newServerID = GeneralServerProxy.createServerConfiguration(serverName.trim(), new URL(serverURLString.trim()), keepAliveIntervalSeconds);
                            GeneralServerProxy.createProjectConfigurations(newServerID, sysPropProjectPrefix);
                            break block11;
                        }
                        if (serverName != null || serverURLString != null || keepAliveIntervalString != null) {
                            logger.warn("Workspace initialisation problem - Connection parameters of the default cockpit server " + serverNr + " are incomplete. At least " + numberdsyspropprefix + ".name" + " and " + numberdsyspropprefix + DEFAULTSERVER_URL_SUFFIX + " need to be specified.");
                        }
                    }
                    catch (Throwable t) {
                        logger.warn("Workspace initialisation problem - connection data of the default cockpit server " + serverNr + " could not be detected or are illegal.", t);
                    }
                }
                ++serverNr;
            }
        }
    }

    private static void createProjectConfigurations(String serverID, String sysPropProjectPrefix) {
        int projectNr = 0;
        while (projectNr < 10) {
            String numberdsyspropprefix = projectNr == 0 ? sysPropProjectPrefix : String.valueOf(sysPropProjectPrefix) + Integer.toString(projectNr);
            try {
                String projectUID = System.getProperty(String.valueOf(numberdsyspropprefix) + DEFAULTSERVER_PROJECT_UID_SUFFIX);
                String projectName = System.getProperty(String.valueOf(numberdsyspropprefix) + ".name");
                if (projectUID != null && projectName != null) {
                    GeneralServerProxy.createProjectConfiguration(serverID, projectUID.trim(), projectName.trim());
                } else if (projectUID != null || projectName != null) {
                    logger.warn("Workspace initialisation problem - Connection parameters of the default project " + projectNr + " are incomplete. At least " + numberdsyspropprefix + DEFAULTSERVER_PROJECT_UID_SUFFIX + " and " + numberdsyspropprefix + ".name" + " needs to be specified.");
                }
            }
            catch (Throwable t) {
                logger.warn("Workspace initialisation problem - connection data of the default project " + projectNr + " could not be detected or are illegal.", t);
            }
            ++projectNr;
        }
    }

    public static String createServerConfiguration(String servername, URL serverUrl, int keepAliveIntervalSeconds) throws IOException, ExAmbiguousServerConfigurationParameters {
        assert (keepAliveIntervalSeconds >= 10);
        XMLConfigParameterMgr parameterMgr = PSCServices.getServiceFacade().getParameterManager();
        EOParameterSetList parameterServerList = (EOParameterSetList)parameterMgr.getSubtree("serverList");
        ArrayList<EOServer> localServerList = new ArrayList<EOServer>();
        localServerList.addAll(parameterServerList.getArrayList());
        for (EOServer server : localServerList) {
            if (!serverUrl.toString().trim().equals(server.getServerURL().trim()) && !servername.equalsIgnoreCase(server.getServerName())) continue;
            throw new ExAmbiguousServerConfigurationParameters(MessageFormat.format("Adding the requested Server configuration (name={0}, url={1}) conflicts with existing server configuration (name={2}, url={3}).", servername, serverUrl.toString(), server.getServerName(), server.getServerURL()));
        }
        int interval_ms = keepAliveIntervalSeconds * 1000;
        EOServer newServer = new EOServer();
        newServer.setServerID(UUIDGenerator.getUniqueID());
        newServer.setServerName(servername);
        newServer.setServerURL(serverUrl.toString());
        newServer.setTimerInterval(interval_ms);
        localServerList.add(newServer);
        parameterServerList.setNewElements(localServerList);
        parameterMgr.commitParameters();
        PSCServices.getServiceFacade().getRequestForwarder().addServerConnection(newServer);
        return newServer.getServerID();
    }

    private static void createProjectConfiguration(String serverID, String projectUID, String projectName) throws IOException {
        ProjectMgr projectMgr = ProjectMgr.getProjectMgr();
        projectMgr.configureProject(serverID, projectUID, projectName);
    }

    public boolean canServerProvideLicenses() {
        return true;
    }

    public IClientProductLicenseManager getProductLicenseManager() {
        return LocalClientProductLicenseManager.getDefault();
    }

    public static class ExAmbiguousServerConfigurationParameters
    extends Exception {
        public ExAmbiguousServerConfigurationParameters(String message) {
            super(message);
        }
    }
}

