/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.locking.SplittedLockSet;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ExRetryProjectOpen;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule2;
import com.arcway.cockpit.frame.client.project.modules.IRequesterForServerData;
import com.arcway.cockpit.frame.client.project.modules.ModuleInformation;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOCommit;
import com.arcway.cockpit.frame.shared.message.EOCurrentCommitVersions;
import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.message.EOFileRequestParameter;
import com.arcway.cockpit.frame.shared.message.EOForeignLocksRequest;
import com.arcway.cockpit.frame.shared.message.EOGetHistoricItemParameter;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOLockRequest;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.serverexceptions.EXPendingAsynchronousUpdates;
import com.arcway.cockpit.frameserverproxy.client.CommitProgressDetector;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FrameServerProxy
implements IFrameServerProxy {
    private static final ILogger logger = Logger.getLogger(FrameServerProxy.class);
    private String serverID;
    private IFrameProjectAgent projectAgent;

    public boolean prepareCommit(boolean useDefaultDestination, Shell parentShell) {
        if (!useDefaultDestination) {
            MessageDialog md = new MessageDialog(parentShell, Messages.getString("CommitAction.Label"), Icons.getArcWayLogo(), Messages.getString("CommitAction.Do_you_really_want_to_upload_the_local_changes_to_the_server__6"), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            return md.open() == 0;
        }
        return true;
    }

    public EOCommit commitProject(EOCommit projectModifications, Shell parentShell) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        assert (projectModifications != null) : "projectModifications can't be null";
        EOLock currentCommitLock = CommitProgressDetector.generateUUniqueCommitLock(this.projectAgent.getUID());
        LockResult lockResult = this.projectAgent.getLockManager().atomicCheckAndSetLocks(new ArrayList(), new ArrayList<EOLock>(Collections.singletonList(currentCommitLock)), false);
        Collection commitLocks = new SplittedLockSet(this.projectAgent.getLockManager().getAllLocksCurrentlyAllocatedOnServer()).getCommitLocks();
        if (commitLocks.isEmpty() || !lockResult.wasSuccessful() || lockResult.getNewlyAddedLocks().isEmpty() || lockResult.getPossibleServerException() != null) {
            throw new EXServerException("frame.locks", "InputOutputException", lockResult.getPossibleServerException().getLocalizedMessage(), lockResult.getPossibleServerException());
        }
        assert (lockResult.getConflictingLocks().isEmpty());
        assert (lockResult.getNewlyAddedLocks().size() == 1);
        projectModifications.addFrameDataModifications(CommitProgressDetector.createCommitSuccessMarkerModifications(this.projectAgent.getUID(), commitLocks));
        projectModifications.setClientLocks(this.projectAgent.getLockManager().getAllLocksCurrentlyAllocatedOnServer());
        EOList requests = new EOList();
        requests.add((EncodableObjectBase)new EOClientRequest("frame.Commit", "frame.Commit", (EncodableObjectBase)projectModifications));
        requests.add((EncodableObjectBase)new EOClientRequest("frame.lock", "frame.releaselock", (EncodableObjectBase)new EOList(Collections.singletonList(currentCommitLock))));
        requests.add((EncodableObjectBase)FrameDataRequester.getRequest(this.projectAgent.getUID(), "com.arcway.cockpit.commitmarker"));
        EOClientRequest request = new EOClientRequest("setOfRequests", "", (EncodableObjectBase)requests);
        EOServerResponse responseBatch = PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
        EOCommit commitResult = null;
        EOServerResponse commitMarkerFetchResponse = null;
        StringBuilder sb = new StringBuilder();
        if (responseBatch != null) {
            EncodableObjectBase responseBatchData = responseBatch.getResponseData();
            if (responseBatchData instanceof EOList) {
                EOList responses = (EOList)responseBatchData;
                if (!responses.isEmpty() && responses.get(0) instanceof EOServerResponse) {
                    commitResult = (EOCommit)((EOServerResponse)responses.get(0)).getResponseData();
                }
                if (commitResult == null) {
                    sb.append("Unexpected commit response: expected non-null EOCommit in answer.");
                }
                if (responses.size() == 3 && responses.get(2) instanceof EOServerResponse) {
                    commitMarkerFetchResponse = (EOServerResponse)responses.get(2);
                }
                if (responses.size() != 3) {
                    sb.append("Unexpected commit response: expected answers for exactly 3 subrequests but received " + responses.size());
                }
            } else if (responseBatchData == null) {
                sb.append("Unexpected <empty/null> commit responseBatchData");
            } else {
                sb.append("Unexpected commit responseBatchData of type: " + responseBatch.getResponseData());
            }
        } else {
            sb.append("Unexpected <empty/null> commit responseBatch.");
        }
        if (sb.length() > 0) {
            logger.error(sb.toString());
        }
        if (commitMarkerFetchResponse != null && !CommitProgressDetector.assessCommitSuccess(commitLocks, commitMarkerFetchResponse)) {
            this.projectAgent.getLockManager().releaseCommitLocks(Collections.singletonList(currentCommitLock));
        }
        return commitResult;
    }

    public String getProjectUID() {
        return this.projectAgent.getUID();
    }

    public String getServerID() {
        return this.serverID;
    }

    public List<Collection<EOLock>> atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> clientLocksNeededByServer, Collection<EOLock> locksToBeSet) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        assert (locksToBeChecked != null) : "lock list can't be null";
        assert (locksToBeSet != null) : "lock list can't be null";
        Map projectUID2CommitUIDs = ProjectMgr.getProjectMgr().getCurrentCommitVersions(this.serverID);
        EOCurrentCommitVersions currentCommitVersions = new EOCurrentCommitVersions(projectUID2CommitUIDs);
        EOList locksToBeCheckedWithRole = new EOList(locksToBeChecked, "locksToBeChecked");
        EOList locksToBeSetWithRole = new EOList(locksToBeSet, "locksToBeSet");
        EOList clientLocksNeededByServerWithRole = new EOList(clientLocksNeededByServer, "clientLocksNeededByServer");
        EOLockRequest lockRequest = new EOLockRequest(locksToBeCheckedWithRole, locksToBeSetWithRole, clientLocksNeededByServerWithRole, this.projectAgent.getProjectUID(), currentCommitVersions);
        EOClientRequest req = new EOClientRequest("frame.lock", "frame.atomiccheckandsetlocks", (EncodableObjectBase)lockRequest);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        ProjectMgr.getProjectMgr().refreshCommitVersions(this.serverID, projectUID2CommitUIDs);
        List responseData = (List)res.getResponseData();
        Collection conflictingLocks = (Collection)responseData.get(0);
        String localizedMessage_part1 = Messages.getString("FrameServerProxy.conflictingLocksByNotYetAppliedAsyncUpd.1");
        String localizedMessage_part2 = Messages.getString("FrameServerProxy.conflictingLocksByNotYetAppliedAsyncUpd.2");
        for (EOLock eoLock : conflictingLocks) {
            String userName = eoLock.getUserName();
            if (!userName.contains("%asyncUpd%")) continue;
            eoLock.setUserName(String.valueOf(localizedMessage_part1) + localizedMessage_part2);
            eoLock.setClientName(localizedMessage_part1);
        }
        return responseData;
    }

    public void releaseLocks(Collection<EOLock> locksToBeReleased) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        assert (locksToBeReleased != null) : "locks can't be null";
        if (!locksToBeReleased.isEmpty()) {
            EOClientRequest req = new EOClientRequest("frame.lock", "frame.releaselock", (EncodableObjectBase)new EOList(locksToBeReleased));
            PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        }
    }

    public List<EOLock> getForeignLocks(Collection<EOLock> clientLocksNeededByServer, boolean considerCommitVersion) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        EOCurrentCommitVersions currentCommitVersions = null;
        Map projectUID2CommitUIDs = null;
        boolean refreshCommitVersions = false;
        if (considerCommitVersion) {
            projectUID2CommitUIDs = ProjectMgr.getProjectMgr().getCurrentCommitVersions(this.serverID);
            currentCommitVersions = new EOCurrentCommitVersions(projectUID2CommitUIDs);
            refreshCommitVersions = true;
        }
        EOList clientLocksNeededByServerWithRole = new EOList(clientLocksNeededByServer, "clientLocksNeededByServer");
        EOForeignLocksRequest foreignLocksRequest = new EOForeignLocksRequest(clientLocksNeededByServerWithRole, this.projectAgent.getProjectUID(), currentCommitVersions);
        EOClientRequest req = new EOClientRequest("frame.lock", "frame.getallforeignlocks", (EncodableObjectBase)foreignLocksRequest);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        if (refreshCommitVersions) {
            ProjectMgr.getProjectMgr().refreshCommitVersions(this.serverID, projectUID2CommitUIDs);
        }
        return (List)res.getResponseData();
    }

    public void updatePermissions(Collection<EOPermission> permissionsToAdd, Collection<EOPermission> permissionsToRemove) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        PSCClientServiceFacade.getFacade().updatePermissions(permissionsToAdd, permissionsToRemove, this.serverID);
    }

    public List<EOPermission> getAllPermissions() {
        EOGenericMessage parameter = new EOGenericMessage();
        parameter.addAttribute("permissionSubSetUID", this.projectAgent.getUID());
        parameter.addAttribute("permissionSubSetType", "PROJECT");
        EOClientRequest getRequest = new EOClientRequest("permission", "getPermissionOfSubSet", (EncodableObjectBase)parameter);
        try {
            EOServerResponse response = PSCServices.getServiceFacade().sendRequest(this.projectAgent.getServerID(), getRequest);
            return (EOList)response.getResponseData();
        }
        catch (Throwable ta) {
            logger.error("error while getting permissions from server", ta);
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<IPermissionOwner> getAllPermissionOwners() {
        ArrayList<IPermissionOwner> permissionOwners = new ArrayList<IPermissionOwner>();
        permissionOwners.addAll(this.getAllServerUsers());
        permissionOwners.addAll(this.getAllServerGroups());
        permissionOwners.addAll(this.projectAgent.getFrameStakeholderManager().getRoles());
        return permissionOwners;
    }

    public Collection<EOUser> getAllServerUsers() {
        try {
            EOClientRequest reqUsers = new EOClientRequest("User", "GetAllUsers", null);
            EOServerResponse ru = PSCServices.getServiceFacade().sendRequest(this.projectAgent.getServerID(), reqUsers);
            return (Collection)ru.getResponseData();
        }
        catch (ServerNotAvailableException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<EOGroup> getAllServerGroups() {
        try {
            EOClientRequest reqGroups = new EOClientRequest("User", "GetAllGroups", null);
            EOServerResponse rg = PSCServices.getServiceFacade().sendRequest(this.projectAgent.getServerID(), reqGroups);
            return (Collection)rg.getResponseData();
        }
        catch (ServerNotAvailableException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    public EOUser getCurrentUser() {
        return PSCServices.getServiceFacade().getUserData(this.serverID).getUser();
    }

    public void construct(IFrameProjectAgent newProjectAgent) {
        assert (newProjectAgent != null);
        this.serverID = newProjectAgent.getServerID();
        this.projectAgent = newProjectAgent;
    }

    public EOServerResponse sendRequest(String reqGroup, String reqSubID, EncodableObjectBase reqParam) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, EXOfflineMode {
        IProjectManagerServerProxy projectManagerServerProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID());
        return projectManagerServerProxy.sendRequest(reqGroup, reqSubID, reqParam);
    }

    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        PSCServices.getServiceFacade().getNotificationBus().subscribeListenerOnServer(listener, notificationtype, this.projectAgent.getServerID());
    }

    public EOClientRequest subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(INotificationBusListener listener, String notificationtype) {
        return PSCServices.getServiceFacade().getNotificationBus().subscribeListenerOnClientBusAndGetRequestToRegisterOnServer(listener, notificationtype, this.projectAgent.getServerID());
    }

    public void unsubscribeListenerOnServer(INotificationBusListener listener, String notificationType) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        PSCServices.getServiceFacade().getNotificationBus().unsubscribeListenerOnServer(listener, notificationType, this.projectAgent.getServerID());
    }

    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return PSCServices.getServiceFacade().getUserData(this.projectAgent.getServerID(), forceLogin);
    }

    public boolean concurrentWorkPossible() {
        return true;
    }

    public boolean isCommitable() {
        return true;
    }

    private ServerDataContainer trySetupAfterDataManagersAreCreated(final Collection<EOLock> allLocksCurrentlyAllocatedOnServer, final boolean registerForNotificationsAndDontCheckForPendingAsynchronousUpdates) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXPendingAsynchronousUpdates {
        final EOList importData = new EOList();
        IRequester metaData = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOGenericMessage metadataReqContent = new EOGenericMessage();
                metadataReqContent.addAttribute("uid", FrameServerProxy.this.projectAgent.getProjectUID());
                metadataReqContent.addChild((EncodableObjectBase)new EOList(allLocksCurrentlyAllocatedOnServer));
                String requestID = registerForNotificationsAndDontCheckForPendingAsynchronousUpdates ? "frame.GetProject" : "frame.GetProjectCheckAsyncUpdatesAreApplied";
                return new EOClientRequest("frame.project", requestID, (EncodableObjectBase)metadataReqContent);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList metaDataFromServer = new EOList("metadata");
                EncodableObjectBase eoProject = response.getResponseData();
                metaDataFromServer.add(eoProject);
                importData.add((EncodableObjectBase)metaDataFromServer);
            }
        };
        IRequester userDefAttr = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.userdefinedattributetypes", "frame.userdefinedattributetypes.get", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList userDefinedAttributeTypes = (EOList)response.getResponseData();
                userDefinedAttributeTypes.setRole("userDefinedAttributeTypes");
                importData.add((EncodableObjectBase)userDefinedAttributeTypes);
            }
        };
        IRequester objectTypeCategoriesRequest = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOList reqParam = new EOList();
                reqParam.add((EncodableObjectBase)new EOString(FrameServerProxy.this.projectAgent.getProjectUID(), "parameter.1"));
                return new EOClientRequest("frame.objecttypecategories", "frame.objecttypecategories.getalldata", (EncodableObjectBase)reqParam);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList objectTypeCategories = (EOList)response.getResponseData();
                objectTypeCategories.setRole("object-type-category");
                importData.add((EncodableObjectBase)objectTypeCategories);
            }
        };
        IRequester fileMetaInformation = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.files", "frame.files.getallmetainformation", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList fileMetaInformation = (EOList)response.getResponseData();
                fileMetaInformation.setRole("fileMetaInformation");
                importData.add((EncodableObjectBase)fileMetaInformation);
            }
        };
        IRequester plans = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOList parameter = new EOList();
                EOString projectUID = new EOString(FrameServerProxy.this.projectAgent.getUID(), "parameter.1");
                parameter.add((EncodableObjectBase)projectUID);
                return new EOClientRequest("frame.Plan", "frame.GetPlans", (EncodableObjectBase)parameter);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverPlans = (EOList)response.getResponseData();
                serverPlans.setRole("plans");
                importData.add((EncodableObjectBase)serverPlans);
            }
        };
        IRequester sections = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.Section", "frame.GetSections", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverSections = (EOList)response.getResponseData();
                serverSections.setRole("sections");
                importData.add((EncodableObjectBase)serverSections);
            }
        };
        IRequester uniqueElements = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.UniqueElement", "frame.GetAllUniqueElements", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverUniqueElements = (EOList)response.getResponseData();
                serverUniqueElements.setRole("unique elements");
                importData.add((EncodableObjectBase)serverUniqueElements);
            }
        };
        IRequester uniqueElementsOccurrences = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.UniqueElement", "frame.GetAllUniqueElementOccurances", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverUniqueElementsOccurrences = (EOList)response.getResponseData();
                serverUniqueElementsOccurrences.setRole("unique element occurences");
                importData.add((EncodableObjectBase)serverUniqueElementsOccurrences);
            }
        };
        IRequester uniqueElementsRelationships = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.projectAgent.getUID());
                return new EOClientRequest("frame.UniqueElementRelationship", "frame.GetAllUniqueElementRelationships", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverUniqueElementsRelationships = (EOList)response.getResponseData();
                serverUniqueElementsRelationships.setRole("uniqueElementContainment");
                importData.add((EncodableObjectBase)serverUniqueElementsRelationships);
            }
        };
        IRequester stakeholders = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.getProjectUID());
                return new EOClientRequest("frame.Stakeholder", "frame.GetAllStakeholders", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverStakeholders = (EOList)response.getResponseData();
                serverStakeholders.setRole("stakeholders");
                importData.add((EncodableObjectBase)serverStakeholders);
            }
        };
        IRequester roles = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.getProjectUID());
                return new EOClientRequest("frame.Stakeholder", "frame.getAllStakeholderRoles", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList stakeholderRoles = (EOList)response.getResponseData();
                stakeholderRoles.setRole("stakeholder roles");
                importData.add((EncodableObjectBase)stakeholderRoles);
            }
        };
        IRequester stakeholderRoleConnections = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                EOValue paramProjectUID = new EOValue(FrameServerProxy.this.getProjectUID());
                return new EOClientRequest("frame.Stakeholder", "frame.getAllRoleAndStakeholder", (EncodableObjectBase)paramProjectUID);
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList serverStakeholderRoleConnections = (EOList)response.getResponseData();
                serverStakeholderRoleConnections.setRole("stakeholder role connections");
                importData.add((EncodableObjectBase)serverStakeholderRoleConnections);
            }
        };
        EOList wholeFrameData = new EOList("frame_data");
        importData.add((EncodableObjectBase)wholeFrameData);
        FrameDataRequester reportTemplateFolders = new FrameDataRequester(this.projectAgent.getUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, (Collection)wholeFrameData);
        FrameDataRequester reportTemplates = new FrameDataRequester(this.projectAgent.getUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, (Collection)wholeFrameData);
        FrameDataRequester reportOutputtemplates = new FrameDataRequester(this.projectAgent.getUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, (Collection)wholeFrameData);
        final EOList[] commitInformations = new EOList[1];
        IRequester lastCommitInformationRequester = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                return new EOClientRequest("plaform.locks", "commitInformations", (EncodableObjectBase)new EOString(FrameServerProxy.this.projectAgent.getUID()));
            }

            @Override
            public void setResponse(EOServerResponse response) {
                commitInformations[0] = (EOList)response.getResponseData();
            }
        };
        final ArrayList workspaceInformations = new ArrayList();
        IRequester workspacesOnServerRequester = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                return new EOClientRequest("plaform.locks", "getWorkspaceInformations", (EncodableObjectBase)new EOString(FrameServerProxy.this.projectAgent.getUID()));
            }

            @Override
            public void setResponse(EOServerResponse response) {
                workspaceInformations.addAll((Collection)response.getResponseData());
            }
        };
        final HashMap workspaceUID_locks = new HashMap();
        IRequester workspaceUID_locks_request = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                return new EOClientRequest("plaform.locks", "getWorkspaceUIDwithLocks", (EncodableObjectBase)new EOString(FrameServerProxy.this.projectAgent.getUID()));
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList allLockLists = (EOList)response.getResponseData();
                for (EOList workspace : allLockLists) {
                    String workspaceUID = workspace.getRole();
                    workspaceUID_locks.put(workspaceUID, workspace);
                }
            }
        };
        final HashSet lockLog = new HashSet();
        IRequester logLockRequester = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                return new EOClientRequest("plaform.locks", "getLogLocks", (EncodableObjectBase)new EOString(FrameServerProxy.this.projectAgent.getUID()));
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList allLocks = (EOList)response.getResponseData();
                for (EOPlatformLock lock : allLocks) {
                    lockLog.add(lock);
                }
            }
        };
        ArrayList<IRequester> requesters = new ArrayList<IRequester>();
        requesters.add(metaData);
        final EOList moduleData = new EOList("module data");
        importData.add((EncodableObjectBase)moduleData);
        List allModuleInformation = this.projectAgent.getModuleController().getAllModuleInformation();
        for (ModuleInformation moduleInformation : allModuleInformation) {
            IFMCAModule2 moduleFacade = moduleInformation.getModuleFacade();
            Collection moduleDataTypes = moduleFacade.getTrueDataTypeIDs();
            for (final String moduleDataTypeID : moduleDataTypes) {
                final IRequesterForServerData exportDataProviderModuleDataRequester = moduleFacade.getRequesterToGetModuleDataFromServer(moduleDataTypeID);
                IRequester moduleDataRequester = new IRequester(){

                    @Override
                    public EOClientRequest getRequest() {
                        return exportDataProviderModuleDataRequester.createRequest();
                    }

                    @Override
                    public void setResponse(EOServerResponse response) {
                        EOList moduleDataList = exportDataProviderModuleDataRequester.handleResponse(response);
                        moduleDataList.setRole(moduleDataTypeID);
                        moduleData.add((EncodableObjectBase)moduleDataList);
                    }
                };
                requesters.add(moduleDataRequester);
            }
        }
        if (registerForNotificationsAndDontCheckForPendingAsynchronousUpdates) {
            IRequester notificationListenerRegistrationRequester = new IRequester(){

                @Override
                public EOClientRequest getRequest() {
                    return FrameServerProxy.this.projectAgent.getCommitMgr().registerNotificationListenerOnClientAndGetRegistrationRequest();
                }

                @Override
                public void setResponse(EOServerResponse response) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("initialize() - Registered for server updates of project " + FrameServerProxy.this.projectAgent.getProjectUID());
                    }
                }
            };
            IRequester commitVersionListenerRegistrationRequester = new IRequester(){

                @Override
                public EOClientRequest getRequest() {
                    return FrameServerProxy.this.projectAgent.getCommitMgr().getCommitVersionListenerRegistrationRequest();
                }

                @Override
                public void setResponse(EOServerResponse response) {
                }
            };
            requesters.add(notificationListenerRegistrationRequester);
            requesters.add(commitVersionListenerRegistrationRequester);
        }
        IRequester linkDataReqeuster = new IRequester(){

            @Override
            public EOClientRequest getRequest() {
                return new EOClientRequest("frame.link", "frame.GetAllLinks", (EncodableObjectBase)new EOValue(FrameServerProxy.this.projectAgent.getUID()));
            }

            @Override
            public void setResponse(EOServerResponse response) {
                EOList linkData = (EOList)response.getResponseData();
                linkData.setRole("links");
                importData.add((EncodableObjectBase)linkData);
            }
        };
        requesters.add(userDefAttr);
        requesters.add(fileMetaInformation);
        requesters.add(objectTypeCategoriesRequest);
        requesters.add(plans);
        requesters.add(sections);
        requesters.add(uniqueElements);
        requesters.add(uniqueElementsOccurrences);
        requesters.add(uniqueElementsRelationships);
        requesters.add(stakeholders);
        requesters.add(roles);
        requesters.add(stakeholderRoleConnections);
        requesters.add(reportTemplateFolders);
        requesters.add(reportTemplates);
        requesters.add(reportOutputtemplates);
        requesters.add(lastCommitInformationRequester);
        requesters.add(workspacesOnServerRequester);
        requesters.add(workspaceUID_locks_request);
        requesters.add(logLockRequester);
        requesters.add(linkDataReqeuster);
        EOList requests = new EOList();
        ListIterator i = requesters.listIterator();
        while (i.hasNext()) {
            IRequester requester = (IRequester)i.next();
            requests.add((EncodableObjectBase)requester.getRequest());
        }
        EOClientRequest request = new EOClientRequest("setOfRequests", "", (EncodableObjectBase)requests);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
        EOList responses = (EOList)response.getResponseData();
        int i2 = 0;
        while (i2 < responses.size()) {
            EOServerResponse serverResponse = (EOServerResponse)responses.get(i2);
            IRequester requester = (IRequester)requesters.get(i2);
            requester.setResponse(serverResponse);
            ++i2;
        }
        return new ServerDataContainer(this.projectAgent, commitInformations[0], workspaceInformations, workspaceUID_locks, lockLog, importData);
    }

    public boolean supportsVersioning() {
        return true;
    }

    public EOCockpitProjectData getVersion(String itemUID, String typeID, int modCount, String requestGroupID) {
        EOGetHistoricItemParameter param = new EOGetHistoricItemParameter();
        param.setProjectUID(this.projectAgent.getProjectUID());
        param.setDataUID(itemUID);
        param.setTypeID(typeID);
        param.setVersion(modCount);
        EOCockpitProjectData historicItem = null;
        try {
            EOServerResponse response = this.projectAgent.getModuleServerProxy().sendRequest(requestGroupID, "frame.any.gethistoricitem", (EncodableObjectBase)param);
            if (response != null) {
                historicItem = (EOCockpitProjectData)response.getResponseData();
            }
        }
        catch (Exception e) {
            logger.error("getVersion() - Error on retrieving a historic item from the server", (Throwable)e);
        }
        if (historicItem == null) {
            logger.warn("getVersion() - Null item retrieved.");
            return null;
        }
        return historicItem;
    }

    public List<EOCockpitProjectData> getAllVersions(String itemUID, String typeID, String requestGroupID) {
        EOGetHistoricItemParameter param = new EOGetHistoricItemParameter();
        param.setProjectUID(this.projectAgent.getProjectUID());
        param.setDataUID(itemUID);
        param.setTypeID(typeID);
        EOList historicItems = null;
        try {
            EOServerResponse response = this.projectAgent.getModuleServerProxy().sendRequest(requestGroupID, "frame.any.getallhistoricversions", (EncodableObjectBase)param);
            if (response != null) {
                historicItems = (EOList)response.getResponseData();
            }
        }
        catch (Exception e) {
            logger.error("getAllVersions() - Error on retrieving the historic versions of an item from the server", (Throwable)e);
        }
        if (historicItems == null) {
            logger.warn("getAllVersions() - Null item retrieved.");
            return null;
        }
        return historicItems;
    }

    public String getAvailabilityState() {
        return null;
    }

    public boolean fileExistsOnServer(FileID fileID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOFileID eoFileID = new EOFileID(fileID.getFileUID());
        EOFileRequestParameter param = new EOFileRequestParameter(eoFileID, this.projectAgent.getUID());
        EOClientRequest req = new EOClientRequest("frame.files", "frame.files.checkExistens", (EncodableObjectBase)param);
        EOServerResponse response = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        EOValue responseValue = (EOValue)response.getResponseData();
        return responseValue.getBooleanValue();
    }

    public void downloadFile(FileID fileID, File file) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        EOFileID eoFileID = new EOFileID(fileID.getFileUID());
        EOFileRequestParameter param = new EOFileRequestParameter(eoFileID, this.projectAgent.getUID());
        EOClientRequest req = new EOClientRequest("frame.files", "frame.files.getDownloadID", (EncodableObjectBase)param);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        if (res.getResponseData() instanceof EOValue) {
            EOValue v = (EOValue)res.getResponseData();
            String transferID = v.getValue();
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<File> files = new ArrayList<File>();
            ids.add(transferID);
            files.add(file);
            PSCServices.getServiceFacade().downloadFiles(this.serverID, ids, files);
        }
    }

    public List<String> uploadFiles(List<File> files) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        EOValue numberOfFiles = new EOValue(Integer.toString(files.size()));
        EOClientRequest req = new EOClientRequest("frame.files", "frame.files.getUploadIDs", (EncodableObjectBase)numberOfFiles);
        EOServerResponse res = PSCServices.getServiceFacade().sendRequest(this.serverID, req);
        List eoTransferIDs = (List)res.getResponseData();
        ArrayList<String> transferIDs = new ArrayList<String>();
        for (EOValue transferID : eoTransferIDs) {
            transferIDs.add(transferID.getValue());
        }
        PSCServices.getServiceFacade().uploadFiles(this.serverID, transferIDs, files);
        return transferIDs;
    }

    public void refreshProject() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        Display display = Display.getCurrent();
        assert (display == Display.getDefault());
        EOClientRequest enquiryRequest = new EOClientRequest("Notification", "KeepAlive", null);
        PSCClientServiceFacade.getFacade().sendRequest(this.serverID, enquiryRequest);
        PSCClientServiceFacade.getFacade().deliverAsynchronousUpdatesNow(this.serverID);
    }

    public EOList<EOPlatformLock> allocateLocks(Collection<EOPlatformLock> locksToCheck, Collection<EOPlatformLock> locksToRelease, Collection<EOPlatformLock> locksToAllocate) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOList toCheck = new EOList(locksToCheck);
        EOList toRelease = new EOList(locksToRelease);
        EOList toAllocate = new EOList(locksToAllocate);
        EOList param = new EOList(this.projectAgent.getProjectUID());
        param.add((EncodableObjectBase)this.projectAgent.getCockpitController().getWorkspaceInformation());
        param.add((EncodableObjectBase)toCheck);
        param.add((EncodableObjectBase)toRelease);
        param.add((EncodableObjectBase)toAllocate);
        EOClientRequest request = new EOClientRequest("plaform.locks", "allocatePlatformLocks", (EncodableObjectBase)param);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
        EncodableObjectBase responseData = response.getResponseData();
        if (responseData instanceof EOList) {
            return (EOList)responseData;
        }
        return null;
    }

    public ServerDataContainer fetchServerDataContainer(Collection<EOLock> allLocksCurrentlyAllocatedOnServer) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable, EXPendingAsynchronousUpdates {
        return this.trySetupAfterDataManagersAreCreated(allLocksCurrentlyAllocatedOnServer, false);
    }

    public ServerDataContainer setupAfterDataManagersAreCreated() throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXOfflineDataNotAvailable, ExRetryProjectOpen {
        boolean registerForNotificationsAndDontCheckForPendingAsynchronousUpdates = true;
        Collection allLocksCurrentlyAllocatedOnServer = this.projectAgent.getLockManager().getAllLocksCurrentlyAllocatedOnServer();
        try {
            return this.trySetupAfterDataManagersAreCreated(allLocksCurrentlyAllocatedOnServer, true);
        }
        catch (EXServerException openException) {
            boolean checkForStaleCommitLocksCompletedNormally = false;
            try {
                try {
                    CommitProgressDetector.checkForStaleCommitLocksAndProposeSecondAttempt(this.serverID, this.projectAgent, allLocksCurrentlyAllocatedOnServer, openException);
                    checkForStaleCommitLocksCompletedNormally = true;
                }
                catch (ExRetryProjectOpen e) {
                    checkForStaleCommitLocksCompletedNormally = true;
                    throw e;
                }
            }
            finally {
                if (!checkForStaleCommitLocksCompletedNormally) {
                    logger.debug("Check for stale commit locks did not complete normally:", (Throwable)openException);
                }
            }
            throw openException;
        }
    }

    public static class FrameDataRequester
    implements IRequester {
        private final String projectUID;
        private final String dataTypeUID;
        private final Collection dataContainer;

        private FrameDataRequester(String projectUID, String dataTypeUID, Collection dataContainer) {
            this.projectUID = projectUID;
            this.dataTypeUID = dataTypeUID;
            this.dataContainer = dataContainer;
        }

        @Override
        public EOClientRequest getRequest() {
            return FrameDataRequester.getRequest(this.projectUID, this.dataTypeUID);
        }

        public static EOClientRequest getRequest(String projectUID, String dataTypeUID) {
            EOList parameter = new EOList();
            EOString projectUIDEO = new EOString(projectUID, "parameter.1");
            EOString dataTypeIDEO = new EOString(dataTypeUID, "parameter.2");
            parameter.add((EncodableObjectBase)projectUIDEO);
            parameter.add((EncodableObjectBase)dataTypeIDEO);
            return new EOClientRequest("frame.framedata", "frame.framedata.getalldata", (EncodableObjectBase)parameter);
        }

        @Override
        public void setResponse(EOServerResponse response) {
            EOList list = (EOList)response.getResponseData();
            list.setRole(this.dataTypeUID);
            this.dataContainer.add(list);
        }
    }

    private static interface IRequester {
        public EOClientRequest getRequest();

        public void setResponse(EOServerResponse var1);
    }
}

