/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.frame.client.global.license.AbstractClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.ClientLicenseFilesManager;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicense;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.ILicenseChangeListener;
import com.arcway.cockpit.frameserverproxy.client.LocalClientProductLicenseManager;
import com.arcway.cockpit.frameserverproxy.client.ProjectManagerServerProxy;
import com.arcway.cockpit.frameserverproxy.gui.Messages;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.lic.UserLicense;
import de.plans.psc.client.PSCClientLicenseInfo;
import java.sql.Timestamp;

public class ClientProductLicenseManagerWithServerConnection
extends AbstractClientProductLicenseManager {
    private static final String PROPERTY_KEY_SERVER_LICENSE_TYPE = "cockpit.serverLicenseType";
    private static IClientProductLicenseType clientProductLicenseTypeRequestedFromServer = ClientProductLicenseTypes.FULL_LICENSE;
    private final ProjectManagerServerProxy serverProxy;
    private final boolean isOffline;

    static {
        String serverLicenseType = System.getProperty(PROPERTY_KEY_SERVER_LICENSE_TYPE);
        if (ClientProductLicenseTypes.READER_LICENSE_CS.getProductID().equals(serverLicenseType)) {
            clientProductLicenseTypeRequestedFromServer = ClientProductLicenseTypes.READER_LICENSE_CS;
        }
    }

    public static final void initialisePSCLicenseSettings() {
        ClientProductLicenseManagerWithServerConnection.configurePSCAccordingToCurrentClientLicenseStatus();
        LocalClientProductLicenseManager.getDefault().addLicenseChangeListener(new ILicenseChangeListener(){

            public void productOrModuleLicensesChanged() {
                ClientProductLicenseManagerWithServerConnection.configurePSCAccordingToCurrentClientLicenseStatus();
            }
        });
    }

    private static final void configurePSCAccordingToCurrentClientLicenseStatus() {
        boolean runWithClientLicense = false;
        String serverApplicationID = clientProductLicenseTypeRequestedFromServer.getProductID();
        for (IClientProductLicense license : LocalClientProductLicenseManager.getDefault().getProductLicenses()) {
            if (runWithClientLicense && !serverApplicationID.equals(license.getType().getBaseProductID())) {
                Logger.getLogger(ClientProductLicenseManagerWithServerConnection.class).warn("Licenses for different applications are deployed in the client: " + serverApplicationID + " and " + license.getType().getBaseProductID() + ". All licenses will be ignored.");
                runWithClientLicense = false;
                serverApplicationID = null;
                break;
            }
            runWithClientLicense = true;
            serverApplicationID = license.getType().getBaseProductID();
        }
        PSCClientLicenseInfo clientLicenseSetting = new PSCClientLicenseInfo(runWithClientLicense, serverApplicationID);
        PSCServices.getServiceFacade().setClientLicenseSetting(clientLicenseSetting);
    }

    public ClientProductLicenseManagerWithServerConnection(ProjectManagerServerProxy serverProxy, boolean isOffline) {
        this.serverProxy = serverProxy;
        this.isOffline = isOffline;
        this.determineLicenses();
        LocalClientProductLicenseManager.getDefault().addLicenseChangeListener(new ILicenseChangeListener(){

            public void productOrModuleLicensesChanged() {
                ClientProductLicenseManagerWithServerConnection.this.determineLicenses();
                ClientProductLicenseManagerWithServerConnection.this.notifyLicenseChangeListeners();
            }
        });
    }

    private final void determineLicenses() {
        this.clearProductAndModuleLicenses();
        if (this.isOffline || this.serverProxy.getEffectiveLicenseSetting().getLicenseStatus() == 1) {
            this.activateProductAndModuleLicenses((AbstractClientProductLicenseManager)LocalClientProductLicenseManager.getDefault());
        } else if (!this.isOffline && this.serverProxy.getEffectiveLicenseSetting().getLicenseStatus() == 2) {
            ClientProductLicense serverLicense = new ClientProductLicense(clientProductLicenseTypeRequestedFromServer, new Timestamp(System.currentTimeMillis()), null, String.valueOf(Messages.getString("LicensesPreferencePage.server")) + this.serverProxy.getServerName());
            this.activateProductLicense((IClientProductLicense)serverLicense);
            this.activateModuleLicenses(new UserLicense(clientProductLicenseTypeRequestedFromServer.getProductID(), 1, System.currentTimeMillis(), -1L), ClientLicenseFilesManager.getDefault().getModuleLicenses(clientProductLicenseTypeRequestedFromServer.getProductID()), Messages.getString("LicensesPreferencePage.local_license_file"));
            this.activateModuleLicenses(null, ClientLicenseFilesManager.getDefault().getModuleLicenses("independant-additional-module"), Messages.getString("LicensesPreferencePage.local_license_file"));
        }
    }
}

