/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholderRole;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import java.util.HashMap;
import java.util.Map;

public class EOStakeholderModification
extends EOEncodableObject {
    public static final String XML_NAME = "frame.stakeholdermodification";
    public static final String XML_ROLE_ADDED_STAKEHOLDERS = "addedStakeholders";
    public static final String XML_ROLE_DELETED_STAKEHOLDERS = "deletedStakeholders";
    public static final String XML_ROLE_MODIFIED_STAKEHOLDERS = "modifiedStakeholders";
    public static final String XML_ROLE_ADDED_ROLES = "addedRoles";
    public static final String XML_ROLE_DELETED_ROLES = "deletedRoles";
    public static final String XML_ROLE_MODIFIED_ROLES = "modifiedRoles";
    public static final String XML_ROLE_ADDED_CONNECTIONS = "addedConnections";
    public static final String XML_ROLE_DELETED_CONNECTIONS = "deletedConnections";
    private boolean includeIsDirty = false;
    private final EOBoolean isDirty = new EOBoolean(Boolean.FALSE);
    private final Map modifications = new HashMap();

    public EOStakeholderModification() {
        this(false);
    }

    public EOStakeholderModification(boolean includeIsDirty) {
        super(XML_NAME);
        this.includeIsDirty = includeIsDirty;
        this.init();
    }

    public EOStakeholderModification(XMLContext attr) {
        super(XML_NAME, attr);
        this.init();
    }

    private void init() {
        EOList list = new EOList();
        list.setRole(XML_ROLE_ADDED_CONNECTIONS);
        this.modifications.put(XML_ROLE_ADDED_CONNECTIONS, list);
        list = new EOList();
        list.setRole(XML_ROLE_ADDED_ROLES);
        this.modifications.put(XML_ROLE_ADDED_ROLES, list);
        list = new EOList();
        list.setRole(XML_ROLE_ADDED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_ADDED_STAKEHOLDERS, list);
        list = new EOList();
        list.setRole(XML_ROLE_DELETED_CONNECTIONS);
        this.modifications.put(XML_ROLE_DELETED_CONNECTIONS, list);
        list = new EOList();
        list.setRole(XML_ROLE_DELETED_ROLES);
        this.modifications.put(XML_ROLE_DELETED_ROLES, list);
        list = new EOList();
        list.setRole(XML_ROLE_DELETED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_DELETED_STAKEHOLDERS, list);
        list = new EOList();
        list.setRole(XML_ROLE_MODIFIED_ROLES);
        this.modifications.put(XML_ROLE_MODIFIED_ROLES, list);
        list = new EOList();
        list.setRole(XML_ROLE_MODIFIED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_MODIFIED_STAKEHOLDERS, list);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    protected boolean setAttributeFromXML(String name, String value) {
        return true;
    }

    protected boolean hasChildren() {
        return this.modifications.size() > 0;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.includeIsDirty) {
            this.isDirty.writeXMLBody(writeContext, depth);
        }
        for (EOList list : this.modifications.values()) {
            list.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        assert (newChild instanceof EOList || newChild instanceof EOBoolean);
        if (newChild instanceof EOBoolean) {
            this.isDirty.setBoolean(((EOBoolean)newChild).getBoolean());
            return true;
        }
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            this.modifications.put(list.getRole(), list);
            return true;
        }
        return false;
    }

    public void setIsDirty(boolean isDirty) {
        this.isDirty.setBoolean(Boolean.valueOf(isDirty));
    }

    public boolean isDirty() {
        return this.isDirty.getBoolean();
    }

    public EOList<EOStakeholder> getAddedStakeholders() {
        return this.getList(XML_ROLE_ADDED_STAKEHOLDERS);
    }

    public EOList<EOStakeholder> getDeletedStakeholders() {
        return this.getList(XML_ROLE_DELETED_STAKEHOLDERS);
    }

    public EOList<EOStakeholder> getModifiedStakeholders() {
        return this.getList(XML_ROLE_MODIFIED_STAKEHOLDERS);
    }

    public EOList<EOStakeholderRole> getAddedRoles() {
        return this.getList(XML_ROLE_ADDED_ROLES);
    }

    public EOList<EOStakeholderRole> getDeletedRoles() {
        return this.getList(XML_ROLE_DELETED_ROLES);
    }

    public EOList<EOStakeholderRole> getModfiedRoles() {
        return this.getList(XML_ROLE_MODIFIED_ROLES);
    }

    public EOList<EORoleAndStakeholder> getAddedConnections() {
        return this.getList(XML_ROLE_ADDED_CONNECTIONS);
    }

    public EOList<EORoleAndStakeholder> getDeletedConnections() {
        return this.getList(XML_ROLE_DELETED_CONNECTIONS);
    }

    private EOList getList(String role) {
        return new EOList((EOList)this.modifications.get(role));
    }

    public void setAddedStakeholders(EOList stakeholders) {
        stakeholders.setRole(XML_ROLE_ADDED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_ADDED_STAKEHOLDERS, stakeholders);
    }

    public void setDeletedStakeholders(EOList stakeholders) {
        stakeholders.setRole(XML_ROLE_DELETED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_DELETED_STAKEHOLDERS, stakeholders);
    }

    public void setModifiedStakeholders(EOList stakeholders) {
        stakeholders.setRole(XML_ROLE_MODIFIED_STAKEHOLDERS);
        this.modifications.put(XML_ROLE_MODIFIED_STAKEHOLDERS, stakeholders);
    }

    public void setAddedRoles(EOList roles) {
        roles.setRole(XML_ROLE_ADDED_ROLES);
        this.modifications.put(XML_ROLE_ADDED_ROLES, roles);
    }

    public void setDeletedRoles(EOList roles) {
        roles.setRole(XML_ROLE_DELETED_ROLES);
        this.modifications.put(XML_ROLE_DELETED_ROLES, roles);
    }

    public void setModifiedRoles(EOList roles) {
        roles.setRole(XML_ROLE_MODIFIED_ROLES);
        this.modifications.put(XML_ROLE_MODIFIED_ROLES, roles);
    }

    public void setAddedConnections(EOList connections) {
        connections.setRole(XML_ROLE_ADDED_CONNECTIONS);
        this.modifications.put(XML_ROLE_ADDED_CONNECTIONS, connections);
    }

    public void setDeletedConnections(EOList connections) {
        connections.setRole(XML_ROLE_DELETED_CONNECTIONS);
        this.modifications.put(XML_ROLE_DELETED_CONNECTIONS, connections);
    }
}

