/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;

public class EOLock
extends EOEncodableObject {
    public static final String XML_NAME = "frame.lock";
    private String lockUID;
    private String projectUID;
    private String lockTypeID;
    private String lockedItemUID;
    private String lockedItemType;
    private String clientName;
    private String userName;
    private Timestamp creationTime;
    private static final String ATTR_TAG_LOCK_UID = "lockuid";
    private static final String ATTR_TAG_PROJECT_UID = "projectuid";
    private static final String ATTR_TAG_LOCK_TYPE_ID = "locktypeid";
    private static final String ATTR_TAG_LOCKED_ITEM_UID = "lockeditemuid";
    private static final String ATTR_TAG_LOCKED_ITEM_TYPE = "lockeditemtype";
    private static final String ATTR_TAG_CLIENT_NAME = "clientname";
    private static final String ATTR_TAG_USER_NAME = "username";
    private static final String ATTR_TAG_CREATION_TIME = "creationtime";

    public EOLock(String lockUID, String projectUID, String lockTypeID, String lockedItemUID, String lockedItemType, String clientName, String userName, Timestamp creationTime) {
        super(XML_NAME);
        assert (lockTypeID != null);
        assert (lockedItemUID != null);
        assert (lockedItemType != null);
        assert (!lockTypeID.trim().equals(""));
        this.lockUID = lockUID;
        this.projectUID = projectUID;
        this.lockTypeID = lockTypeID;
        this.lockedItemUID = lockedItemUID;
        this.lockedItemType = lockedItemType;
        assert (lockedItemType.length() < 256);
        this.clientName = clientName;
        this.userName = userName;
        this.creationTime = creationTime;
    }

    public EOLock(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        assert (this.lockedItemType.length() < 255);
        this.appendAttrToXML(writeContext, ATTR_TAG_LOCK_UID, this.lockUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LOCK_TYPE_ID, this.lockTypeID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LOCKED_ITEM_UID, this.lockedItemUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_LOCKED_ITEM_TYPE, this.lockedItemType);
        this.appendAttrToXML(writeContext, ATTR_TAG_CLIENT_NAME, this.clientName);
        this.appendAttrToXML(writeContext, ATTR_TAG_USER_NAME, this.userName);
        this.appendAttrToXML(writeContext, ATTR_TAG_CREATION_TIME, this.creationTime);
    }

    protected boolean setAttributeFromXML(String name, String p_value) {
        String value = p_value == null || p_value.trim().equals("null") ? null : p_value.trim();
        boolean success = true;
        if (name.equals(ATTR_TAG_LOCK_UID)) {
            this.lockUID = value;
        } else if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(ATTR_TAG_LOCK_TYPE_ID)) {
            this.lockTypeID = value;
        } else if (name.equals(ATTR_TAG_LOCKED_ITEM_UID)) {
            this.lockedItemUID = value;
        } else if (name.equals(ATTR_TAG_LOCKED_ITEM_TYPE)) {
            this.lockedItemType = value;
            assert (this.lockedItemType.length() < 255);
        } else if (name.equals(ATTR_TAG_CLIENT_NAME)) {
            this.clientName = value;
        } else if (name.equals(ATTR_TAG_USER_NAME)) {
            this.userName = value;
        } else if (name.equals(ATTR_TAG_CREATION_TIME)) {
            if (value != null) {
                this.creationTime = Timestamp.valueOf(value);
            }
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean hasChildren() {
        return false;
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getUID() {
        return this.lockUID;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public String getLockTypeID() {
        return this.lockTypeID;
    }

    public String getLockedItemUID() {
        return this.lockedItemUID;
    }

    public String getLockedItemType() {
        assert (this.lockedItemType.length() < 256);
        return this.lockedItemType;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        assert (clientName != null) : "clientName can't be null!";
        this.clientName = clientName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        assert (userName != null) : "userName can't be null!";
        this.userName = userName;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }
}

